package io.fabric8.kubernetes.api.model.apps;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.model.PodTemplateSpec;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl;
import java.lang.Integer;
import io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder;
import java.util.Collection;
import io.fabric8.kubernetes.api.model.PersistentVolumeClaim;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
public class StatefulSetSpecFluentImpl<A extends io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent<A>{
  public StatefulSetSpecFluentImpl() {
  }
  public StatefulSetSpecFluentImpl(io.fabric8.kubernetes.api.model.apps.StatefulSetSpec instance) {
    this.withMinReadySeconds(instance.getMinReadySeconds()); 
    this.withPodManagementPolicy(instance.getPodManagementPolicy()); 
    this.withReplicas(instance.getReplicas()); 
    this.withRevisionHistoryLimit(instance.getRevisionHistoryLimit()); 
    this.withSelector(instance.getSelector()); 
    this.withServiceName(instance.getServiceName()); 
    this.withTemplate(instance.getTemplate()); 
    this.withUpdateStrategy(instance.getUpdateStrategy()); 
    this.withVolumeClaimTemplates(instance.getVolumeClaimTemplates()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private java.lang.Integer minReadySeconds;
  private java.lang.String podManagementPolicy;
  private java.lang.Integer replicas;
  private java.lang.Integer revisionHistoryLimit;
  private io.fabric8.kubernetes.api.model.LabelSelectorBuilder selector;
  private java.lang.String serviceName;
  private io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder template;
  private io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyBuilder updateStrategy;
  private java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> volumeClaimTemplates =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder>();
  private java.util.Map<java.lang.String,java.lang.Object> additionalProperties;
  public java.lang.Integer getMinReadySeconds() {
    return this.minReadySeconds;
  }
  public A withMinReadySeconds(java.lang.Integer minReadySeconds) {
    this.minReadySeconds=minReadySeconds; return (A) this;
  }
  public java.lang.Boolean hasMinReadySeconds() {
    return this.minReadySeconds != null;
  }
  public java.lang.String getPodManagementPolicy() {
    return this.podManagementPolicy;
  }
  public A withPodManagementPolicy(java.lang.String podManagementPolicy) {
    this.podManagementPolicy=podManagementPolicy; return (A) this;
  }
  public java.lang.Boolean hasPodManagementPolicy() {
    return this.podManagementPolicy != null;
  }
  
  /**
   * Method is deprecated. use withPodManagementPolicy instead.
   */
  @java.lang.Deprecated
  public A withNewPodManagementPolicy(java.lang.String arg0) {
    return (A)withPodManagementPolicy(new String(arg0));
  }
  public java.lang.Integer getReplicas() {
    return this.replicas;
  }
  public A withReplicas(java.lang.Integer replicas) {
    this.replicas=replicas; return (A) this;
  }
  public java.lang.Boolean hasReplicas() {
    return this.replicas != null;
  }
  public java.lang.Integer getRevisionHistoryLimit() {
    return this.revisionHistoryLimit;
  }
  public A withRevisionHistoryLimit(java.lang.Integer revisionHistoryLimit) {
    this.revisionHistoryLimit=revisionHistoryLimit; return (A) this;
  }
  public java.lang.Boolean hasRevisionHistoryLimit() {
    return this.revisionHistoryLimit != null;
  }
  
  /**
   * This method has been deprecated, please use method buildSelector instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.LabelSelector getSelector() {
    return this.selector!=null?this.selector.build():null;
  }
  public io.fabric8.kubernetes.api.model.LabelSelector buildSelector() {
    return this.selector!=null?this.selector.build():null;
  }
  public A withSelector(io.fabric8.kubernetes.api.model.LabelSelector selector) {
    _visitables.get("selector").remove(this.selector);
    if (selector!=null){ this.selector= new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(selector); _visitables.get("selector").add(this.selector);} return (A) this;
  }
  public java.lang.Boolean hasSelector() {
    return this.selector != null;
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> withNewSelector() {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluentImpl.SelectorNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> withNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluentImpl.SelectorNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> editSelector() {
    return withNewSelectorLike(getSelector());
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> editOrNewSelector() {
    return withNewSelectorLike(getSelector() != null ? getSelector(): new io.fabric8.kubernetes.api.model.LabelSelectorBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<A> editOrNewSelectorLike(io.fabric8.kubernetes.api.model.LabelSelector item) {
    return withNewSelectorLike(getSelector() != null ? getSelector(): item);
  }
  public java.lang.String getServiceName() {
    return this.serviceName;
  }
  public A withServiceName(java.lang.String serviceName) {
    this.serviceName=serviceName; return (A) this;
  }
  public java.lang.Boolean hasServiceName() {
    return this.serviceName != null;
  }
  
  /**
   * Method is deprecated. use withServiceName instead.
   */
  @java.lang.Deprecated
  public A withNewServiceName(java.lang.String arg0) {
    return (A)withServiceName(new String(arg0));
  }
  
  /**
   * This method has been deprecated, please use method buildTemplate instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.PodTemplateSpec getTemplate() {
    return this.template!=null?this.template.build():null;
  }
  public io.fabric8.kubernetes.api.model.PodTemplateSpec buildTemplate() {
    return this.template!=null?this.template.build():null;
  }
  public A withTemplate(io.fabric8.kubernetes.api.model.PodTemplateSpec template) {
    _visitables.get("template").remove(this.template);
    if (template!=null){ this.template= new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(template); _visitables.get("template").add(this.template);} return (A) this;
  }
  public java.lang.Boolean hasTemplate() {
    return this.template != null;
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> withNewTemplate() {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluentImpl.TemplateNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> withNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluentImpl.TemplateNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> editTemplate() {
    return withNewTemplateLike(getTemplate());
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplate() {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<A> editOrNewTemplateLike(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
    return withNewTemplateLike(getTemplate() != null ? getTemplate(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildUpdateStrategy instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy getUpdateStrategy() {
    return this.updateStrategy!=null?this.updateStrategy.build():null;
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy buildUpdateStrategy() {
    return this.updateStrategy!=null?this.updateStrategy.build():null;
  }
  public A withUpdateStrategy(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy updateStrategy) {
    _visitables.get("updateStrategy").remove(this.updateStrategy);
    if (updateStrategy!=null){ this.updateStrategy= new io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyBuilder(updateStrategy); _visitables.get("updateStrategy").add(this.updateStrategy);} return (A) this;
  }
  public java.lang.Boolean hasUpdateStrategy() {
    return this.updateStrategy != null;
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategy() {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluentImpl.UpdateStrategyNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> withNewUpdateStrategyLike(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy item) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluentImpl.UpdateStrategyNestedImpl(item);
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> editUpdateStrategy() {
    return withNewUpdateStrategyLike(getUpdateStrategy());
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategy() {
    return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): new io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyBuilder().build());
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<A> editOrNewUpdateStrategyLike(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy item) {
    return withNewUpdateStrategyLike(getUpdateStrategy() != null ? getUpdateStrategy(): item);
  }
  public A addToVolumeClaimTemplates(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder>();}
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").add(index >= 0 ? index : _visitables.get("volumeClaimTemplates").size(), builder);this.volumeClaimTemplates.add(index >= 0 ? index : volumeClaimTemplates.size(), builder); return (A)this;
  }
  public A setToVolumeClaimTemplates(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder>();}
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);
    if (index < 0 || index >= _visitables.get("volumeClaimTemplates").size()) { _visitables.get("volumeClaimTemplates").add(builder); } else { _visitables.get("volumeClaimTemplates").set(index, builder);}
    if (index < 0 || index >= volumeClaimTemplates.size()) { volumeClaimTemplates.add(builder); } else { volumeClaimTemplates.set(index, builder);}
     return (A)this;
  }
  public A addToVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder>();}
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").add(builder);this.volumeClaimTemplates.add(builder);} return (A)this;
  }
  public A addAllToVolumeClaimTemplates(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items) {
    if (this.volumeClaimTemplates == null) {this.volumeClaimTemplates = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder>();}
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").add(builder);this.volumeClaimTemplates.add(builder);} return (A)this;
  }
  public A removeFromVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... items) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").remove(builder);if (this.volumeClaimTemplates != null) {this.volumeClaimTemplates.remove(builder);}} return (A)this;
  }
  public A removeAllFromVolumeClaimTemplates(java.util.Collection<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> items) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : items) {io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(item);_visitables.get("volumeClaimTemplates").remove(builder);if (this.volumeClaimTemplates != null) {this.volumeClaimTemplates.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVolumeClaimTemplates(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> predicate) {
    if (volumeClaimTemplates == null) return (A) this;
    final Iterator<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> each = volumeClaimTemplates.iterator();
    final List visitables = _visitables.get("volumeClaimTemplates");
    while (each.hasNext()) {
      io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVolumeClaimTemplates instead.
   * @return The buildable object.
   */
  @java.lang.Deprecated
  public java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> getVolumeClaimTemplates() {
    return build(volumeClaimTemplates);
  }
  public java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> buildVolumeClaimTemplates() {
    return build(volumeClaimTemplates);
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildVolumeClaimTemplate(java.lang.Integer index) {
    return this.volumeClaimTemplates.get(index).build();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildFirstVolumeClaimTemplate() {
    return this.volumeClaimTemplates.get(0).build();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildLastVolumeClaimTemplate() {
    return this.volumeClaimTemplates.get(volumeClaimTemplates.size() - 1).build();
  }
  public io.fabric8.kubernetes.api.model.PersistentVolumeClaim buildMatchingVolumeClaimTemplate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder item: volumeClaimTemplates) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public java.lang.Boolean hasMatchingVolumeClaimTemplate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> predicate) {
    for (io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder item: volumeClaimTemplates) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVolumeClaimTemplates(java.util.List<io.fabric8.kubernetes.api.model.PersistentVolumeClaim> volumeClaimTemplates) {
    if (this.volumeClaimTemplates != null) { _visitables.get("volumeClaimTemplates").removeAll(this.volumeClaimTemplates);}
    if (volumeClaimTemplates != null) {this.volumeClaimTemplates = new java.util.ArrayList<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder>(); for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item : volumeClaimTemplates){this.addToVolumeClaimTemplates(item);}} else { this.volumeClaimTemplates = null;} return (A) this;
  }
  public A withVolumeClaimTemplates(io.fabric8.kubernetes.api.model.PersistentVolumeClaim... volumeClaimTemplates) {
    if (this.volumeClaimTemplates != null) {this.volumeClaimTemplates.clear();}
    if (volumeClaimTemplates != null) {for (io.fabric8.kubernetes.api.model.PersistentVolumeClaim item :volumeClaimTemplates){ this.addToVolumeClaimTemplates(item);}} return (A) this;
  }
  public java.lang.Boolean hasVolumeClaimTemplates() {
    return volumeClaimTemplates != null && !volumeClaimTemplates.isEmpty();
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplate() {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluentImpl.VolumeClaimTemplatesNestedImpl();
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> addNewVolumeClaimTemplateLike(io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluentImpl.VolumeClaimTemplatesNestedImpl(-1, item);
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> setNewVolumeClaimTemplateLike(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
    return new io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluentImpl.VolumeClaimTemplatesNestedImpl(index, item);
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editVolumeClaimTemplate(java.lang.Integer index) {
    if (volumeClaimTemplates.size() <= index) throw new RuntimeException("Can't edit volumeClaimTemplates. Index exceeds size.");
    return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editFirstVolumeClaimTemplate() {
    if (volumeClaimTemplates.size() == 0) throw new RuntimeException("Can't edit first volumeClaimTemplates. The list is empty.");
    return setNewVolumeClaimTemplateLike(0, buildVolumeClaimTemplate(0));
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editLastVolumeClaimTemplate() {
    int index = volumeClaimTemplates.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last volumeClaimTemplates. The list is empty.");
    return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
  }
  public io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<A> editMatchingVolumeClaimTemplate(java.util.function.Predicate<io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder> predicate) {
    int index = -1;
    for (int i=0;i<volumeClaimTemplates.size();i++) { 
    if (predicate.test(volumeClaimTemplates.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching volumeClaimTemplates. No match found.");
    return setNewVolumeClaimTemplateLike(index, buildVolumeClaimTemplate(index));
  }
  public A addToAdditionalProperties(java.lang.String key,java.lang.Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.lang.String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public java.util.Map<java.lang.String,java.lang.Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(java.util.Map<java.lang.String,java.lang.Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new java.util.LinkedHashMap<java.lang.String,java.lang.Object>(additionalProperties);} return (A) this;
  }
  public java.lang.Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(java.lang.Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    StatefulSetSpecFluentImpl that = (StatefulSetSpecFluentImpl) o;
    if (minReadySeconds != null ? !minReadySeconds.equals(that.minReadySeconds) :that.minReadySeconds != null) return false;
    if (podManagementPolicy != null ? !podManagementPolicy.equals(that.podManagementPolicy) :that.podManagementPolicy != null) return false;
    if (replicas != null ? !replicas.equals(that.replicas) :that.replicas != null) return false;
    if (revisionHistoryLimit != null ? !revisionHistoryLimit.equals(that.revisionHistoryLimit) :that.revisionHistoryLimit != null) return false;
    if (selector != null ? !selector.equals(that.selector) :that.selector != null) return false;
    if (serviceName != null ? !serviceName.equals(that.serviceName) :that.serviceName != null) return false;
    if (template != null ? !template.equals(that.template) :that.template != null) return false;
    if (updateStrategy != null ? !updateStrategy.equals(that.updateStrategy) :that.updateStrategy != null) return false;
    if (volumeClaimTemplates != null ? !volumeClaimTemplates.equals(that.volumeClaimTemplates) :that.volumeClaimTemplates != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(minReadySeconds,  podManagementPolicy,  replicas,  revisionHistoryLimit,  selector,  serviceName,  template,  updateStrategy,  volumeClaimTemplates,  additionalProperties,  super.hashCode());
  }
  public class SelectorNestedImpl<N> extends io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl<io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<N>> implements io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.SelectorNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    SelectorNestedImpl(io.fabric8.kubernetes.api.model.LabelSelector item) {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this, item);
    }
    SelectorNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.LabelSelectorBuilder(this);
    }
    io.fabric8.kubernetes.api.model.LabelSelectorBuilder builder;
    public N and() {
      return (N) StatefulSetSpecFluentImpl.this.withSelector(builder.build());
    }
    public N endSelector() {
      return and();
    }
    
  }
  public class TemplateNestedImpl<N> extends io.fabric8.kubernetes.api.model.PodTemplateSpecFluentImpl<io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<N>> implements io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.TemplateNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    TemplateNestedImpl(io.fabric8.kubernetes.api.model.PodTemplateSpec item) {
      this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this, item);
    }
    TemplateNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PodTemplateSpecBuilder builder;
    public N and() {
      return (N) StatefulSetSpecFluentImpl.this.withTemplate(builder.build());
    }
    public N endTemplate() {
      return and();
    }
    
  }
  public class UpdateStrategyNestedImpl<N> extends io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyFluentImpl<io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<N>> implements io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.UpdateStrategyNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    UpdateStrategyNestedImpl(io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategy item) {
      this.builder = new io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyBuilder(this, item);
    }
    UpdateStrategyNestedImpl() {
      this.builder = new io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyBuilder(this);
    }
    io.fabric8.kubernetes.api.model.apps.StatefulSetUpdateStrategyBuilder builder;
    public N and() {
      return (N) StatefulSetSpecFluentImpl.this.withUpdateStrategy(builder.build());
    }
    public N endUpdateStrategy() {
      return and();
    }
    
  }
  public class VolumeClaimTemplatesNestedImpl<N> extends io.fabric8.kubernetes.api.model.PersistentVolumeClaimFluentImpl<io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>> implements io.fabric8.kubernetes.api.model.apps.StatefulSetSpecFluent.VolumeClaimTemplatesNested<N>,io.fabric8.kubernetes.api.builder.Nested<N>{
    VolumeClaimTemplatesNestedImpl(java.lang.Integer index,io.fabric8.kubernetes.api.model.PersistentVolumeClaim item) {
      this.index = index;
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this, item);
    }
    VolumeClaimTemplatesNestedImpl() {
      this.index = -1;
      this.builder = new io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder(this);
    }
    io.fabric8.kubernetes.api.model.PersistentVolumeClaimBuilder builder;
    java.lang.Integer index;
    public N and() {
      return (N) StatefulSetSpecFluentImpl.this.setToVolumeClaimTemplates(index,builder.build());
    }
    public N endVolumeClaimTemplate() {
      return and();
    }
    
  }
  
}