package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class CustomResourceDefinitionVersionBuilder extends CustomResourceDefinitionVersionFluentImpl<CustomResourceDefinitionVersionBuilder> implements VisitableBuilder<CustomResourceDefinitionVersion,CustomResourceDefinitionVersionBuilder>{
  public CustomResourceDefinitionVersionBuilder() {
    this(false);
  }
  public CustomResourceDefinitionVersionBuilder(Boolean validationEnabled) {
    this(new CustomResourceDefinitionVersion(), validationEnabled);
  }
  public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersionFluent<?> fluent) {
    this(fluent, false);
  }
  public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersionFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new CustomResourceDefinitionVersion(), validationEnabled);
  }
  public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersionFluent<?> fluent,CustomResourceDefinitionVersion instance) {
    this(fluent, instance, false);
  }
  public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersionFluent<?> fluent,CustomResourceDefinitionVersion instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns()); 
    fluent.withDeprecated(instance.getDeprecated()); 
    fluent.withDeprecationWarning(instance.getDeprecationWarning()); 
    fluent.withName(instance.getName()); 
    fluent.withSchema(instance.getSchema()); 
    fluent.withServed(instance.getServed()); 
    fluent.withStorage(instance.getStorage()); 
    fluent.withSubresources(instance.getSubresources()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersion instance) {
    this(instance,false);
  }
  public CustomResourceDefinitionVersionBuilder(CustomResourceDefinitionVersion instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns()); 
    this.withDeprecated(instance.getDeprecated()); 
    this.withDeprecationWarning(instance.getDeprecationWarning()); 
    this.withName(instance.getName()); 
    this.withSchema(instance.getSchema()); 
    this.withServed(instance.getServed()); 
    this.withStorage(instance.getStorage()); 
    this.withSubresources(instance.getSubresources()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  CustomResourceDefinitionVersionFluent<?> fluent;
  Boolean validationEnabled;
  public CustomResourceDefinitionVersion build() {
    CustomResourceDefinitionVersion buildable = new CustomResourceDefinitionVersion(fluent.getAdditionalPrinterColumns(),fluent.getDeprecated(),fluent.getDeprecationWarning(),fluent.getName(),fluent.getSchema(),fluent.getServed(),fluent.getStorage(),fluent.getSubresources());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}