package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CustomResourceDefinitionSpecFluentImpl<A extends CustomResourceDefinitionSpecFluent<A>> extends BaseFluent<A> implements CustomResourceDefinitionSpecFluent<A>{
  public CustomResourceDefinitionSpecFluentImpl() {
  }
  public CustomResourceDefinitionSpecFluentImpl(CustomResourceDefinitionSpec instance) {
    this.withConversion(instance.getConversion()); 
    this.withGroup(instance.getGroup()); 
    this.withNames(instance.getNames()); 
    this.withPreserveUnknownFields(instance.getPreserveUnknownFields()); 
    this.withScope(instance.getScope()); 
    this.withVersions(instance.getVersions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private CustomResourceConversionBuilder conversion;
  private String group;
  private CustomResourceDefinitionNamesBuilder names;
  private Boolean preserveUnknownFields;
  private String scope;
  private ArrayList<CustomResourceDefinitionVersionBuilder> versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildConversion instead.
   * @return The buildable object.
   */
  @Deprecated
  public CustomResourceConversion getConversion() {
    return this.conversion!=null ?this.conversion.build():null;
  }
  public CustomResourceConversion buildConversion() {
    return this.conversion!=null ?this.conversion.build():null;
  }
  public A withConversion(CustomResourceConversion conversion) {
    _visitables.get("conversion").remove(this.conversion);
    if (conversion!=null){ this.conversion= new CustomResourceConversionBuilder(conversion); _visitables.get("conversion").add(this.conversion);} else { this.conversion = null; _visitables.get("conversion").remove(this.conversion); } return (A) this;
  }
  public Boolean hasConversion() {
    return this.conversion != null;
  }
  public CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversion() {
    return new CustomResourceDefinitionSpecFluentImpl.ConversionNestedImpl();
  }
  public CustomResourceDefinitionSpecFluent.ConversionNested<A> withNewConversionLike(CustomResourceConversion item) {
    return new CustomResourceDefinitionSpecFluentImpl.ConversionNestedImpl(item);
  }
  public CustomResourceDefinitionSpecFluent.ConversionNested<A> editConversion() {
    return withNewConversionLike(getConversion());
  }
  public CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversion() {
    return withNewConversionLike(getConversion() != null ? getConversion(): new CustomResourceConversionBuilder().build());
  }
  public CustomResourceDefinitionSpecFluent.ConversionNested<A> editOrNewConversionLike(CustomResourceConversion item) {
    return withNewConversionLike(getConversion() != null ? getConversion(): item);
  }
  public String getGroup() {
    return this.group;
  }
  public A withGroup(String group) {
    this.group=group; return (A) this;
  }
  public Boolean hasGroup() {
    return this.group != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNames instead.
   * @return The buildable object.
   */
  @Deprecated
  public CustomResourceDefinitionNames getNames() {
    return this.names!=null ?this.names.build():null;
  }
  public CustomResourceDefinitionNames buildNames() {
    return this.names!=null ?this.names.build():null;
  }
  public A withNames(CustomResourceDefinitionNames names) {
    _visitables.get("names").remove(this.names);
    if (names!=null){ this.names= new CustomResourceDefinitionNamesBuilder(names); _visitables.get("names").add(this.names);} else { this.names = null; _visitables.get("names").remove(this.names); } return (A) this;
  }
  public Boolean hasNames() {
    return this.names != null;
  }
  public CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNames() {
    return new CustomResourceDefinitionSpecFluentImpl.NamesNestedImpl();
  }
  public CustomResourceDefinitionSpecFluent.NamesNested<A> withNewNamesLike(CustomResourceDefinitionNames item) {
    return new CustomResourceDefinitionSpecFluentImpl.NamesNestedImpl(item);
  }
  public CustomResourceDefinitionSpecFluent.NamesNested<A> editNames() {
    return withNewNamesLike(getNames());
  }
  public CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNames() {
    return withNewNamesLike(getNames() != null ? getNames(): new CustomResourceDefinitionNamesBuilder().build());
  }
  public CustomResourceDefinitionSpecFluent.NamesNested<A> editOrNewNamesLike(CustomResourceDefinitionNames item) {
    return withNewNamesLike(getNames() != null ? getNames(): item);
  }
  public Boolean getPreserveUnknownFields() {
    return this.preserveUnknownFields;
  }
  public A withPreserveUnknownFields(Boolean preserveUnknownFields) {
    this.preserveUnknownFields=preserveUnknownFields; return (A) this;
  }
  public Boolean hasPreserveUnknownFields() {
    return this.preserveUnknownFields != null;
  }
  public String getScope() {
    return this.scope;
  }
  public A withScope(String scope) {
    this.scope=scope; return (A) this;
  }
  public Boolean hasScope() {
    return this.scope != null;
  }
  public A addToVersions(Integer index,CustomResourceDefinitionVersion item) {
    if (this.versions == null) {this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();}
    CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(index >= 0 ? index : _visitables.get("versions").size(), builder);this.versions.add(index >= 0 ? index : versions.size(), builder); return (A)this;
  }
  public A setToVersions(Integer index,CustomResourceDefinitionVersion item) {
    if (this.versions == null) {this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();}
    CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
    if (index < 0 || index >= _visitables.get("versions").size()) { _visitables.get("versions").add(builder); } else { _visitables.get("versions").set(index, builder);}
    if (index < 0 || index >= versions.size()) { versions.add(builder); } else { versions.set(index, builder);}
     return (A)this;
  }
  public A addToVersions(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion... items) {
    if (this.versions == null) {this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();}
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A addAllToVersions(Collection<CustomResourceDefinitionVersion> items) {
    if (this.versions == null) {this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();}
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  public A removeFromVersions(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion... items) {
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeAllFromVersions(Collection<CustomResourceDefinitionVersion> items) {
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").remove(builder);if (this.versions != null) {this.versions.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromVersions(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
    if (versions == null) return (A) this;
    final Iterator<CustomResourceDefinitionVersionBuilder> each = versions.iterator();
    final List visitables = _visitables.get("versions");
    while (each.hasNext()) {
      CustomResourceDefinitionVersionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildVersions instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<CustomResourceDefinitionVersion> getVersions() {
    return versions != null ? build(versions) : null;
  }
  public List<CustomResourceDefinitionVersion> buildVersions() {
    return versions != null ? build(versions) : null;
  }
  public CustomResourceDefinitionVersion buildVersion(Integer index) {
    return this.versions.get(index).build();
  }
  public CustomResourceDefinitionVersion buildFirstVersion() {
    return this.versions.get(0).build();
  }
  public CustomResourceDefinitionVersion buildLastVersion() {
    return this.versions.get(versions.size() - 1).build();
  }
  public CustomResourceDefinitionVersion buildMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
    for (CustomResourceDefinitionVersionBuilder item: versions) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
    for (CustomResourceDefinitionVersionBuilder item: versions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withVersions(List<CustomResourceDefinitionVersion> versions) {
    if (this.versions != null) { _visitables.get("versions").removeAll(this.versions);}
    if (versions != null) {this.versions = new ArrayList(); for (CustomResourceDefinitionVersion item : versions){this.addToVersions(item);}} else { this.versions = null;} return (A) this;
  }
  public A withVersions(io.fabric8.kubernetes.api.model.apiextensions.v1.CustomResourceDefinitionVersion... versions) {
    if (this.versions != null) {this.versions.clear();}
    if (versions != null) {for (CustomResourceDefinitionVersion item :versions){ this.addToVersions(item);}} return (A) this;
  }
  public Boolean hasVersions() {
    return versions != null && !versions.isEmpty();
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersion() {
    return new CustomResourceDefinitionSpecFluentImpl.VersionsNestedImpl();
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> addNewVersionLike(CustomResourceDefinitionVersion item) {
    return new CustomResourceDefinitionSpecFluentImpl.VersionsNestedImpl(-1, item);
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> setNewVersionLike(Integer index,CustomResourceDefinitionVersion item) {
    return new CustomResourceDefinitionSpecFluentImpl.VersionsNestedImpl(index, item);
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> editVersion(Integer index) {
    if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> editFirstVersion() {
    if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
    return setNewVersionLike(0, buildVersion(0));
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> editLastVersion() {
    int index = versions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public CustomResourceDefinitionSpecFluent.VersionsNested<A> editMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<versions.size();i++) { 
    if (predicate.test(versions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
    return setNewVersionLike(index, buildVersion(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomResourceDefinitionSpecFluentImpl that = (CustomResourceDefinitionSpecFluentImpl) o;
    if (conversion != null ? !conversion.equals(that.conversion) :that.conversion != null) return false;
    if (group != null ? !group.equals(that.group) :that.group != null) return false;
    if (names != null ? !names.equals(that.names) :that.names != null) return false;
    if (preserveUnknownFields != null ? !preserveUnknownFields.equals(that.preserveUnknownFields) :that.preserveUnknownFields != null) return false;
    if (scope != null ? !scope.equals(that.scope) :that.scope != null) return false;
    if (versions != null ? !versions.equals(that.versions) :that.versions != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(conversion,  group,  names,  preserveUnknownFields,  scope,  versions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (conversion != null) { sb.append("conversion:"); sb.append(conversion + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (names != null) { sb.append("names:"); sb.append(names + ","); }
    if (preserveUnknownFields != null) { sb.append("preserveUnknownFields:"); sb.append(preserveUnknownFields + ","); }
    if (scope != null) { sb.append("scope:"); sb.append(scope + ","); }
    if (versions != null && !versions.isEmpty()) { sb.append("versions:"); sb.append(versions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public A withPreserveUnknownFields() {
    return withPreserveUnknownFields(true);
  }
  class ConversionNestedImpl<N> extends CustomResourceConversionFluentImpl<CustomResourceDefinitionSpecFluent.ConversionNested<N>> implements CustomResourceDefinitionSpecFluent.ConversionNested<N>,Nested<N>{
    ConversionNestedImpl(CustomResourceConversion item) {
      this.builder = new CustomResourceConversionBuilder(this, item);
    }
    ConversionNestedImpl() {
      this.builder = new CustomResourceConversionBuilder(this);
    }
    CustomResourceConversionBuilder builder;
    public N and() {
      return (N) CustomResourceDefinitionSpecFluentImpl.this.withConversion(builder.build());
    }
    public N endConversion() {
      return and();
    }
    
  }
  class NamesNestedImpl<N> extends CustomResourceDefinitionNamesFluentImpl<CustomResourceDefinitionSpecFluent.NamesNested<N>> implements CustomResourceDefinitionSpecFluent.NamesNested<N>,Nested<N>{
    NamesNestedImpl(CustomResourceDefinitionNames item) {
      this.builder = new CustomResourceDefinitionNamesBuilder(this, item);
    }
    NamesNestedImpl() {
      this.builder = new CustomResourceDefinitionNamesBuilder(this);
    }
    CustomResourceDefinitionNamesBuilder builder;
    public N and() {
      return (N) CustomResourceDefinitionSpecFluentImpl.this.withNames(builder.build());
    }
    public N endNames() {
      return and();
    }
    
  }
  class VersionsNestedImpl<N> extends CustomResourceDefinitionVersionFluentImpl<CustomResourceDefinitionSpecFluent.VersionsNested<N>> implements CustomResourceDefinitionSpecFluent.VersionsNested<N>,Nested<N>{
    VersionsNestedImpl(Integer index,CustomResourceDefinitionVersion item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionVersionBuilder(this, item);
    }
    VersionsNestedImpl() {
      this.index = -1;
      this.builder = new CustomResourceDefinitionVersionBuilder(this);
    }
    CustomResourceDefinitionVersionBuilder builder;
    Integer index;
    public N and() {
      return (N) CustomResourceDefinitionSpecFluentImpl.this.setToVersions(index,builder.build());
    }
    public N endVersion() {
      return and();
    }
    
  }
  
}