package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class WebhookClientConfigFluentImpl<A extends WebhookClientConfigFluent<A>> extends BaseFluent<A> implements WebhookClientConfigFluent<A>{
  public WebhookClientConfigFluentImpl() {
  }
  public WebhookClientConfigFluentImpl(WebhookClientConfig instance) {
    this.withCaBundle(instance.getCaBundle()); 
    this.withService(instance.getService()); 
    this.withUrl(instance.getUrl()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String caBundle;
  private ServiceReferenceBuilder service;
  private String url;
  private Map<String,Object> additionalProperties;
  public String getCaBundle() {
    return this.caBundle;
  }
  public A withCaBundle(String caBundle) {
    this.caBundle=caBundle; return (A) this;
  }
  public Boolean hasCaBundle() {
    return this.caBundle != null;
  }
  
  /**
   * This method has been deprecated, please use method buildService instead.
   * @return The buildable object.
   */
  @Deprecated
  public ServiceReference getService() {
    return this.service!=null ?this.service.build():null;
  }
  public ServiceReference buildService() {
    return this.service!=null ?this.service.build():null;
  }
  public A withService(ServiceReference service) {
    _visitables.get("service").remove(this.service);
    if (service!=null){ this.service= new ServiceReferenceBuilder(service); _visitables.get("service").add(this.service);} else { this.service = null; _visitables.get("service").remove(this.service); } return (A) this;
  }
  public Boolean hasService() {
    return this.service != null;
  }
  public A withNewService(String name,String namespace,String path,Integer port) {
    return (A)withService(new ServiceReference(name, namespace, path, port));
  }
  public WebhookClientConfigFluent.ServiceNested<A> withNewService() {
    return new WebhookClientConfigFluentImpl.ServiceNestedImpl();
  }
  public WebhookClientConfigFluent.ServiceNested<A> withNewServiceLike(ServiceReference item) {
    return new WebhookClientConfigFluentImpl.ServiceNestedImpl(item);
  }
  public WebhookClientConfigFluent.ServiceNested<A> editService() {
    return withNewServiceLike(getService());
  }
  public WebhookClientConfigFluent.ServiceNested<A> editOrNewService() {
    return withNewServiceLike(getService() != null ? getService(): new ServiceReferenceBuilder().build());
  }
  public WebhookClientConfigFluent.ServiceNested<A> editOrNewServiceLike(ServiceReference item) {
    return withNewServiceLike(getService() != null ? getService(): item);
  }
  public String getUrl() {
    return this.url;
  }
  public A withUrl(String url) {
    this.url=url; return (A) this;
  }
  public Boolean hasUrl() {
    return this.url != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebhookClientConfigFluentImpl that = (WebhookClientConfigFluentImpl) o;
    if (caBundle != null ? !caBundle.equals(that.caBundle) :that.caBundle != null) return false;
    if (service != null ? !service.equals(that.service) :that.service != null) return false;
    if (url != null ? !url.equals(that.url) :that.url != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(caBundle,  service,  url,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (caBundle != null) { sb.append("caBundle:"); sb.append(caBundle + ","); }
    if (service != null) { sb.append("service:"); sb.append(service + ","); }
    if (url != null) { sb.append("url:"); sb.append(url + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ServiceNestedImpl<N> extends ServiceReferenceFluentImpl<WebhookClientConfigFluent.ServiceNested<N>> implements WebhookClientConfigFluent.ServiceNested<N>,Nested<N>{
    ServiceNestedImpl(ServiceReference item) {
      this.builder = new ServiceReferenceBuilder(this, item);
    }
    ServiceNestedImpl() {
      this.builder = new ServiceReferenceBuilder(this);
    }
    ServiceReferenceBuilder builder;
    public N and() {
      return (N) WebhookClientConfigFluentImpl.this.withService(builder.build());
    }
    public N endService() {
      return and();
    }
    
  }
  
}