package io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Integer;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.Boolean;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class WebhookConversionFluentImpl<A extends WebhookConversionFluent<A>> extends BaseFluent<A> implements WebhookConversionFluent<A>{
  public WebhookConversionFluentImpl() {
  }
  public WebhookConversionFluentImpl(WebhookConversion instance) {
    this.withClientConfig(instance.getClientConfig()); 
    this.withConversionReviewVersions(instance.getConversionReviewVersions()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private WebhookClientConfigBuilder clientConfig;
  private List<String> conversionReviewVersions = new ArrayList<String>();
  private Map<String,Object> additionalProperties;
  
  /**
   * This method has been deprecated, please use method buildClientConfig instead.
   * @return The buildable object.
   */
  @Deprecated
  public WebhookClientConfig getClientConfig() {
    return this.clientConfig!=null ?this.clientConfig.build():null;
  }
  public WebhookClientConfig buildClientConfig() {
    return this.clientConfig!=null ?this.clientConfig.build():null;
  }
  public A withClientConfig(WebhookClientConfig clientConfig) {
    _visitables.get("clientConfig").remove(this.clientConfig);
    if (clientConfig!=null){ this.clientConfig= new WebhookClientConfigBuilder(clientConfig); _visitables.get("clientConfig").add(this.clientConfig);} else { this.clientConfig = null; _visitables.get("clientConfig").remove(this.clientConfig); } return (A) this;
  }
  public Boolean hasClientConfig() {
    return this.clientConfig != null;
  }
  public WebhookConversionFluent.ClientConfigNested<A> withNewClientConfig() {
    return new WebhookConversionFluentImpl.ClientConfigNestedImpl();
  }
  public WebhookConversionFluent.ClientConfigNested<A> withNewClientConfigLike(WebhookClientConfig item) {
    return new WebhookConversionFluentImpl.ClientConfigNestedImpl(item);
  }
  public WebhookConversionFluent.ClientConfigNested<A> editClientConfig() {
    return withNewClientConfigLike(getClientConfig());
  }
  public WebhookConversionFluent.ClientConfigNested<A> editOrNewClientConfig() {
    return withNewClientConfigLike(getClientConfig() != null ? getClientConfig(): new WebhookClientConfigBuilder().build());
  }
  public WebhookConversionFluent.ClientConfigNested<A> editOrNewClientConfigLike(WebhookClientConfig item) {
    return withNewClientConfigLike(getClientConfig() != null ? getClientConfig(): item);
  }
  public A addToConversionReviewVersions(Integer index,String item) {
    if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
    this.conversionReviewVersions.add(index, item);
    return (A)this;
  }
  public A setToConversionReviewVersions(Integer index,String item) {
    if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
    this.conversionReviewVersions.set(index, item); return (A)this;
  }
  public A addToConversionReviewVersions(java.lang.String... items) {
    if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
    for (String item : items) {this.conversionReviewVersions.add(item);} return (A)this;
  }
  public A addAllToConversionReviewVersions(Collection<String> items) {
    if (this.conversionReviewVersions == null) {this.conversionReviewVersions = new ArrayList<String>();}
    for (String item : items) {this.conversionReviewVersions.add(item);} return (A)this;
  }
  public A removeFromConversionReviewVersions(java.lang.String... items) {
    for (String item : items) {if (this.conversionReviewVersions!= null){ this.conversionReviewVersions.remove(item);}} return (A)this;
  }
  public A removeAllFromConversionReviewVersions(Collection<String> items) {
    for (String item : items) {if (this.conversionReviewVersions!= null){ this.conversionReviewVersions.remove(item);}} return (A)this;
  }
  public List<String> getConversionReviewVersions() {
    return this.conversionReviewVersions;
  }
  public String getConversionReviewVersion(Integer index) {
    return this.conversionReviewVersions.get(index);
  }
  public String getFirstConversionReviewVersion() {
    return this.conversionReviewVersions.get(0);
  }
  public String getLastConversionReviewVersion() {
    return this.conversionReviewVersions.get(conversionReviewVersions.size() - 1);
  }
  public String getMatchingConversionReviewVersion(Predicate<String> predicate) {
    for (String item: conversionReviewVersions) { if(predicate.test(item)){ return item;} } return null;
  }
  public Boolean hasMatchingConversionReviewVersion(Predicate<String> predicate) {
    for (String item: conversionReviewVersions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withConversionReviewVersions(List<String> conversionReviewVersions) {
    if (conversionReviewVersions != null) {this.conversionReviewVersions = new ArrayList(); for (String item : conversionReviewVersions){this.addToConversionReviewVersions(item);}} else { this.conversionReviewVersions = null;} return (A) this;
  }
  public A withConversionReviewVersions(java.lang.String... conversionReviewVersions) {
    if (this.conversionReviewVersions != null) {this.conversionReviewVersions.clear();}
    if (conversionReviewVersions != null) {for (String item :conversionReviewVersions){ this.addToConversionReviewVersions(item);}} return (A) this;
  }
  public Boolean hasConversionReviewVersions() {
    return conversionReviewVersions != null && !conversionReviewVersions.isEmpty();
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    WebhookConversionFluentImpl that = (WebhookConversionFluentImpl) o;
    if (clientConfig != null ? !clientConfig.equals(that.clientConfig) :that.clientConfig != null) return false;
    if (conversionReviewVersions != null ? !conversionReviewVersions.equals(that.conversionReviewVersions) :that.conversionReviewVersions != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(clientConfig,  conversionReviewVersions,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (clientConfig != null) { sb.append("clientConfig:"); sb.append(clientConfig + ","); }
    if (conversionReviewVersions != null && !conversionReviewVersions.isEmpty()) { sb.append("conversionReviewVersions:"); sb.append(conversionReviewVersions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ClientConfigNestedImpl<N> extends WebhookClientConfigFluentImpl<WebhookConversionFluent.ClientConfigNested<N>> implements WebhookConversionFluent.ClientConfigNested<N>,Nested<N>{
    ClientConfigNestedImpl(WebhookClientConfig item) {
      this.builder = new WebhookClientConfigBuilder(this, item);
    }
    ClientConfigNestedImpl() {
      this.builder = new WebhookClientConfigBuilder(this);
    }
    WebhookClientConfigBuilder builder;
    public N and() {
      return (N) WebhookConversionFluentImpl.this.withClientConfig(builder.build());
    }
    public N endClientConfig() {
      return and();
    }
    
  }
  
}