package io.fabric8.kubernetes.api.model.apiextensions.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.lang.String;
import java.lang.Boolean;
import java.util.Map;
import java.util.LinkedHashMap;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class CustomResourceSubresourceScaleFluentImpl<A extends CustomResourceSubresourceScaleFluent<A>> extends BaseFluent<A> implements CustomResourceSubresourceScaleFluent<A>{
  public CustomResourceSubresourceScaleFluentImpl() {
  }
  public CustomResourceSubresourceScaleFluentImpl(CustomResourceSubresourceScale instance) {
    this.withLabelSelectorPath(instance.getLabelSelectorPath()); 
    this.withSpecReplicasPath(instance.getSpecReplicasPath()); 
    this.withStatusReplicasPath(instance.getStatusReplicasPath()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private String labelSelectorPath;
  private String specReplicasPath;
  private String statusReplicasPath;
  private Map<String,Object> additionalProperties;
  public String getLabelSelectorPath() {
    return this.labelSelectorPath;
  }
  public A withLabelSelectorPath(String labelSelectorPath) {
    this.labelSelectorPath=labelSelectorPath; return (A) this;
  }
  public Boolean hasLabelSelectorPath() {
    return this.labelSelectorPath != null;
  }
  public String getSpecReplicasPath() {
    return this.specReplicasPath;
  }
  public A withSpecReplicasPath(String specReplicasPath) {
    this.specReplicasPath=specReplicasPath; return (A) this;
  }
  public Boolean hasSpecReplicasPath() {
    return this.specReplicasPath != null;
  }
  public String getStatusReplicasPath() {
    return this.statusReplicasPath;
  }
  public A withStatusReplicasPath(String statusReplicasPath) {
    this.statusReplicasPath=statusReplicasPath; return (A) this;
  }
  public Boolean hasStatusReplicasPath() {
    return this.statusReplicasPath != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    CustomResourceSubresourceScaleFluentImpl that = (CustomResourceSubresourceScaleFluentImpl) o;
    if (labelSelectorPath != null ? !labelSelectorPath.equals(that.labelSelectorPath) :that.labelSelectorPath != null) return false;
    if (specReplicasPath != null ? !specReplicasPath.equals(that.specReplicasPath) :that.specReplicasPath != null) return false;
    if (statusReplicasPath != null ? !statusReplicasPath.equals(that.statusReplicasPath) :that.statusReplicasPath != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(labelSelectorPath,  specReplicasPath,  statusReplicasPath,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (labelSelectorPath != null) { sb.append("labelSelectorPath:"); sb.append(labelSelectorPath + ","); }
    if (specReplicasPath != null) { sb.append("specReplicasPath:"); sb.append(specReplicasPath + ","); }
    if (statusReplicasPath != null) { sb.append("statusReplicasPath:"); sb.append(statusReplicasPath + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}