package io.fabric8.kubernetes.api.model.apiextensions.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ConversionResponseBuilder extends ConversionResponseFluentImpl<ConversionResponseBuilder> implements VisitableBuilder<ConversionResponse,ConversionResponseBuilder>{
  public ConversionResponseBuilder() {
    this(false);
  }
  public ConversionResponseBuilder(Boolean validationEnabled) {
    this(new ConversionResponse(), validationEnabled);
  }
  public ConversionResponseBuilder(ConversionResponseFluent<?> fluent) {
    this(fluent, false);
  }
  public ConversionResponseBuilder(ConversionResponseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ConversionResponse(), validationEnabled);
  }
  public ConversionResponseBuilder(ConversionResponseFluent<?> fluent,ConversionResponse instance) {
    this(fluent, instance, false);
  }
  public ConversionResponseBuilder(ConversionResponseFluent<?> fluent,ConversionResponse instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withConvertedObjects(instance.getConvertedObjects()); 
    fluent.withResult(instance.getResult()); 
    fluent.withUid(instance.getUid()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ConversionResponseBuilder(ConversionResponse instance) {
    this(instance,false);
  }
  public ConversionResponseBuilder(ConversionResponse instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withConvertedObjects(instance.getConvertedObjects()); 
    this.withResult(instance.getResult()); 
    this.withUid(instance.getUid()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ConversionResponseFluent<?> fluent;
  Boolean validationEnabled;
  public ConversionResponse build() {
    ConversionResponse buildable = new ConversionResponse(fluent.getConvertedObjects(),fluent.getResult(),fluent.getUid());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}