package io.fabric8.kubernetes.api.model.apiextensions.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.Iterator;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class CustomResourceDefinitionSpecFluent<A extends CustomResourceDefinitionSpecFluent<A>> extends BaseFluent<A>{
  public CustomResourceDefinitionSpecFluent() {
  }
  
  public CustomResourceDefinitionSpecFluent(CustomResourceDefinitionSpec instance) {
    this.copyInstance(instance);
  }
  private ArrayList<CustomResourceColumnDefinitionBuilder> additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();
  private CustomResourceConversionBuilder conversion;
  private String group;
  private CustomResourceDefinitionNamesBuilder names;
  private Boolean preserveUnknownFields;
  private String scope;
  private ArrayList<SelectableFieldBuilder> selectableFields = new ArrayList<SelectableFieldBuilder>();
  private CustomResourceSubresourcesBuilder subresources;
  private CustomResourceValidationBuilder validation;
  private String version;
  private ArrayList<CustomResourceDefinitionVersionBuilder> versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(CustomResourceDefinitionSpec instance) {
    instance = (instance != null ? instance : new CustomResourceDefinitionSpec());
    if (instance != null) {
          this.withAdditionalPrinterColumns(instance.getAdditionalPrinterColumns());
          this.withConversion(instance.getConversion());
          this.withGroup(instance.getGroup());
          this.withNames(instance.getNames());
          this.withPreserveUnknownFields(instance.getPreserveUnknownFields());
          this.withScope(instance.getScope());
          this.withSelectableFields(instance.getSelectableFields());
          this.withSubresources(instance.getSubresources());
          this.withValidation(instance.getValidation());
          this.withVersion(instance.getVersion());
          this.withVersions(instance.getVersions());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToAdditionalPrinterColumns(int index,CustomResourceColumnDefinition item) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
    if (index < 0 || index >= additionalPrinterColumns.size()) { _visitables.get("additionalPrinterColumns").add(builder); additionalPrinterColumns.add(builder); } else { _visitables.get("additionalPrinterColumns").add(index, builder); additionalPrinterColumns.add(index, builder);}
    return (A)this;
  }
  
  public A setToAdditionalPrinterColumns(int index,CustomResourceColumnDefinition item) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);
    if (index < 0 || index >= additionalPrinterColumns.size()) { _visitables.get("additionalPrinterColumns").add(builder); additionalPrinterColumns.add(builder); } else { _visitables.get("additionalPrinterColumns").set(index, builder); additionalPrinterColumns.set(index, builder);}
    return (A)this;
  }
  
  public A addToAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... items) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
  }
  
  public A addAllToAdditionalPrinterColumns(Collection<CustomResourceColumnDefinition> items) {
    if (this.additionalPrinterColumns == null) {this.additionalPrinterColumns = new ArrayList<CustomResourceColumnDefinitionBuilder>();}
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").add(builder);this.additionalPrinterColumns.add(builder);} return (A)this;
  }
  
  public A removeFromAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... items) {
    if (this.additionalPrinterColumns == null) return (A)this;
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder); this.additionalPrinterColumns.remove(builder);} return (A)this;
  }
  
  public A removeAllFromAdditionalPrinterColumns(Collection<CustomResourceColumnDefinition> items) {
    if (this.additionalPrinterColumns == null) return (A)this;
    for (CustomResourceColumnDefinition item : items) {CustomResourceColumnDefinitionBuilder builder = new CustomResourceColumnDefinitionBuilder(item);_visitables.get("additionalPrinterColumns").remove(builder); this.additionalPrinterColumns.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromAdditionalPrinterColumns(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
    if (additionalPrinterColumns == null) return (A) this;
    final Iterator<CustomResourceColumnDefinitionBuilder> each = additionalPrinterColumns.iterator();
    final List visitables = _visitables.get("additionalPrinterColumns");
    while (each.hasNext()) {
      CustomResourceColumnDefinitionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CustomResourceColumnDefinition> buildAdditionalPrinterColumns() {
    return this.additionalPrinterColumns != null ? build(additionalPrinterColumns) : null;
  }
  
  public CustomResourceColumnDefinition buildAdditionalPrinterColumn(int index) {
    return this.additionalPrinterColumns.get(index).build();
  }
  
  public CustomResourceColumnDefinition buildFirstAdditionalPrinterColumn() {
    return this.additionalPrinterColumns.get(0).build();
  }
  
  public CustomResourceColumnDefinition buildLastAdditionalPrinterColumn() {
    return this.additionalPrinterColumns.get(additionalPrinterColumns.size() - 1).build();
  }
  
  public CustomResourceColumnDefinition buildMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
      for (CustomResourceColumnDefinitionBuilder item : additionalPrinterColumns) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
      for (CustomResourceColumnDefinitionBuilder item : additionalPrinterColumns) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withAdditionalPrinterColumns(List<CustomResourceColumnDefinition> additionalPrinterColumns) {
    if (this.additionalPrinterColumns != null) {
      this._visitables.get("additionalPrinterColumns").clear();
    }
    if (additionalPrinterColumns != null) {
        this.additionalPrinterColumns = new ArrayList();
        for (CustomResourceColumnDefinition item : additionalPrinterColumns) {
          this.addToAdditionalPrinterColumns(item);
        }
    } else {
      this.additionalPrinterColumns = null;
    }
    return (A) this;
  }
  
  public A withAdditionalPrinterColumns(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceColumnDefinition... additionalPrinterColumns) {
    if (this.additionalPrinterColumns != null) {
        this.additionalPrinterColumns.clear();
        _visitables.remove("additionalPrinterColumns");
    }
    if (additionalPrinterColumns != null) {
      for (CustomResourceColumnDefinition item : additionalPrinterColumns) {
        this.addToAdditionalPrinterColumns(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasAdditionalPrinterColumns() {
    return this.additionalPrinterColumns != null && !this.additionalPrinterColumns.isEmpty();
  }
  
  public AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumn() {
    return new AdditionalPrinterColumnsNested(-1, null);
  }
  
  public AdditionalPrinterColumnsNested<A> addNewAdditionalPrinterColumnLike(CustomResourceColumnDefinition item) {
    return new AdditionalPrinterColumnsNested(-1, item);
  }
  
  public AdditionalPrinterColumnsNested<A> setNewAdditionalPrinterColumnLike(int index,CustomResourceColumnDefinition item) {
    return new AdditionalPrinterColumnsNested(index, item);
  }
  
  public AdditionalPrinterColumnsNested<A> editAdditionalPrinterColumn(int index) {
    if (additionalPrinterColumns.size() <= index) throw new RuntimeException("Can't edit additionalPrinterColumns. Index exceeds size.");
    return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
  }
  
  public AdditionalPrinterColumnsNested<A> editFirstAdditionalPrinterColumn() {
    if (additionalPrinterColumns.size() == 0) throw new RuntimeException("Can't edit first additionalPrinterColumns. The list is empty.");
    return setNewAdditionalPrinterColumnLike(0, buildAdditionalPrinterColumn(0));
  }
  
  public AdditionalPrinterColumnsNested<A> editLastAdditionalPrinterColumn() {
    int index = additionalPrinterColumns.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last additionalPrinterColumns. The list is empty.");
    return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
  }
  
  public AdditionalPrinterColumnsNested<A> editMatchingAdditionalPrinterColumn(Predicate<CustomResourceColumnDefinitionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<additionalPrinterColumns.size();i++) { 
    if (predicate.test(additionalPrinterColumns.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching additionalPrinterColumns. No match found.");
    return setNewAdditionalPrinterColumnLike(index, buildAdditionalPrinterColumn(index));
  }
  
  public CustomResourceConversion buildConversion() {
    return this.conversion != null ? this.conversion.build() : null;
  }
  
  public A withConversion(CustomResourceConversion conversion) {
    this._visitables.remove("conversion");
    if (conversion != null) {
        this.conversion = new CustomResourceConversionBuilder(conversion);
        this._visitables.get("conversion").add(this.conversion);
    } else {
        this.conversion = null;
        this._visitables.get("conversion").remove(this.conversion);
    }
    return (A) this;
  }
  
  public boolean hasConversion() {
    return this.conversion != null;
  }
  
  public ConversionNested<A> withNewConversion() {
    return new ConversionNested(null);
  }
  
  public ConversionNested<A> withNewConversionLike(CustomResourceConversion item) {
    return new ConversionNested(item);
  }
  
  public ConversionNested<A> editConversion() {
    return withNewConversionLike(java.util.Optional.ofNullable(buildConversion()).orElse(null));
  }
  
  public ConversionNested<A> editOrNewConversion() {
    return withNewConversionLike(java.util.Optional.ofNullable(buildConversion()).orElse(new CustomResourceConversionBuilder().build()));
  }
  
  public ConversionNested<A> editOrNewConversionLike(CustomResourceConversion item) {
    return withNewConversionLike(java.util.Optional.ofNullable(buildConversion()).orElse(item));
  }
  
  public String getGroup() {
    return this.group;
  }
  
  public A withGroup(String group) {
    this.group = group;
    return (A) this;
  }
  
  public boolean hasGroup() {
    return this.group != null;
  }
  
  public CustomResourceDefinitionNames buildNames() {
    return this.names != null ? this.names.build() : null;
  }
  
  public A withNames(CustomResourceDefinitionNames names) {
    this._visitables.remove("names");
    if (names != null) {
        this.names = new CustomResourceDefinitionNamesBuilder(names);
        this._visitables.get("names").add(this.names);
    } else {
        this.names = null;
        this._visitables.get("names").remove(this.names);
    }
    return (A) this;
  }
  
  public boolean hasNames() {
    return this.names != null;
  }
  
  public NamesNested<A> withNewNames() {
    return new NamesNested(null);
  }
  
  public NamesNested<A> withNewNamesLike(CustomResourceDefinitionNames item) {
    return new NamesNested(item);
  }
  
  public NamesNested<A> editNames() {
    return withNewNamesLike(java.util.Optional.ofNullable(buildNames()).orElse(null));
  }
  
  public NamesNested<A> editOrNewNames() {
    return withNewNamesLike(java.util.Optional.ofNullable(buildNames()).orElse(new CustomResourceDefinitionNamesBuilder().build()));
  }
  
  public NamesNested<A> editOrNewNamesLike(CustomResourceDefinitionNames item) {
    return withNewNamesLike(java.util.Optional.ofNullable(buildNames()).orElse(item));
  }
  
  public Boolean getPreserveUnknownFields() {
    return this.preserveUnknownFields;
  }
  
  public A withPreserveUnknownFields(Boolean preserveUnknownFields) {
    this.preserveUnknownFields = preserveUnknownFields;
    return (A) this;
  }
  
  public boolean hasPreserveUnknownFields() {
    return this.preserveUnknownFields != null;
  }
  
  public String getScope() {
    return this.scope;
  }
  
  public A withScope(String scope) {
    this.scope = scope;
    return (A) this;
  }
  
  public boolean hasScope() {
    return this.scope != null;
  }
  
  public A addToSelectableFields(int index,SelectableField item) {
    if (this.selectableFields == null) {this.selectableFields = new ArrayList<SelectableFieldBuilder>();}
    SelectableFieldBuilder builder = new SelectableFieldBuilder(item);
    if (index < 0 || index >= selectableFields.size()) { _visitables.get("selectableFields").add(builder); selectableFields.add(builder); } else { _visitables.get("selectableFields").add(index, builder); selectableFields.add(index, builder);}
    return (A)this;
  }
  
  public A setToSelectableFields(int index,SelectableField item) {
    if (this.selectableFields == null) {this.selectableFields = new ArrayList<SelectableFieldBuilder>();}
    SelectableFieldBuilder builder = new SelectableFieldBuilder(item);
    if (index < 0 || index >= selectableFields.size()) { _visitables.get("selectableFields").add(builder); selectableFields.add(builder); } else { _visitables.get("selectableFields").set(index, builder); selectableFields.set(index, builder);}
    return (A)this;
  }
  
  public A addToSelectableFields(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.SelectableField... items) {
    if (this.selectableFields == null) {this.selectableFields = new ArrayList<SelectableFieldBuilder>();}
    for (SelectableField item : items) {SelectableFieldBuilder builder = new SelectableFieldBuilder(item);_visitables.get("selectableFields").add(builder);this.selectableFields.add(builder);} return (A)this;
  }
  
  public A addAllToSelectableFields(Collection<SelectableField> items) {
    if (this.selectableFields == null) {this.selectableFields = new ArrayList<SelectableFieldBuilder>();}
    for (SelectableField item : items) {SelectableFieldBuilder builder = new SelectableFieldBuilder(item);_visitables.get("selectableFields").add(builder);this.selectableFields.add(builder);} return (A)this;
  }
  
  public A removeFromSelectableFields(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.SelectableField... items) {
    if (this.selectableFields == null) return (A)this;
    for (SelectableField item : items) {SelectableFieldBuilder builder = new SelectableFieldBuilder(item);_visitables.get("selectableFields").remove(builder); this.selectableFields.remove(builder);} return (A)this;
  }
  
  public A removeAllFromSelectableFields(Collection<SelectableField> items) {
    if (this.selectableFields == null) return (A)this;
    for (SelectableField item : items) {SelectableFieldBuilder builder = new SelectableFieldBuilder(item);_visitables.get("selectableFields").remove(builder); this.selectableFields.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromSelectableFields(Predicate<SelectableFieldBuilder> predicate) {
    if (selectableFields == null) return (A) this;
    final Iterator<SelectableFieldBuilder> each = selectableFields.iterator();
    final List visitables = _visitables.get("selectableFields");
    while (each.hasNext()) {
      SelectableFieldBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<SelectableField> buildSelectableFields() {
    return this.selectableFields != null ? build(selectableFields) : null;
  }
  
  public SelectableField buildSelectableField(int index) {
    return this.selectableFields.get(index).build();
  }
  
  public SelectableField buildFirstSelectableField() {
    return this.selectableFields.get(0).build();
  }
  
  public SelectableField buildLastSelectableField() {
    return this.selectableFields.get(selectableFields.size() - 1).build();
  }
  
  public SelectableField buildMatchingSelectableField(Predicate<SelectableFieldBuilder> predicate) {
      for (SelectableFieldBuilder item : selectableFields) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingSelectableField(Predicate<SelectableFieldBuilder> predicate) {
      for (SelectableFieldBuilder item : selectableFields) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withSelectableFields(List<SelectableField> selectableFields) {
    if (this.selectableFields != null) {
      this._visitables.get("selectableFields").clear();
    }
    if (selectableFields != null) {
        this.selectableFields = new ArrayList();
        for (SelectableField item : selectableFields) {
          this.addToSelectableFields(item);
        }
    } else {
      this.selectableFields = null;
    }
    return (A) this;
  }
  
  public A withSelectableFields(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.SelectableField... selectableFields) {
    if (this.selectableFields != null) {
        this.selectableFields.clear();
        _visitables.remove("selectableFields");
    }
    if (selectableFields != null) {
      for (SelectableField item : selectableFields) {
        this.addToSelectableFields(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasSelectableFields() {
    return this.selectableFields != null && !this.selectableFields.isEmpty();
  }
  
  public A addNewSelectableField(String jsonPath) {
    return (A)addToSelectableFields(new SelectableField(jsonPath));
  }
  
  public SelectableFieldsNested<A> addNewSelectableField() {
    return new SelectableFieldsNested(-1, null);
  }
  
  public SelectableFieldsNested<A> addNewSelectableFieldLike(SelectableField item) {
    return new SelectableFieldsNested(-1, item);
  }
  
  public SelectableFieldsNested<A> setNewSelectableFieldLike(int index,SelectableField item) {
    return new SelectableFieldsNested(index, item);
  }
  
  public SelectableFieldsNested<A> editSelectableField(int index) {
    if (selectableFields.size() <= index) throw new RuntimeException("Can't edit selectableFields. Index exceeds size.");
    return setNewSelectableFieldLike(index, buildSelectableField(index));
  }
  
  public SelectableFieldsNested<A> editFirstSelectableField() {
    if (selectableFields.size() == 0) throw new RuntimeException("Can't edit first selectableFields. The list is empty.");
    return setNewSelectableFieldLike(0, buildSelectableField(0));
  }
  
  public SelectableFieldsNested<A> editLastSelectableField() {
    int index = selectableFields.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last selectableFields. The list is empty.");
    return setNewSelectableFieldLike(index, buildSelectableField(index));
  }
  
  public SelectableFieldsNested<A> editMatchingSelectableField(Predicate<SelectableFieldBuilder> predicate) {
    int index = -1;
    for (int i=0;i<selectableFields.size();i++) { 
    if (predicate.test(selectableFields.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching selectableFields. No match found.");
    return setNewSelectableFieldLike(index, buildSelectableField(index));
  }
  
  public CustomResourceSubresources buildSubresources() {
    return this.subresources != null ? this.subresources.build() : null;
  }
  
  public A withSubresources(CustomResourceSubresources subresources) {
    this._visitables.remove("subresources");
    if (subresources != null) {
        this.subresources = new CustomResourceSubresourcesBuilder(subresources);
        this._visitables.get("subresources").add(this.subresources);
    } else {
        this.subresources = null;
        this._visitables.get("subresources").remove(this.subresources);
    }
    return (A) this;
  }
  
  public boolean hasSubresources() {
    return this.subresources != null;
  }
  
  public SubresourcesNested<A> withNewSubresources() {
    return new SubresourcesNested(null);
  }
  
  public SubresourcesNested<A> withNewSubresourcesLike(CustomResourceSubresources item) {
    return new SubresourcesNested(item);
  }
  
  public SubresourcesNested<A> editSubresources() {
    return withNewSubresourcesLike(java.util.Optional.ofNullable(buildSubresources()).orElse(null));
  }
  
  public SubresourcesNested<A> editOrNewSubresources() {
    return withNewSubresourcesLike(java.util.Optional.ofNullable(buildSubresources()).orElse(new CustomResourceSubresourcesBuilder().build()));
  }
  
  public SubresourcesNested<A> editOrNewSubresourcesLike(CustomResourceSubresources item) {
    return withNewSubresourcesLike(java.util.Optional.ofNullable(buildSubresources()).orElse(item));
  }
  
  public CustomResourceValidation buildValidation() {
    return this.validation != null ? this.validation.build() : null;
  }
  
  public A withValidation(CustomResourceValidation validation) {
    this._visitables.remove("validation");
    if (validation != null) {
        this.validation = new CustomResourceValidationBuilder(validation);
        this._visitables.get("validation").add(this.validation);
    } else {
        this.validation = null;
        this._visitables.get("validation").remove(this.validation);
    }
    return (A) this;
  }
  
  public boolean hasValidation() {
    return this.validation != null;
  }
  
  public ValidationNested<A> withNewValidation() {
    return new ValidationNested(null);
  }
  
  public ValidationNested<A> withNewValidationLike(CustomResourceValidation item) {
    return new ValidationNested(item);
  }
  
  public ValidationNested<A> editValidation() {
    return withNewValidationLike(java.util.Optional.ofNullable(buildValidation()).orElse(null));
  }
  
  public ValidationNested<A> editOrNewValidation() {
    return withNewValidationLike(java.util.Optional.ofNullable(buildValidation()).orElse(new CustomResourceValidationBuilder().build()));
  }
  
  public ValidationNested<A> editOrNewValidationLike(CustomResourceValidation item) {
    return withNewValidationLike(java.util.Optional.ofNullable(buildValidation()).orElse(item));
  }
  
  public String getVersion() {
    return this.version;
  }
  
  public A withVersion(String version) {
    this.version = version;
    return (A) this;
  }
  
  public boolean hasVersion() {
    return this.version != null;
  }
  
  public A addToVersions(int index,CustomResourceDefinitionVersion item) {
    if (this.versions == null) {this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();}
    CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
    if (index < 0 || index >= versions.size()) { _visitables.get("versions").add(builder); versions.add(builder); } else { _visitables.get("versions").add(index, builder); versions.add(index, builder);}
    return (A)this;
  }
  
  public A setToVersions(int index,CustomResourceDefinitionVersion item) {
    if (this.versions == null) {this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();}
    CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);
    if (index < 0 || index >= versions.size()) { _visitables.get("versions").add(builder); versions.add(builder); } else { _visitables.get("versions").set(index, builder); versions.set(index, builder);}
    return (A)this;
  }
  
  public A addToVersions(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion... items) {
    if (this.versions == null) {this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();}
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  
  public A addAllToVersions(Collection<CustomResourceDefinitionVersion> items) {
    if (this.versions == null) {this.versions = new ArrayList<CustomResourceDefinitionVersionBuilder>();}
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").add(builder);this.versions.add(builder);} return (A)this;
  }
  
  public A removeFromVersions(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion... items) {
    if (this.versions == null) return (A)this;
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").remove(builder); this.versions.remove(builder);} return (A)this;
  }
  
  public A removeAllFromVersions(Collection<CustomResourceDefinitionVersion> items) {
    if (this.versions == null) return (A)this;
    for (CustomResourceDefinitionVersion item : items) {CustomResourceDefinitionVersionBuilder builder = new CustomResourceDefinitionVersionBuilder(item);_visitables.get("versions").remove(builder); this.versions.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromVersions(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
    if (versions == null) return (A) this;
    final Iterator<CustomResourceDefinitionVersionBuilder> each = versions.iterator();
    final List visitables = _visitables.get("versions");
    while (each.hasNext()) {
      CustomResourceDefinitionVersionBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<CustomResourceDefinitionVersion> buildVersions() {
    return this.versions != null ? build(versions) : null;
  }
  
  public CustomResourceDefinitionVersion buildVersion(int index) {
    return this.versions.get(index).build();
  }
  
  public CustomResourceDefinitionVersion buildFirstVersion() {
    return this.versions.get(0).build();
  }
  
  public CustomResourceDefinitionVersion buildLastVersion() {
    return this.versions.get(versions.size() - 1).build();
  }
  
  public CustomResourceDefinitionVersion buildMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
      for (CustomResourceDefinitionVersionBuilder item : versions) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
      for (CustomResourceDefinitionVersionBuilder item : versions) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withVersions(List<CustomResourceDefinitionVersion> versions) {
    if (this.versions != null) {
      this._visitables.get("versions").clear();
    }
    if (versions != null) {
        this.versions = new ArrayList();
        for (CustomResourceDefinitionVersion item : versions) {
          this.addToVersions(item);
        }
    } else {
      this.versions = null;
    }
    return (A) this;
  }
  
  public A withVersions(io.fabric8.kubernetes.api.model.apiextensions.v1beta1.CustomResourceDefinitionVersion... versions) {
    if (this.versions != null) {
        this.versions.clear();
        _visitables.remove("versions");
    }
    if (versions != null) {
      for (CustomResourceDefinitionVersion item : versions) {
        this.addToVersions(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasVersions() {
    return this.versions != null && !this.versions.isEmpty();
  }
  
  public VersionsNested<A> addNewVersion() {
    return new VersionsNested(-1, null);
  }
  
  public VersionsNested<A> addNewVersionLike(CustomResourceDefinitionVersion item) {
    return new VersionsNested(-1, item);
  }
  
  public VersionsNested<A> setNewVersionLike(int index,CustomResourceDefinitionVersion item) {
    return new VersionsNested(index, item);
  }
  
  public VersionsNested<A> editVersion(int index) {
    if (versions.size() <= index) throw new RuntimeException("Can't edit versions. Index exceeds size.");
    return setNewVersionLike(index, buildVersion(index));
  }
  
  public VersionsNested<A> editFirstVersion() {
    if (versions.size() == 0) throw new RuntimeException("Can't edit first versions. The list is empty.");
    return setNewVersionLike(0, buildVersion(0));
  }
  
  public VersionsNested<A> editLastVersion() {
    int index = versions.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last versions. The list is empty.");
    return setNewVersionLike(index, buildVersion(index));
  }
  
  public VersionsNested<A> editMatchingVersion(Predicate<CustomResourceDefinitionVersionBuilder> predicate) {
    int index = -1;
    for (int i=0;i<versions.size();i++) { 
    if (predicate.test(versions.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching versions. No match found.");
    return setNewVersionLike(index, buildVersion(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    CustomResourceDefinitionSpecFluent that = (CustomResourceDefinitionSpecFluent) o;
    if (!java.util.Objects.equals(additionalPrinterColumns, that.additionalPrinterColumns)) return false;
    if (!java.util.Objects.equals(conversion, that.conversion)) return false;
    if (!java.util.Objects.equals(group, that.group)) return false;
    if (!java.util.Objects.equals(names, that.names)) return false;
    if (!java.util.Objects.equals(preserveUnknownFields, that.preserveUnknownFields)) return false;
    if (!java.util.Objects.equals(scope, that.scope)) return false;
    if (!java.util.Objects.equals(selectableFields, that.selectableFields)) return false;
    if (!java.util.Objects.equals(subresources, that.subresources)) return false;
    if (!java.util.Objects.equals(validation, that.validation)) return false;
    if (!java.util.Objects.equals(version, that.version)) return false;
    if (!java.util.Objects.equals(versions, that.versions)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(additionalPrinterColumns,  conversion,  group,  names,  preserveUnknownFields,  scope,  selectableFields,  subresources,  validation,  version,  versions,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (additionalPrinterColumns != null && !additionalPrinterColumns.isEmpty()) { sb.append("additionalPrinterColumns:"); sb.append(additionalPrinterColumns + ","); }
    if (conversion != null) { sb.append("conversion:"); sb.append(conversion + ","); }
    if (group != null) { sb.append("group:"); sb.append(group + ","); }
    if (names != null) { sb.append("names:"); sb.append(names + ","); }
    if (preserveUnknownFields != null) { sb.append("preserveUnknownFields:"); sb.append(preserveUnknownFields + ","); }
    if (scope != null) { sb.append("scope:"); sb.append(scope + ","); }
    if (selectableFields != null && !selectableFields.isEmpty()) { sb.append("selectableFields:"); sb.append(selectableFields + ","); }
    if (subresources != null) { sb.append("subresources:"); sb.append(subresources + ","); }
    if (validation != null) { sb.append("validation:"); sb.append(validation + ","); }
    if (version != null) { sb.append("version:"); sb.append(version + ","); }
    if (versions != null && !versions.isEmpty()) { sb.append("versions:"); sb.append(versions + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
  public A withPreserveUnknownFields() {
    return withPreserveUnknownFields(true);
  }
  public class AdditionalPrinterColumnsNested<N> extends CustomResourceColumnDefinitionFluent<AdditionalPrinterColumnsNested<N>> implements Nested<N>{
    AdditionalPrinterColumnsNested(int index,CustomResourceColumnDefinition item) {
      this.index = index;
      this.builder = new CustomResourceColumnDefinitionBuilder(this, item);
    }
    CustomResourceColumnDefinitionBuilder builder;
    int index;
    
    public N and() {
      return (N) CustomResourceDefinitionSpecFluent.this.setToAdditionalPrinterColumns(index,builder.build());
    }
    
    public N endAdditionalPrinterColumn() {
      return and();
    }
    
  
  }
  public class ConversionNested<N> extends CustomResourceConversionFluent<ConversionNested<N>> implements Nested<N>{
    ConversionNested(CustomResourceConversion item) {
      this.builder = new CustomResourceConversionBuilder(this, item);
    }
    CustomResourceConversionBuilder builder;
    
    public N and() {
      return (N) CustomResourceDefinitionSpecFluent.this.withConversion(builder.build());
    }
    
    public N endConversion() {
      return and();
    }
    
  
  }
  public class NamesNested<N> extends CustomResourceDefinitionNamesFluent<NamesNested<N>> implements Nested<N>{
    NamesNested(CustomResourceDefinitionNames item) {
      this.builder = new CustomResourceDefinitionNamesBuilder(this, item);
    }
    CustomResourceDefinitionNamesBuilder builder;
    
    public N and() {
      return (N) CustomResourceDefinitionSpecFluent.this.withNames(builder.build());
    }
    
    public N endNames() {
      return and();
    }
    
  
  }
  public class SelectableFieldsNested<N> extends SelectableFieldFluent<SelectableFieldsNested<N>> implements Nested<N>{
    SelectableFieldsNested(int index,SelectableField item) {
      this.index = index;
      this.builder = new SelectableFieldBuilder(this, item);
    }
    SelectableFieldBuilder builder;
    int index;
    
    public N and() {
      return (N) CustomResourceDefinitionSpecFluent.this.setToSelectableFields(index,builder.build());
    }
    
    public N endSelectableField() {
      return and();
    }
    
  
  }
  public class SubresourcesNested<N> extends CustomResourceSubresourcesFluent<SubresourcesNested<N>> implements Nested<N>{
    SubresourcesNested(CustomResourceSubresources item) {
      this.builder = new CustomResourceSubresourcesBuilder(this, item);
    }
    CustomResourceSubresourcesBuilder builder;
    
    public N and() {
      return (N) CustomResourceDefinitionSpecFluent.this.withSubresources(builder.build());
    }
    
    public N endSubresources() {
      return and();
    }
    
  
  }
  public class ValidationNested<N> extends CustomResourceValidationFluent<ValidationNested<N>> implements Nested<N>{
    ValidationNested(CustomResourceValidation item) {
      this.builder = new CustomResourceValidationBuilder(this, item);
    }
    CustomResourceValidationBuilder builder;
    
    public N and() {
      return (N) CustomResourceDefinitionSpecFluent.this.withValidation(builder.build());
    }
    
    public N endValidation() {
      return and();
    }
    
  
  }
  public class VersionsNested<N> extends CustomResourceDefinitionVersionFluent<VersionsNested<N>> implements Nested<N>{
    VersionsNested(int index,CustomResourceDefinitionVersion item) {
      this.index = index;
      this.builder = new CustomResourceDefinitionVersionBuilder(this, item);
    }
    CustomResourceDefinitionVersionBuilder builder;
    int index;
    
    public N and() {
      return (N) CustomResourceDefinitionSpecFluent.this.setToVersions(index,builder.build());
    }
    
    public N endVersion() {
      return and();
    }
    
  
  }

}