/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchCondition;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchConditionBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchConditionFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchResources;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchResourcesBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MatchResourcesFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MutatingAdmissionPolicySpec;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Mutation;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MutationBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.MutationFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ParamKind;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ParamKindBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.ParamKindFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Variable;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.VariableBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.VariableFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class MutatingAdmissionPolicySpecFluent<A extends MutatingAdmissionPolicySpecFluent<A>>
extends BaseFluent<A> {
    private Map<String, Object> additionalProperties;
    private String failurePolicy;
    private ArrayList<MatchConditionBuilder> matchConditions = new ArrayList();
    private MatchResourcesBuilder matchConstraints;
    private ArrayList<MutationBuilder> mutations = new ArrayList();
    private ParamKindBuilder paramKind;
    private String reinvocationPolicy;
    private ArrayList<VariableBuilder> variables = new ArrayList();

    public MutatingAdmissionPolicySpecFluent() {
    }

    public MutatingAdmissionPolicySpecFluent(MutatingAdmissionPolicySpec instance) {
        this.copyInstance(instance);
    }

    public A addAllToMatchConditions(Collection<MatchCondition> items) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        for (MatchCondition item : items) {
            MatchConditionBuilder builder = new MatchConditionBuilder(item);
            this._visitables.get((Object)"matchConditions").add(builder);
            this.matchConditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToMutations(Collection<Mutation> items) {
        if (this.mutations == null) {
            this.mutations = new ArrayList();
        }
        for (Mutation item : items) {
            MutationBuilder builder = new MutationBuilder(item);
            this._visitables.get((Object)"mutations").add(builder);
            this.mutations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addAllToVariables(Collection<Variable> items) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        for (Variable item : items) {
            VariableBuilder builder = new VariableBuilder(item);
            this._visitables.get((Object)"variables").add(builder);
            this.variables.add(builder);
        }
        return (A)((Object)this);
    }

    public MatchConditionsNested<A> addNewMatchCondition() {
        return new MatchConditionsNested(-1, null);
    }

    public A addNewMatchCondition(String expression, String name) {
        return this.addToMatchConditions(new MatchCondition(expression, name));
    }

    public MatchConditionsNested<A> addNewMatchConditionLike(MatchCondition item) {
        return new MatchConditionsNested(-1, item);
    }

    public MutationsNested<A> addNewMutation() {
        return new MutationsNested(-1, null);
    }

    public MutationsNested<A> addNewMutationLike(Mutation item) {
        return new MutationsNested(-1, item);
    }

    public VariablesNested<A> addNewVariable() {
        return new VariablesNested(-1, null);
    }

    public A addNewVariable(String expression, String name) {
        return this.addToVariables(new Variable(expression, name));
    }

    public VariablesNested<A> addNewVariableLike(Variable item) {
        return new VariablesNested(-1, item);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToMatchConditions(MatchCondition ... items) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        for (MatchCondition item : items) {
            MatchConditionBuilder builder = new MatchConditionBuilder(item);
            this._visitables.get((Object)"matchConditions").add(builder);
            this.matchConditions.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToMatchConditions(int index, MatchCondition item) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        MatchConditionBuilder builder = new MatchConditionBuilder(item);
        if (index < 0 || index >= this.matchConditions.size()) {
            this._visitables.get((Object)"matchConditions").add(builder);
            this.matchConditions.add(builder);
        } else {
            this._visitables.get((Object)"matchConditions").add(builder);
            this.matchConditions.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToMutations(Mutation ... items) {
        if (this.mutations == null) {
            this.mutations = new ArrayList();
        }
        for (Mutation item : items) {
            MutationBuilder builder = new MutationBuilder(item);
            this._visitables.get((Object)"mutations").add(builder);
            this.mutations.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToMutations(int index, Mutation item) {
        if (this.mutations == null) {
            this.mutations = new ArrayList();
        }
        MutationBuilder builder = new MutationBuilder(item);
        if (index < 0 || index >= this.mutations.size()) {
            this._visitables.get((Object)"mutations").add(builder);
            this.mutations.add(builder);
        } else {
            this._visitables.get((Object)"mutations").add(builder);
            this.mutations.add(index, builder);
        }
        return (A)((Object)this);
    }

    public A addToVariables(Variable ... items) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        for (Variable item : items) {
            VariableBuilder builder = new VariableBuilder(item);
            this._visitables.get((Object)"variables").add(builder);
            this.variables.add(builder);
        }
        return (A)((Object)this);
    }

    public A addToVariables(int index, Variable item) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        VariableBuilder builder = new VariableBuilder(item);
        if (index < 0 || index >= this.variables.size()) {
            this._visitables.get((Object)"variables").add(builder);
            this.variables.add(builder);
        } else {
            this._visitables.get((Object)"variables").add(builder);
            this.variables.add(index, builder);
        }
        return (A)((Object)this);
    }

    public MatchCondition buildFirstMatchCondition() {
        return this.matchConditions.get(0).build();
    }

    public Mutation buildFirstMutation() {
        return this.mutations.get(0).build();
    }

    public Variable buildFirstVariable() {
        return this.variables.get(0).build();
    }

    public MatchCondition buildLastMatchCondition() {
        return this.matchConditions.get(this.matchConditions.size() - 1).build();
    }

    public Mutation buildLastMutation() {
        return this.mutations.get(this.mutations.size() - 1).build();
    }

    public Variable buildLastVariable() {
        return this.variables.get(this.variables.size() - 1).build();
    }

    public MatchCondition buildMatchCondition(int index) {
        return this.matchConditions.get(index).build();
    }

    public List<MatchCondition> buildMatchConditions() {
        return this.matchConditions != null ? MutatingAdmissionPolicySpecFluent.build(this.matchConditions) : null;
    }

    public MatchResources buildMatchConstraints() {
        return this.matchConstraints != null ? this.matchConstraints.build() : null;
    }

    public MatchCondition buildMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
        for (MatchConditionBuilder item : this.matchConditions) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Mutation buildMatchingMutation(Predicate<MutationBuilder> predicate) {
        for (MutationBuilder item : this.mutations) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Variable buildMatchingVariable(Predicate<VariableBuilder> predicate) {
        for (VariableBuilder item : this.variables) {
            if (!predicate.test(item)) continue;
            return item.build();
        }
        return null;
    }

    public Mutation buildMutation(int index) {
        return this.mutations.get(index).build();
    }

    public List<Mutation> buildMutations() {
        return this.mutations != null ? MutatingAdmissionPolicySpecFluent.build(this.mutations) : null;
    }

    public ParamKind buildParamKind() {
        return this.paramKind != null ? this.paramKind.build() : null;
    }

    public Variable buildVariable(int index) {
        return this.variables.get(index).build();
    }

    public List<Variable> buildVariables() {
        return this.variables != null ? MutatingAdmissionPolicySpecFluent.build(this.variables) : null;
    }

    protected void copyInstance(MutatingAdmissionPolicySpec instance) {
        MutatingAdmissionPolicySpec mutatingAdmissionPolicySpec = instance = instance != null ? instance : new MutatingAdmissionPolicySpec();
        if (instance != null) {
            this.withFailurePolicy(instance.getFailurePolicy());
            this.withMatchConditions(instance.getMatchConditions());
            this.withMatchConstraints(instance.getMatchConstraints());
            this.withMutations(instance.getMutations());
            this.withParamKind(instance.getParamKind());
            this.withReinvocationPolicy(instance.getReinvocationPolicy());
            this.withVariables(instance.getVariables());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public MatchConditionsNested<A> editFirstMatchCondition() {
        if (this.matchConditions.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "matchConditions"));
        }
        return this.setNewMatchConditionLike(0, this.buildMatchCondition(0));
    }

    public MutationsNested<A> editFirstMutation() {
        if (this.mutations.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "mutations"));
        }
        return this.setNewMutationLike(0, this.buildMutation(0));
    }

    public VariablesNested<A> editFirstVariable() {
        if (this.variables.size() == 0) {
            throw new RuntimeException(String.format("Can't edit first %s. The list is empty.", "variables"));
        }
        return this.setNewVariableLike(0, this.buildVariable(0));
    }

    public MatchConditionsNested<A> editLastMatchCondition() {
        int index = this.matchConditions.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "matchConditions"));
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public MutationsNested<A> editLastMutation() {
        int index = this.mutations.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "mutations"));
        }
        return this.setNewMutationLike(index, this.buildMutation(index));
    }

    public VariablesNested<A> editLastVariable() {
        int index = this.variables.size() - 1;
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit last %s. The list is empty.", "variables"));
        }
        return this.setNewVariableLike(index, this.buildVariable(index));
    }

    public MatchConditionsNested<A> editMatchCondition(int index) {
        if (this.matchConditions.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "matchConditions"));
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public MatchConstraintsNested<A> editMatchConstraints() {
        return this.withNewMatchConstraintsLike(Optional.ofNullable(this.buildMatchConstraints()).orElse(null));
    }

    public MatchConditionsNested<A> editMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.matchConditions.size(); ++i) {
            if (!predicate.test(this.matchConditions.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "matchConditions"));
        }
        return this.setNewMatchConditionLike(index, this.buildMatchCondition(index));
    }

    public MutationsNested<A> editMatchingMutation(Predicate<MutationBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.mutations.size(); ++i) {
            if (!predicate.test(this.mutations.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "mutations"));
        }
        return this.setNewMutationLike(index, this.buildMutation(index));
    }

    public VariablesNested<A> editMatchingVariable(Predicate<VariableBuilder> predicate) {
        int index = -1;
        for (int i = 0; i < this.variables.size(); ++i) {
            if (!predicate.test(this.variables.get(i))) continue;
            index = i;
            break;
        }
        if (index < 0) {
            throw new RuntimeException(String.format("Can't edit matching %s. No match found.", "variables"));
        }
        return this.setNewVariableLike(index, this.buildVariable(index));
    }

    public MutationsNested<A> editMutation(int index) {
        if (this.mutations.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "mutations"));
        }
        return this.setNewMutationLike(index, this.buildMutation(index));
    }

    public MatchConstraintsNested<A> editOrNewMatchConstraints() {
        return this.withNewMatchConstraintsLike(Optional.ofNullable(this.buildMatchConstraints()).orElse(new MatchResourcesBuilder().build()));
    }

    public MatchConstraintsNested<A> editOrNewMatchConstraintsLike(MatchResources item) {
        return this.withNewMatchConstraintsLike(Optional.ofNullable(this.buildMatchConstraints()).orElse(item));
    }

    public ParamKindNested<A> editOrNewParamKind() {
        return this.withNewParamKindLike(Optional.ofNullable(this.buildParamKind()).orElse(new ParamKindBuilder().build()));
    }

    public ParamKindNested<A> editOrNewParamKindLike(ParamKind item) {
        return this.withNewParamKindLike(Optional.ofNullable(this.buildParamKind()).orElse(item));
    }

    public ParamKindNested<A> editParamKind() {
        return this.withNewParamKindLike(Optional.ofNullable(this.buildParamKind()).orElse(null));
    }

    public VariablesNested<A> editVariable(int index) {
        if (this.variables.size() <= index) {
            throw new RuntimeException(String.format("Can't edit %s. Index exceeds size.", "variables"));
        }
        return this.setNewVariableLike(index, this.buildVariable(index));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        MutatingAdmissionPolicySpecFluent that = (MutatingAdmissionPolicySpecFluent)((Object)o);
        if (!Objects.equals(this.failurePolicy, that.failurePolicy)) {
            return false;
        }
        if (!Objects.equals(this.matchConditions, that.matchConditions)) {
            return false;
        }
        if (!Objects.equals((Object)this.matchConstraints, (Object)that.matchConstraints)) {
            return false;
        }
        if (!Objects.equals(this.mutations, that.mutations)) {
            return false;
        }
        if (!Objects.equals((Object)this.paramKind, (Object)that.paramKind)) {
            return false;
        }
        if (!Objects.equals(this.reinvocationPolicy, that.reinvocationPolicy)) {
            return false;
        }
        if (!Objects.equals(this.variables, that.variables)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public String getFailurePolicy() {
        return this.failurePolicy;
    }

    public String getReinvocationPolicy() {
        return this.reinvocationPolicy;
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean hasFailurePolicy() {
        return this.failurePolicy != null;
    }

    public boolean hasMatchConditions() {
        return this.matchConditions != null && !this.matchConditions.isEmpty();
    }

    public boolean hasMatchConstraints() {
        return this.matchConstraints != null;
    }

    public boolean hasMatchingMatchCondition(Predicate<MatchConditionBuilder> predicate) {
        for (MatchConditionBuilder item : this.matchConditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingMutation(Predicate<MutationBuilder> predicate) {
        for (MutationBuilder item : this.mutations) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMatchingVariable(Predicate<VariableBuilder> predicate) {
        for (VariableBuilder item : this.variables) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public boolean hasMutations() {
        return this.mutations != null && !this.mutations.isEmpty();
    }

    public boolean hasParamKind() {
        return this.paramKind != null;
    }

    public boolean hasReinvocationPolicy() {
        return this.reinvocationPolicy != null;
    }

    public boolean hasVariables() {
        return this.variables != null && !this.variables.isEmpty();
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.failurePolicy, this.matchConditions, this.matchConstraints, this.mutations, this.paramKind, this.reinvocationPolicy, this.variables, this.additionalProperties});
    }

    public A removeAllFromMatchConditions(Collection<MatchCondition> items) {
        if (this.matchConditions == null) {
            return (A)((Object)this);
        }
        for (MatchCondition item : items) {
            MatchConditionBuilder builder = new MatchConditionBuilder(item);
            this._visitables.get((Object)"matchConditions").remove((Object)builder);
            this.matchConditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromMutations(Collection<Mutation> items) {
        if (this.mutations == null) {
            return (A)((Object)this);
        }
        for (Mutation item : items) {
            MutationBuilder builder = new MutationBuilder(item);
            this._visitables.get((Object)"mutations").remove((Object)builder);
            this.mutations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeAllFromVariables(Collection<Variable> items) {
        if (this.variables == null) {
            return (A)((Object)this);
        }
        for (Variable item : items) {
            VariableBuilder builder = new VariableBuilder(item);
            this._visitables.get((Object)"variables").remove((Object)builder);
            this.variables.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public A removeFromMatchConditions(MatchCondition ... items) {
        if (this.matchConditions == null) {
            return (A)((Object)this);
        }
        for (MatchCondition item : items) {
            MatchConditionBuilder builder = new MatchConditionBuilder(item);
            this._visitables.get((Object)"matchConditions").remove((Object)builder);
            this.matchConditions.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromMutations(Mutation ... items) {
        if (this.mutations == null) {
            return (A)((Object)this);
        }
        for (Mutation item : items) {
            MutationBuilder builder = new MutationBuilder(item);
            this._visitables.get((Object)"mutations").remove((Object)builder);
            this.mutations.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeFromVariables(Variable ... items) {
        if (this.variables == null) {
            return (A)((Object)this);
        }
        for (Variable item : items) {
            VariableBuilder builder = new VariableBuilder(item);
            this._visitables.get((Object)"variables").remove((Object)builder);
            this.variables.remove((Object)builder);
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMatchConditions(Predicate<MatchConditionBuilder> predicate) {
        if (this.matchConditions == null) {
            return (A)((Object)this);
        }
        Iterator<MatchConditionBuilder> each = this.matchConditions.iterator();
        List visitables = this._visitables.get((Object)"matchConditions");
        while (each.hasNext()) {
            MatchConditionBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromMutations(Predicate<MutationBuilder> predicate) {
        if (this.mutations == null) {
            return (A)((Object)this);
        }
        Iterator<MutationBuilder> each = this.mutations.iterator();
        List visitables = this._visitables.get((Object)"mutations");
        while (each.hasNext()) {
            MutationBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public A removeMatchingFromVariables(Predicate<VariableBuilder> predicate) {
        if (this.variables == null) {
            return (A)((Object)this);
        }
        Iterator<VariableBuilder> each = this.variables.iterator();
        List visitables = this._visitables.get((Object)"variables");
        while (each.hasNext()) {
            VariableBuilder builder = each.next();
            if (!predicate.test(builder)) continue;
            visitables.remove((Object)builder);
            each.remove();
        }
        return (A)((Object)this);
    }

    public MatchConditionsNested<A> setNewMatchConditionLike(int index, MatchCondition item) {
        return new MatchConditionsNested(index, item);
    }

    public MutationsNested<A> setNewMutationLike(int index, Mutation item) {
        return new MutationsNested(index, item);
    }

    public VariablesNested<A> setNewVariableLike(int index, Variable item) {
        return new VariablesNested(index, item);
    }

    public A setToMatchConditions(int index, MatchCondition item) {
        if (this.matchConditions == null) {
            this.matchConditions = new ArrayList();
        }
        MatchConditionBuilder builder = new MatchConditionBuilder(item);
        if (index < 0 || index >= this.matchConditions.size()) {
            this._visitables.get((Object)"matchConditions").add(builder);
            this.matchConditions.add(builder);
        } else {
            this._visitables.get((Object)"matchConditions").add(builder);
            this.matchConditions.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToMutations(int index, Mutation item) {
        if (this.mutations == null) {
            this.mutations = new ArrayList();
        }
        MutationBuilder builder = new MutationBuilder(item);
        if (index < 0 || index >= this.mutations.size()) {
            this._visitables.get((Object)"mutations").add(builder);
            this.mutations.add(builder);
        } else {
            this._visitables.get((Object)"mutations").add(builder);
            this.mutations.set(index, builder);
        }
        return (A)((Object)this);
    }

    public A setToVariables(int index, Variable item) {
        if (this.variables == null) {
            this.variables = new ArrayList();
        }
        VariableBuilder builder = new VariableBuilder(item);
        if (index < 0 || index >= this.variables.size()) {
            this._visitables.get((Object)"variables").add(builder);
            this.variables.add(builder);
        } else {
            this._visitables.get((Object)"variables").add(builder);
            this.variables.set(index, builder);
        }
        return (A)((Object)this);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.failurePolicy != null) {
            sb.append("failurePolicy:");
            sb.append(this.failurePolicy);
            sb.append(",");
        }
        if (this.matchConditions != null && !this.matchConditions.isEmpty()) {
            sb.append("matchConditions:");
            sb.append(this.matchConditions);
            sb.append(",");
        }
        if (this.matchConstraints != null) {
            sb.append("matchConstraints:");
            sb.append((Object)this.matchConstraints);
            sb.append(",");
        }
        if (this.mutations != null && !this.mutations.isEmpty()) {
            sb.append("mutations:");
            sb.append(this.mutations);
            sb.append(",");
        }
        if (this.paramKind != null) {
            sb.append("paramKind:");
            sb.append((Object)this.paramKind);
            sb.append(",");
        }
        if (this.reinvocationPolicy != null) {
            sb.append("reinvocationPolicy:");
            sb.append(this.reinvocationPolicy);
            sb.append(",");
        }
        if (this.variables != null && !this.variables.isEmpty()) {
            sb.append("variables:");
            sb.append(this.variables);
            sb.append(",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public A withFailurePolicy(String failurePolicy) {
        this.failurePolicy = failurePolicy;
        return (A)((Object)this);
    }

    public A withMatchConditions(List<MatchCondition> matchConditions) {
        if (this.matchConditions != null) {
            this._visitables.get((Object)"matchConditions").clear();
        }
        if (matchConditions != null) {
            this.matchConditions = new ArrayList();
            for (MatchCondition item : matchConditions) {
                this.addToMatchConditions(item);
            }
        } else {
            this.matchConditions = null;
        }
        return (A)((Object)this);
    }

    public A withMatchConditions(MatchCondition ... matchConditions) {
        if (this.matchConditions != null) {
            this.matchConditions.clear();
            this._visitables.remove((Object)"matchConditions");
        }
        if (matchConditions != null) {
            for (MatchCondition item : matchConditions) {
                this.addToMatchConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public A withMatchConstraints(MatchResources matchConstraints) {
        this._visitables.remove((Object)"matchConstraints");
        if (matchConstraints != null) {
            this.matchConstraints = new MatchResourcesBuilder(matchConstraints);
            this._visitables.get((Object)"matchConstraints").add(this.matchConstraints);
        } else {
            this.matchConstraints = null;
            this._visitables.get((Object)"matchConstraints").remove((Object)this.matchConstraints);
        }
        return (A)((Object)this);
    }

    public A withMutations(List<Mutation> mutations) {
        if (this.mutations != null) {
            this._visitables.get((Object)"mutations").clear();
        }
        if (mutations != null) {
            this.mutations = new ArrayList();
            for (Mutation item : mutations) {
                this.addToMutations(item);
            }
        } else {
            this.mutations = null;
        }
        return (A)((Object)this);
    }

    public A withMutations(Mutation ... mutations) {
        if (this.mutations != null) {
            this.mutations.clear();
            this._visitables.remove((Object)"mutations");
        }
        if (mutations != null) {
            for (Mutation item : mutations) {
                this.addToMutations(item);
            }
        }
        return (A)((Object)this);
    }

    public MatchConstraintsNested<A> withNewMatchConstraints() {
        return new MatchConstraintsNested(null);
    }

    public MatchConstraintsNested<A> withNewMatchConstraintsLike(MatchResources item) {
        return new MatchConstraintsNested(item);
    }

    public ParamKindNested<A> withNewParamKind() {
        return new ParamKindNested(null);
    }

    public A withNewParamKind(String apiVersion, String kind) {
        return this.withParamKind(new ParamKind(apiVersion, kind));
    }

    public ParamKindNested<A> withNewParamKindLike(ParamKind item) {
        return new ParamKindNested(item);
    }

    public A withParamKind(ParamKind paramKind) {
        this._visitables.remove((Object)"paramKind");
        if (paramKind != null) {
            this.paramKind = new ParamKindBuilder(paramKind);
            this._visitables.get((Object)"paramKind").add(this.paramKind);
        } else {
            this.paramKind = null;
            this._visitables.get((Object)"paramKind").remove((Object)this.paramKind);
        }
        return (A)((Object)this);
    }

    public A withReinvocationPolicy(String reinvocationPolicy) {
        this.reinvocationPolicy = reinvocationPolicy;
        return (A)((Object)this);
    }

    public A withVariables(List<Variable> variables) {
        if (this.variables != null) {
            this._visitables.get((Object)"variables").clear();
        }
        if (variables != null) {
            this.variables = new ArrayList();
            for (Variable item : variables) {
                this.addToVariables(item);
            }
        } else {
            this.variables = null;
        }
        return (A)((Object)this);
    }

    public A withVariables(Variable ... variables) {
        if (this.variables != null) {
            this.variables.clear();
            this._visitables.remove((Object)"variables");
        }
        if (variables != null) {
            for (Variable item : variables) {
                this.addToVariables(item);
            }
        }
        return (A)((Object)this);
    }

    public class VariablesNested<N>
    extends VariableFluent<VariablesNested<N>>
    implements Nested<N> {
        VariableBuilder builder;
        int index;

        VariablesNested(int index, Variable item) {
            this.index = index;
            this.builder = new VariableBuilder(this, item);
        }

        public N and() {
            return (N)MutatingAdmissionPolicySpecFluent.this.setToVariables(this.index, this.builder.build());
        }

        public N endVariable() {
            return this.and();
        }
    }

    public class ParamKindNested<N>
    extends ParamKindFluent<ParamKindNested<N>>
    implements Nested<N> {
        ParamKindBuilder builder;

        ParamKindNested(ParamKind item) {
            this.builder = new ParamKindBuilder(this, item);
        }

        public N and() {
            return (N)MutatingAdmissionPolicySpecFluent.this.withParamKind(this.builder.build());
        }

        public N endParamKind() {
            return this.and();
        }
    }

    public class MutationsNested<N>
    extends MutationFluent<MutationsNested<N>>
    implements Nested<N> {
        MutationBuilder builder;
        int index;

        MutationsNested(int index, Mutation item) {
            this.index = index;
            this.builder = new MutationBuilder(this, item);
        }

        public N and() {
            return (N)MutatingAdmissionPolicySpecFluent.this.setToMutations(this.index, this.builder.build());
        }

        public N endMutation() {
            return this.and();
        }
    }

    public class MatchConstraintsNested<N>
    extends MatchResourcesFluent<MatchConstraintsNested<N>>
    implements Nested<N> {
        MatchResourcesBuilder builder;

        MatchConstraintsNested(MatchResources item) {
            this.builder = new MatchResourcesBuilder(this, item);
        }

        public N and() {
            return (N)MutatingAdmissionPolicySpecFluent.this.withMatchConstraints(this.builder.build());
        }

        public N endMatchConstraints() {
            return this.and();
        }
    }

    public class MatchConditionsNested<N>
    extends MatchConditionFluent<MatchConditionsNested<N>>
    implements Nested<N> {
        MatchConditionBuilder builder;
        int index;

        MatchConditionsNested(int index, MatchCondition item) {
            this.index = index;
            this.builder = new MatchConditionBuilder(this, item);
        }

        public N and() {
            return (N)MutatingAdmissionPolicySpecFluent.this.setToMatchConditions(this.index, this.builder.build());
        }

        public N endMatchCondition() {
            return this.and();
        }
    }
}

