package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.util.Collection;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.LabelSelectorFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class MatchResourcesFluent<A extends MatchResourcesFluent<A>> extends BaseFluent<A>{
  public MatchResourcesFluent() {
  }
  
  public MatchResourcesFluent(MatchResources instance) {
    this.copyInstance(instance);
  }
  private ArrayList<NamedRuleWithOperationsBuilder> excludeResourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();
  private String matchPolicy;
  private LabelSelectorBuilder namespaceSelector;
  private LabelSelectorBuilder objectSelector;
  private ArrayList<NamedRuleWithOperationsBuilder> resourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(MatchResources instance) {
    instance = (instance != null ? instance : new MatchResources());
    if (instance != null) {
          this.withExcludeResourceRules(instance.getExcludeResourceRules());
          this.withMatchPolicy(instance.getMatchPolicy());
          this.withNamespaceSelector(instance.getNamespaceSelector());
          this.withObjectSelector(instance.getObjectSelector());
          this.withResourceRules(instance.getResourceRules());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public A addToExcludeResourceRules(int index,NamedRuleWithOperations item) {
    if (this.excludeResourceRules == null) {this.excludeResourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
    if (index < 0 || index >= excludeResourceRules.size()) {
        _visitables.get("excludeResourceRules").add(builder);
        excludeResourceRules.add(builder);
    } else {
        _visitables.get("excludeResourceRules").add(builder);
        excludeResourceRules.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToExcludeResourceRules(int index,NamedRuleWithOperations item) {
    if (this.excludeResourceRules == null) {this.excludeResourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
    if (index < 0 || index >= excludeResourceRules.size()) {
        _visitables.get("excludeResourceRules").add(builder);
        excludeResourceRules.add(builder);
    } else {
        _visitables.get("excludeResourceRules").add(builder);
        excludeResourceRules.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToExcludeResourceRules(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.NamedRuleWithOperations... items) {
    if (this.excludeResourceRules == null) {this.excludeResourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("excludeResourceRules").add(builder);this.excludeResourceRules.add(builder);} return (A)this;
  }
  
  public A addAllToExcludeResourceRules(Collection<NamedRuleWithOperations> items) {
    if (this.excludeResourceRules == null) {this.excludeResourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("excludeResourceRules").add(builder);this.excludeResourceRules.add(builder);} return (A)this;
  }
  
  public A removeFromExcludeResourceRules(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.NamedRuleWithOperations... items) {
    if (this.excludeResourceRules == null) return (A)this;
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("excludeResourceRules").remove(builder); this.excludeResourceRules.remove(builder);} return (A)this;
  }
  
  public A removeAllFromExcludeResourceRules(Collection<NamedRuleWithOperations> items) {
    if (this.excludeResourceRules == null) return (A)this;
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("excludeResourceRules").remove(builder); this.excludeResourceRules.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromExcludeResourceRules(Predicate<NamedRuleWithOperationsBuilder> predicate) {
    if (excludeResourceRules == null) return (A) this;
    final Iterator<NamedRuleWithOperationsBuilder> each = excludeResourceRules.iterator();
    final List visitables = _visitables.get("excludeResourceRules");
    while (each.hasNext()) {
      NamedRuleWithOperationsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NamedRuleWithOperations> buildExcludeResourceRules() {
    return this.excludeResourceRules != null ? build(excludeResourceRules) : null;
  }
  
  public NamedRuleWithOperations buildExcludeResourceRule(int index) {
    return this.excludeResourceRules.get(index).build();
  }
  
  public NamedRuleWithOperations buildFirstExcludeResourceRule() {
    return this.excludeResourceRules.get(0).build();
  }
  
  public NamedRuleWithOperations buildLastExcludeResourceRule() {
    return this.excludeResourceRules.get(excludeResourceRules.size() - 1).build();
  }
  
  public NamedRuleWithOperations buildMatchingExcludeResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
      for (NamedRuleWithOperationsBuilder item : excludeResourceRules) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingExcludeResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
      for (NamedRuleWithOperationsBuilder item : excludeResourceRules) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withExcludeResourceRules(List<NamedRuleWithOperations> excludeResourceRules) {
    if (this.excludeResourceRules != null) {
      this._visitables.get("excludeResourceRules").clear();
    }
    if (excludeResourceRules != null) {
        this.excludeResourceRules = new ArrayList();
        for (NamedRuleWithOperations item : excludeResourceRules) {
          this.addToExcludeResourceRules(item);
        }
    } else {
      this.excludeResourceRules = null;
    }
    return (A) this;
  }
  
  public A withExcludeResourceRules(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.NamedRuleWithOperations... excludeResourceRules) {
    if (this.excludeResourceRules != null) {
        this.excludeResourceRules.clear();
        _visitables.remove("excludeResourceRules");
    }
    if (excludeResourceRules != null) {
      for (NamedRuleWithOperations item : excludeResourceRules) {
        this.addToExcludeResourceRules(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasExcludeResourceRules() {
    return this.excludeResourceRules != null && !this.excludeResourceRules.isEmpty();
  }
  
  public ExcludeResourceRulesNested<A> addNewExcludeResourceRule() {
    return new ExcludeResourceRulesNested(-1, null);
  }
  
  public ExcludeResourceRulesNested<A> addNewExcludeResourceRuleLike(NamedRuleWithOperations item) {
    return new ExcludeResourceRulesNested(-1, item);
  }
  
  public ExcludeResourceRulesNested<A> setNewExcludeResourceRuleLike(int index,NamedRuleWithOperations item) {
    return new ExcludeResourceRulesNested(index, item);
  }
  
  public ExcludeResourceRulesNested<A> editExcludeResourceRule(int index) {
    if (excludeResourceRules.size() <= index) throw new RuntimeException("Can't edit excludeResourceRules. Index exceeds size.");
    return setNewExcludeResourceRuleLike(index, buildExcludeResourceRule(index));
  }
  
  public ExcludeResourceRulesNested<A> editFirstExcludeResourceRule() {
    if (excludeResourceRules.size() == 0) throw new RuntimeException("Can't edit first excludeResourceRules. The list is empty.");
    return setNewExcludeResourceRuleLike(0, buildExcludeResourceRule(0));
  }
  
  public ExcludeResourceRulesNested<A> editLastExcludeResourceRule() {
    int index = excludeResourceRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last excludeResourceRules. The list is empty.");
    return setNewExcludeResourceRuleLike(index, buildExcludeResourceRule(index));
  }
  
  public ExcludeResourceRulesNested<A> editMatchingExcludeResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<excludeResourceRules.size();i++) { 
    if (predicate.test(excludeResourceRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching excludeResourceRules. No match found.");
    return setNewExcludeResourceRuleLike(index, buildExcludeResourceRule(index));
  }
  
  public String getMatchPolicy() {
    return this.matchPolicy;
  }
  
  public A withMatchPolicy(String matchPolicy) {
    this.matchPolicy = matchPolicy;
    return (A) this;
  }
  
  public boolean hasMatchPolicy() {
    return this.matchPolicy != null;
  }
  
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector != null ? this.namespaceSelector.build() : null;
  }
  
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    this._visitables.remove("namespaceSelector");
    if (namespaceSelector != null) {
        this.namespaceSelector = new LabelSelectorBuilder(namespaceSelector);
        this._visitables.get("namespaceSelector").add(this.namespaceSelector);
    } else {
        this.namespaceSelector = null;
        this._visitables.get("namespaceSelector").remove(this.namespaceSelector);
    }
    return (A) this;
  }
  
  public boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new NamespaceSelectorNested(null);
  }
  
  public NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new NamespaceSelectorNested(item);
  }
  
  public NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(null));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(java.util.Optional.ofNullable(buildNamespaceSelector()).orElse(item));
  }
  
  public LabelSelector buildObjectSelector() {
    return this.objectSelector != null ? this.objectSelector.build() : null;
  }
  
  public A withObjectSelector(LabelSelector objectSelector) {
    this._visitables.remove("objectSelector");
    if (objectSelector != null) {
        this.objectSelector = new LabelSelectorBuilder(objectSelector);
        this._visitables.get("objectSelector").add(this.objectSelector);
    } else {
        this.objectSelector = null;
        this._visitables.get("objectSelector").remove(this.objectSelector);
    }
    return (A) this;
  }
  
  public boolean hasObjectSelector() {
    return this.objectSelector != null;
  }
  
  public ObjectSelectorNested<A> withNewObjectSelector() {
    return new ObjectSelectorNested(null);
  }
  
  public ObjectSelectorNested<A> withNewObjectSelectorLike(LabelSelector item) {
    return new ObjectSelectorNested(item);
  }
  
  public ObjectSelectorNested<A> editObjectSelector() {
    return withNewObjectSelectorLike(java.util.Optional.ofNullable(buildObjectSelector()).orElse(null));
  }
  
  public ObjectSelectorNested<A> editOrNewObjectSelector() {
    return withNewObjectSelectorLike(java.util.Optional.ofNullable(buildObjectSelector()).orElse(new LabelSelectorBuilder().build()));
  }
  
  public ObjectSelectorNested<A> editOrNewObjectSelectorLike(LabelSelector item) {
    return withNewObjectSelectorLike(java.util.Optional.ofNullable(buildObjectSelector()).orElse(item));
  }
  
  public A addToResourceRules(int index,NamedRuleWithOperations item) {
    if (this.resourceRules == null) {this.resourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
    if (index < 0 || index >= resourceRules.size()) {
        _visitables.get("resourceRules").add(builder);
        resourceRules.add(builder);
    } else {
        _visitables.get("resourceRules").add(builder);
        resourceRules.add(index, builder);
    }
    return (A)this;
  }
  
  public A setToResourceRules(int index,NamedRuleWithOperations item) {
    if (this.resourceRules == null) {this.resourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
    if (index < 0 || index >= resourceRules.size()) {
        _visitables.get("resourceRules").add(builder);
        resourceRules.add(builder);
    } else {
        _visitables.get("resourceRules").add(builder);
        resourceRules.set(index, builder);
    }
    return (A)this;
  }
  
  public A addToResourceRules(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.NamedRuleWithOperations... items) {
    if (this.resourceRules == null) {this.resourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("resourceRules").add(builder);this.resourceRules.add(builder);} return (A)this;
  }
  
  public A addAllToResourceRules(Collection<NamedRuleWithOperations> items) {
    if (this.resourceRules == null) {this.resourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("resourceRules").add(builder);this.resourceRules.add(builder);} return (A)this;
  }
  
  public A removeFromResourceRules(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.NamedRuleWithOperations... items) {
    if (this.resourceRules == null) return (A)this;
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("resourceRules").remove(builder); this.resourceRules.remove(builder);} return (A)this;
  }
  
  public A removeAllFromResourceRules(Collection<NamedRuleWithOperations> items) {
    if (this.resourceRules == null) return (A)this;
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("resourceRules").remove(builder); this.resourceRules.remove(builder);} return (A)this;
  }
  
  public A removeMatchingFromResourceRules(Predicate<NamedRuleWithOperationsBuilder> predicate) {
    if (resourceRules == null) return (A) this;
    final Iterator<NamedRuleWithOperationsBuilder> each = resourceRules.iterator();
    final List visitables = _visitables.get("resourceRules");
    while (each.hasNext()) {
      NamedRuleWithOperationsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  public List<NamedRuleWithOperations> buildResourceRules() {
    return this.resourceRules != null ? build(resourceRules) : null;
  }
  
  public NamedRuleWithOperations buildResourceRule(int index) {
    return this.resourceRules.get(index).build();
  }
  
  public NamedRuleWithOperations buildFirstResourceRule() {
    return this.resourceRules.get(0).build();
  }
  
  public NamedRuleWithOperations buildLastResourceRule() {
    return this.resourceRules.get(resourceRules.size() - 1).build();
  }
  
  public NamedRuleWithOperations buildMatchingResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
      for (NamedRuleWithOperationsBuilder item : resourceRules) {
        if (predicate.test(item)) {
          return item.build();
        }
      }
      return null;
  }
  
  public boolean hasMatchingResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
      for (NamedRuleWithOperationsBuilder item : resourceRules) {
        if (predicate.test(item)) {
          return true;
        }
      }
      return false;
  }
  
  public A withResourceRules(List<NamedRuleWithOperations> resourceRules) {
    if (this.resourceRules != null) {
      this._visitables.get("resourceRules").clear();
    }
    if (resourceRules != null) {
        this.resourceRules = new ArrayList();
        for (NamedRuleWithOperations item : resourceRules) {
          this.addToResourceRules(item);
        }
    } else {
      this.resourceRules = null;
    }
    return (A) this;
  }
  
  public A withResourceRules(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.NamedRuleWithOperations... resourceRules) {
    if (this.resourceRules != null) {
        this.resourceRules.clear();
        _visitables.remove("resourceRules");
    }
    if (resourceRules != null) {
      for (NamedRuleWithOperations item : resourceRules) {
        this.addToResourceRules(item);
      }
    }
    return (A) this;
  }
  
  public boolean hasResourceRules() {
    return this.resourceRules != null && !this.resourceRules.isEmpty();
  }
  
  public ResourceRulesNested<A> addNewResourceRule() {
    return new ResourceRulesNested(-1, null);
  }
  
  public ResourceRulesNested<A> addNewResourceRuleLike(NamedRuleWithOperations item) {
    return new ResourceRulesNested(-1, item);
  }
  
  public ResourceRulesNested<A> setNewResourceRuleLike(int index,NamedRuleWithOperations item) {
    return new ResourceRulesNested(index, item);
  }
  
  public ResourceRulesNested<A> editResourceRule(int index) {
    if (resourceRules.size() <= index) throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
    return setNewResourceRuleLike(index, buildResourceRule(index));
  }
  
  public ResourceRulesNested<A> editFirstResourceRule() {
    if (resourceRules.size() == 0) throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
    return setNewResourceRuleLike(0, buildResourceRule(0));
  }
  
  public ResourceRulesNested<A> editLastResourceRule() {
    int index = resourceRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
    return setNewResourceRuleLike(index, buildResourceRule(index));
  }
  
  public ResourceRulesNested<A> editMatchingResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceRules.size();i++) { 
    if (predicate.test(resourceRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceRules. No match found.");
    return setNewResourceRuleLike(index, buildResourceRule(index));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    MatchResourcesFluent that = (MatchResourcesFluent) o;
    if (!java.util.Objects.equals(excludeResourceRules, that.excludeResourceRules)) return false;
    if (!java.util.Objects.equals(matchPolicy, that.matchPolicy)) return false;
    if (!java.util.Objects.equals(namespaceSelector, that.namespaceSelector)) return false;
    if (!java.util.Objects.equals(objectSelector, that.objectSelector)) return false;
    if (!java.util.Objects.equals(resourceRules, that.resourceRules)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(excludeResourceRules,  matchPolicy,  namespaceSelector,  objectSelector,  resourceRules,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (excludeResourceRules != null && !excludeResourceRules.isEmpty()) { sb.append("excludeResourceRules:"); sb.append(excludeResourceRules + ","); }
    if (matchPolicy != null) { sb.append("matchPolicy:"); sb.append(matchPolicy + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (objectSelector != null) { sb.append("objectSelector:"); sb.append(objectSelector + ","); }
    if (resourceRules != null && !resourceRules.isEmpty()) { sb.append("resourceRules:"); sb.append(resourceRules + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ExcludeResourceRulesNested<N> extends NamedRuleWithOperationsFluent<ExcludeResourceRulesNested<N>> implements Nested<N>{
    ExcludeResourceRulesNested(int index,NamedRuleWithOperations item) {
      this.index = index;
      this.builder = new NamedRuleWithOperationsBuilder(this, item);
    }
    NamedRuleWithOperationsBuilder builder;
    int index;
    
    public N and() {
      return (N) MatchResourcesFluent.this.setToExcludeResourceRules(index,builder.build());
    }
    
    public N endExcludeResourceRule() {
      return and();
    }
    
  
  }
  public class NamespaceSelectorNested<N> extends LabelSelectorFluent<NamespaceSelectorNested<N>> implements Nested<N>{
    NamespaceSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) MatchResourcesFluent.this.withNamespaceSelector(builder.build());
    }
    
    public N endNamespaceSelector() {
      return and();
    }
    
  
  }
  public class ObjectSelectorNested<N> extends LabelSelectorFluent<ObjectSelectorNested<N>> implements Nested<N>{
    ObjectSelectorNested(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    LabelSelectorBuilder builder;
    
    public N and() {
      return (N) MatchResourcesFluent.this.withObjectSelector(builder.build());
    }
    
    public N endObjectSelector() {
      return and();
    }
    
  
  }
  public class ResourceRulesNested<N> extends NamedRuleWithOperationsFluent<ResourceRulesNested<N>> implements Nested<N>{
    ResourceRulesNested(int index,NamedRuleWithOperations item) {
      this.index = index;
      this.builder = new NamedRuleWithOperationsBuilder(this, item);
    }
    NamedRuleWithOperationsBuilder builder;
    int index;
    
    public N and() {
      return (N) MatchResourcesFluent.this.setToResourceRules(index,builder.build());
    }
    
    public N endResourceRule() {
      return and();
    }
    
  
  }

}