package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class MutationBuilder extends MutationFluent<MutationBuilder> implements VisitableBuilder<Mutation,MutationBuilder>{
  public MutationBuilder() {
    this(new Mutation());
  }
  
  public MutationBuilder(MutationFluent<?> fluent) {
    this(fluent, new Mutation());
  }
  
  public MutationBuilder(MutationFluent<?> fluent,Mutation instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public MutationBuilder(Mutation instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  MutationFluent<?> fluent;
  
  public Mutation build() {
    Mutation buildable = new Mutation(fluent.buildApplyConfiguration(),fluent.buildJsonPatch(),fluent.getPatchType());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}