/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.BaseFluent;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.Condition;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.TypeChecking;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.TypeCheckingBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.TypeCheckingFluent;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingAdmissionPolicyStatus;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class ValidatingAdmissionPolicyStatusFluent<A extends ValidatingAdmissionPolicyStatusFluent<A>>
extends BaseFluent<A> {
    private List<Condition> conditions = new ArrayList<Condition>();
    private Long observedGeneration;
    private TypeCheckingBuilder typeChecking;
    private Map<String, Object> additionalProperties;

    public ValidatingAdmissionPolicyStatusFluent() {
    }

    public ValidatingAdmissionPolicyStatusFluent(ValidatingAdmissionPolicyStatus instance) {
        this.copyInstance(instance);
    }

    protected void copyInstance(ValidatingAdmissionPolicyStatus instance) {
        ValidatingAdmissionPolicyStatus validatingAdmissionPolicyStatus = instance = instance != null ? instance : new ValidatingAdmissionPolicyStatus();
        if (instance != null) {
            this.withConditions(instance.getConditions());
            this.withObservedGeneration(instance.getObservedGeneration());
            this.withTypeChecking(instance.getTypeChecking());
            this.withAdditionalProperties(instance.getAdditionalProperties());
        }
    }

    public A addToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.add(index, item);
        return (A)((Object)this);
    }

    public A setToConditions(int index, Condition item) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        this.conditions.set(index, item);
        return (A)((Object)this);
    }

    public A addToConditions(Condition ... items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A addAllToConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            this.conditions = new ArrayList<Condition>();
        }
        for (Condition item : items) {
            this.conditions.add(item);
        }
        return (A)((Object)this);
    }

    public A removeFromConditions(Condition ... items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public A removeAllFromConditions(Collection<Condition> items) {
        if (this.conditions == null) {
            return (A)((Object)this);
        }
        for (Condition item : items) {
            this.conditions.remove(item);
        }
        return (A)((Object)this);
    }

    public List<Condition> getConditions() {
        return this.conditions;
    }

    public Condition getCondition(int index) {
        return this.conditions.get(index);
    }

    public Condition getFirstCondition() {
        return this.conditions.get(0);
    }

    public Condition getLastCondition() {
        return this.conditions.get(this.conditions.size() - 1);
    }

    public Condition getMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return item;
        }
        return null;
    }

    public boolean hasMatchingCondition(Predicate<Condition> predicate) {
        for (Condition item : this.conditions) {
            if (!predicate.test(item)) continue;
            return true;
        }
        return false;
    }

    public A withConditions(List<Condition> conditions) {
        if (conditions != null) {
            this.conditions = new ArrayList<Condition>();
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        } else {
            this.conditions = null;
        }
        return (A)((Object)this);
    }

    public A withConditions(Condition ... conditions) {
        if (this.conditions != null) {
            this.conditions.clear();
            this._visitables.remove((Object)"conditions");
        }
        if (conditions != null) {
            for (Condition item : conditions) {
                this.addToConditions(item);
            }
        }
        return (A)((Object)this);
    }

    public boolean hasConditions() {
        return this.conditions != null && !this.conditions.isEmpty();
    }

    public Long getObservedGeneration() {
        return this.observedGeneration;
    }

    public A withObservedGeneration(Long observedGeneration) {
        this.observedGeneration = observedGeneration;
        return (A)((Object)this);
    }

    public boolean hasObservedGeneration() {
        return this.observedGeneration != null;
    }

    public TypeChecking buildTypeChecking() {
        return this.typeChecking != null ? this.typeChecking.build() : null;
    }

    public A withTypeChecking(TypeChecking typeChecking) {
        this._visitables.remove((Object)"typeChecking");
        if (typeChecking != null) {
            this.typeChecking = new TypeCheckingBuilder(typeChecking);
            this._visitables.get((Object)"typeChecking").add(this.typeChecking);
        } else {
            this.typeChecking = null;
            this._visitables.get((Object)"typeChecking").remove((Object)this.typeChecking);
        }
        return (A)((Object)this);
    }

    public boolean hasTypeChecking() {
        return this.typeChecking != null;
    }

    public TypeCheckingNested<A> withNewTypeChecking() {
        return new TypeCheckingNested(null);
    }

    public TypeCheckingNested<A> withNewTypeCheckingLike(TypeChecking item) {
        return new TypeCheckingNested(item);
    }

    public TypeCheckingNested<A> editTypeChecking() {
        return this.withNewTypeCheckingLike(Optional.ofNullable(this.buildTypeChecking()).orElse(null));
    }

    public TypeCheckingNested<A> editOrNewTypeChecking() {
        return this.withNewTypeCheckingLike(Optional.ofNullable(this.buildTypeChecking()).orElse(new TypeCheckingBuilder().build()));
    }

    public TypeCheckingNested<A> editOrNewTypeCheckingLike(TypeChecking item) {
        return this.withNewTypeCheckingLike(Optional.ofNullable(this.buildTypeChecking()).orElse(item));
    }

    public A addToAdditionalProperties(String key, Object value) {
        if (this.additionalProperties == null && key != null && value != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (key != null && value != null) {
            this.additionalProperties.put(key, value);
        }
        return (A)((Object)this);
    }

    public A addToAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null && map != null) {
            this.additionalProperties = new LinkedHashMap<String, Object>();
        }
        if (map != null) {
            this.additionalProperties.putAll(map);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(String key) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (key != null && this.additionalProperties != null) {
            this.additionalProperties.remove(key);
        }
        return (A)((Object)this);
    }

    public A removeFromAdditionalProperties(Map<String, Object> map) {
        if (this.additionalProperties == null) {
            return (A)((Object)this);
        }
        if (map != null) {
            for (String key : map.keySet()) {
                if (this.additionalProperties == null) continue;
                this.additionalProperties.remove(key);
            }
        }
        return (A)((Object)this);
    }

    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    public <K, V> A withAdditionalProperties(Map<String, Object> additionalProperties) {
        this.additionalProperties = additionalProperties == null ? null : new LinkedHashMap<String, Object>(additionalProperties);
        return (A)((Object)this);
    }

    public boolean hasAdditionalProperties() {
        return this.additionalProperties != null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ValidatingAdmissionPolicyStatusFluent that = (ValidatingAdmissionPolicyStatusFluent)((Object)o);
        if (!Objects.equals(this.conditions, that.conditions)) {
            return false;
        }
        if (!Objects.equals(this.observedGeneration, that.observedGeneration)) {
            return false;
        }
        if (!Objects.equals((Object)this.typeChecking, (Object)that.typeChecking)) {
            return false;
        }
        return Objects.equals(this.additionalProperties, that.additionalProperties);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.conditions, this.observedGeneration, this.typeChecking, this.additionalProperties, super.hashCode()});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.conditions != null && !this.conditions.isEmpty()) {
            sb.append("conditions:");
            sb.append(this.conditions + ",");
        }
        if (this.observedGeneration != null) {
            sb.append("observedGeneration:");
            sb.append(this.observedGeneration + ",");
        }
        if (this.typeChecking != null) {
            sb.append("typeChecking:");
            sb.append(this.typeChecking + ",");
        }
        if (this.additionalProperties != null && !this.additionalProperties.isEmpty()) {
            sb.append("additionalProperties:");
            sb.append(this.additionalProperties);
        }
        sb.append("}");
        return sb.toString();
    }

    public class TypeCheckingNested<N>
    extends TypeCheckingFluent<TypeCheckingNested<N>>
    implements Nested<N> {
        TypeCheckingBuilder builder;

        TypeCheckingNested(TypeChecking item) {
            this.builder = new TypeCheckingBuilder(this, item);
        }

        public N and() {
            return (N)ValidatingAdmissionPolicyStatusFluent.this.withTypeChecking(this.builder.build());
        }

        public N endTypeChecking() {
            return this.and();
        }
    }
}

