package io.fabric8.kubernetes.api.model.authentication.v1beta1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import io.fabric8.kubernetes.api.model.authentication.UserInfo;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.model.authentication.UserInfoBuilder;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import io.fabric8.kubernetes.api.model.authentication.UserInfoFluent;
import java.util.Map;

/**
 * Generated
 */
@SuppressWarnings("unchecked")
public class SelfSubjectReviewStatusFluent<A extends SelfSubjectReviewStatusFluent<A>> extends BaseFluent<A>{
  public SelfSubjectReviewStatusFluent() {
  }
  
  public SelfSubjectReviewStatusFluent(SelfSubjectReviewStatus instance) {
    this.copyInstance(instance);
  }
  private UserInfoBuilder userInfo;
  private Map<String,Object> additionalProperties;
  
  protected void copyInstance(SelfSubjectReviewStatus instance) {
    instance = (instance != null ? instance : new SelfSubjectReviewStatus());
    if (instance != null) {
          this.withUserInfo(instance.getUserInfo());
          this.withAdditionalProperties(instance.getAdditionalProperties());
        }
  }
  
  public UserInfo buildUserInfo() {
    return this.userInfo != null ? this.userInfo.build() : null;
  }
  
  public A withUserInfo(UserInfo userInfo) {
    this._visitables.remove("userInfo");
    if (userInfo != null) {
        this.userInfo = new UserInfoBuilder(userInfo);
        this._visitables.get("userInfo").add(this.userInfo);
    } else {
        this.userInfo = null;
        this._visitables.get("userInfo").remove(this.userInfo);
    }
    return (A) this;
  }
  
  public boolean hasUserInfo() {
    return this.userInfo != null;
  }
  
  public UserInfoNested<A> withNewUserInfo() {
    return new UserInfoNested(null);
  }
  
  public UserInfoNested<A> withNewUserInfoLike(UserInfo item) {
    return new UserInfoNested(item);
  }
  
  public UserInfoNested<A> editUserInfo() {
    return withNewUserInfoLike(java.util.Optional.ofNullable(buildUserInfo()).orElse(null));
  }
  
  public UserInfoNested<A> editOrNewUserInfo() {
    return withNewUserInfoLike(java.util.Optional.ofNullable(buildUserInfo()).orElse(new UserInfoBuilder().build()));
  }
  
  public UserInfoNested<A> editOrNewUserInfoLike(UserInfo item) {
    return withNewUserInfoLike(java.util.Optional.ofNullable(buildUserInfo()).orElse(item));
  }
  
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) {
      this.additionalProperties = null;
    } else {
      this.additionalProperties = new LinkedHashMap(additionalProperties);
    }
    return (A) this;
  }
  
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    SelfSubjectReviewStatusFluent that = (SelfSubjectReviewStatusFluent) o;
    if (!java.util.Objects.equals(userInfo, that.userInfo)) return false;
    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;
    return true;
  }
  
  public int hashCode() {
    return java.util.Objects.hash(userInfo,  additionalProperties,  super.hashCode());
  }
  
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (userInfo != null) { sb.append("userInfo:"); sb.append(userInfo + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class UserInfoNested<N> extends UserInfoFluent<UserInfoNested<N>> implements Nested<N>{
    UserInfoNested(UserInfo item) {
      this.builder = new UserInfoBuilder(this, item);
    }
    UserInfoBuilder builder;
    
    public N and() {
      return (N) SelfSubjectReviewStatusFluent.this.withUserInfo(builder.build());
    }
    
    public N endUserInfo() {
      return and();
    }
    
  
  }

}