package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.ArrayList;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.lang.String;
import java.util.Map;
import java.util.LinkedHashMap;
import java.util.function.Predicate;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class RuleFluent<A extends RuleFluent<A>> extends BaseFluent<A>{
  public RuleFluent() {
  }
  public RuleFluent(Rule instance) {
    instance = (instance != null ? instance : new Rule());

    if (instance != null) {
      this.withApiGroups(instance.getApiGroups());
      this.withApiVersions(instance.getApiVersions());
      this.withResources(instance.getResources());
      this.withScope(instance.getScope());
      this.withApiGroups(instance.getApiGroups());
      this.withApiVersions(instance.getApiVersions());
      this.withResources(instance.getResources());
      this.withScope(instance.getScope());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> apiGroups = new ArrayList<String>();
  private List<String> apiVersions = new ArrayList<String>();
  private List<String> resources = new ArrayList<String>();
  private String scope;
  private Map<String,Object> additionalProperties;
  public A addToApiGroups(int index,String item) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    this.apiGroups.add(index, item);
    return (A)this;
  }
  public A setToApiGroups(int index,String item) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    this.apiGroups.set(index, item); return (A)this;
  }
  public A addToApiGroups(java.lang.String... items) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    for (String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  public A addAllToApiGroups(Collection<String> items) {
    if (this.apiGroups == null) {this.apiGroups = new ArrayList<String>();}
    for (String item : items) {this.apiGroups.add(item);} return (A)this;
  }
  public A removeFromApiGroups(java.lang.String... items) {
    if (this.apiGroups == null) return (A)this;
    for (String item : items) { this.apiGroups.remove(item);} return (A)this;
  }
  public A removeAllFromApiGroups(Collection<String> items) {
    if (this.apiGroups == null) return (A)this;
    for (String item : items) { this.apiGroups.remove(item);} return (A)this;
  }
  public List<String> getApiGroups() {
    return this.apiGroups;
  }
  public String getApiGroup(int index) {
    return this.apiGroups.get(index);
  }
  public String getFirstApiGroup() {
    return this.apiGroups.get(0);
  }
  public String getLastApiGroup() {
    return this.apiGroups.get(apiGroups.size() - 1);
  }
  public String getMatchingApiGroup(Predicate<String> predicate) {
    for (String item: apiGroups) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingApiGroup(Predicate<String> predicate) {
    for (String item: apiGroups) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withApiGroups(List<String> apiGroups) {
    if (apiGroups != null) {this.apiGroups = new ArrayList(); for (String item : apiGroups){this.addToApiGroups(item);}} else { this.apiGroups = null;} return (A) this;
  }
  public A withApiGroups(java.lang.String... apiGroups) {
    if (this.apiGroups != null) {this.apiGroups.clear(); _visitables.remove("apiGroups"); }
    if (apiGroups != null) {for (String item :apiGroups){ this.addToApiGroups(item);}} return (A) this;
  }
  public boolean hasApiGroups() {
    return apiGroups != null && !apiGroups.isEmpty();
  }
  public A addToApiVersions(int index,String item) {
    if (this.apiVersions == null) {this.apiVersions = new ArrayList<String>();}
    this.apiVersions.add(index, item);
    return (A)this;
  }
  public A setToApiVersions(int index,String item) {
    if (this.apiVersions == null) {this.apiVersions = new ArrayList<String>();}
    this.apiVersions.set(index, item); return (A)this;
  }
  public A addToApiVersions(java.lang.String... items) {
    if (this.apiVersions == null) {this.apiVersions = new ArrayList<String>();}
    for (String item : items) {this.apiVersions.add(item);} return (A)this;
  }
  public A addAllToApiVersions(Collection<String> items) {
    if (this.apiVersions == null) {this.apiVersions = new ArrayList<String>();}
    for (String item : items) {this.apiVersions.add(item);} return (A)this;
  }
  public A removeFromApiVersions(java.lang.String... items) {
    if (this.apiVersions == null) return (A)this;
    for (String item : items) { this.apiVersions.remove(item);} return (A)this;
  }
  public A removeAllFromApiVersions(Collection<String> items) {
    if (this.apiVersions == null) return (A)this;
    for (String item : items) { this.apiVersions.remove(item);} return (A)this;
  }
  public List<String> getApiVersions() {
    return this.apiVersions;
  }
  public String getApiVersion(int index) {
    return this.apiVersions.get(index);
  }
  public String getFirstApiVersion() {
    return this.apiVersions.get(0);
  }
  public String getLastApiVersion() {
    return this.apiVersions.get(apiVersions.size() - 1);
  }
  public String getMatchingApiVersion(Predicate<String> predicate) {
    for (String item: apiVersions) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingApiVersion(Predicate<String> predicate) {
    for (String item: apiVersions) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withApiVersions(List<String> apiVersions) {
    if (apiVersions != null) {this.apiVersions = new ArrayList(); for (String item : apiVersions){this.addToApiVersions(item);}} else { this.apiVersions = null;} return (A) this;
  }
  public A withApiVersions(java.lang.String... apiVersions) {
    if (this.apiVersions != null) {this.apiVersions.clear(); _visitables.remove("apiVersions"); }
    if (apiVersions != null) {for (String item :apiVersions){ this.addToApiVersions(item);}} return (A) this;
  }
  public boolean hasApiVersions() {
    return apiVersions != null && !apiVersions.isEmpty();
  }
  public A addToResources(int index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.add(index, item);
    return (A)this;
  }
  public A setToResources(int index,String item) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    this.resources.set(index, item); return (A)this;
  }
  public A addToResources(java.lang.String... items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  public A addAllToResources(Collection<String> items) {
    if (this.resources == null) {this.resources = new ArrayList<String>();}
    for (String item : items) {this.resources.add(item);} return (A)this;
  }
  public A removeFromResources(java.lang.String... items) {
    if (this.resources == null) return (A)this;
    for (String item : items) { this.resources.remove(item);} return (A)this;
  }
  public A removeAllFromResources(Collection<String> items) {
    if (this.resources == null) return (A)this;
    for (String item : items) { this.resources.remove(item);} return (A)this;
  }
  public List<String> getResources() {
    return this.resources;
  }
  public String getResource(int index) {
    return this.resources.get(index);
  }
  public String getFirstResource() {
    return this.resources.get(0);
  }
  public String getLastResource() {
    return this.resources.get(resources.size() - 1);
  }
  public String getMatchingResource(Predicate<String> predicate) {
    for (String item: resources) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingResource(Predicate<String> predicate) {
    for (String item: resources) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResources(List<String> resources) {
    if (resources != null) {this.resources = new ArrayList(); for (String item : resources){this.addToResources(item);}} else { this.resources = null;} return (A) this;
  }
  public A withResources(java.lang.String... resources) {
    if (this.resources != null) {this.resources.clear(); _visitables.remove("resources"); }
    if (resources != null) {for (String item :resources){ this.addToResources(item);}} return (A) this;
  }
  public boolean hasResources() {
    return resources != null && !resources.isEmpty();
  }
  public String getScope() {
    return this.scope;
  }
  public A withScope(String scope) {
    this.scope=scope; return (A) this;
  }
  public boolean hasScope() {
    return this.scope != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    RuleFluent that = (RuleFluent) o;
    if (!java.util.Objects.equals(apiGroups, that.apiGroups)) return false;

    if (!java.util.Objects.equals(apiVersions, that.apiVersions)) return false;

    if (!java.util.Objects.equals(resources, that.resources)) return false;

    if (!java.util.Objects.equals(scope, that.scope)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiGroups,  apiVersions,  resources,  scope,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiGroups != null && !apiGroups.isEmpty()) { sb.append("apiGroups:"); sb.append(apiGroups + ","); }
    if (apiVersions != null && !apiVersions.isEmpty()) { sb.append("apiVersions:"); sb.append(apiVersions + ","); }
    if (resources != null && !resources.isEmpty()) { sb.append("resources:"); sb.append(resources + ","); }
    if (scope != null) { sb.append("scope:"); sb.append(scope + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  
}