package io.fabric8.kubernetes.api.model.admission.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class AdmissionResponseBuilder extends AdmissionResponseFluent<AdmissionResponseBuilder> implements VisitableBuilder<AdmissionResponse,AdmissionResponseBuilder>{
  public AdmissionResponseBuilder() {
    this(false);
  }
  public AdmissionResponseBuilder(Boolean validationEnabled) {
    this(new AdmissionResponse(), validationEnabled);
  }
  public AdmissionResponseBuilder(AdmissionResponseFluent<?> fluent) {
    this(fluent, false);
  }
  public AdmissionResponseBuilder(AdmissionResponseFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new AdmissionResponse(), validationEnabled);
  }
  public AdmissionResponseBuilder(AdmissionResponseFluent<?> fluent,AdmissionResponse instance) {
    this(fluent, instance, false);
  }
  public AdmissionResponseBuilder(AdmissionResponseFluent<?> fluent,AdmissionResponse instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new AdmissionResponse());

    if (instance != null) {
      fluent.withAllowed(instance.getAllowed());
      fluent.withAuditAnnotations(instance.getAuditAnnotations());
      fluent.withPatch(instance.getPatch());
      fluent.withPatchType(instance.getPatchType());
      fluent.withStatus(instance.getStatus());
      fluent.withUid(instance.getUid());
      fluent.withWarnings(instance.getWarnings());
      fluent.withAllowed(instance.getAllowed());
      fluent.withAuditAnnotations(instance.getAuditAnnotations());
      fluent.withPatch(instance.getPatch());
      fluent.withPatchType(instance.getPatchType());
      fluent.withStatus(instance.getStatus());
      fluent.withUid(instance.getUid());
      fluent.withWarnings(instance.getWarnings());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public AdmissionResponseBuilder(AdmissionResponse instance) {
    this(instance,false);
  }
  public AdmissionResponseBuilder(AdmissionResponse instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new AdmissionResponse());

    if (instance != null) {
      this.withAllowed(instance.getAllowed());
      this.withAuditAnnotations(instance.getAuditAnnotations());
      this.withPatch(instance.getPatch());
      this.withPatchType(instance.getPatchType());
      this.withStatus(instance.getStatus());
      this.withUid(instance.getUid());
      this.withWarnings(instance.getWarnings());
      this.withAllowed(instance.getAllowed());
      this.withAuditAnnotations(instance.getAuditAnnotations());
      this.withPatch(instance.getPatch());
      this.withPatchType(instance.getPatchType());
      this.withStatus(instance.getStatus());
      this.withUid(instance.getUid());
      this.withWarnings(instance.getWarnings());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  AdmissionResponseFluent<?> fluent;
  Boolean validationEnabled;
  public AdmissionResponse build() {
    AdmissionResponse buildable = new AdmissionResponse(fluent.getAllowed(),fluent.getAuditAnnotations(),fluent.getPatch(),fluent.getPatchType(),fluent.getStatus(),fluent.getUid(),fluent.getWarnings());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}