package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectAccessReviewBuilder extends SubjectAccessReviewFluent<SubjectAccessReviewBuilder> implements VisitableBuilder<SubjectAccessReview,SubjectAccessReviewBuilder>{
  public SubjectAccessReviewBuilder() {
    this(false);
  }
  public SubjectAccessReviewBuilder(Boolean validationEnabled) {
    this(new SubjectAccessReview(), validationEnabled);
  }
  public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubjectAccessReview(), validationEnabled);
  }
  public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent,SubjectAccessReview instance) {
    this(fluent, instance, false);
  }
  public SubjectAccessReviewBuilder(SubjectAccessReviewFluent<?> fluent,SubjectAccessReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new SubjectAccessReview());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubjectAccessReviewBuilder(SubjectAccessReview instance) {
    this(instance,false);
  }
  public SubjectAccessReviewBuilder(SubjectAccessReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new SubjectAccessReview());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubjectAccessReviewFluent<?> fluent;
  Boolean validationEnabled;
  public SubjectAccessReview build() {
    SubjectAccessReview buildable = new SubjectAccessReview(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}