package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TokenReviewBuilder extends TokenReviewFluent<TokenReviewBuilder> implements VisitableBuilder<TokenReview,TokenReviewBuilder>{
  public TokenReviewBuilder() {
    this(false);
  }
  public TokenReviewBuilder(Boolean validationEnabled) {
    this(new TokenReview(), validationEnabled);
  }
  public TokenReviewBuilder(TokenReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public TokenReviewBuilder(TokenReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TokenReview(), validationEnabled);
  }
  public TokenReviewBuilder(TokenReviewFluent<?> fluent,TokenReview instance) {
    this(fluent, instance, false);
  }
  public TokenReviewBuilder(TokenReviewFluent<?> fluent,TokenReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TokenReview());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TokenReviewBuilder(TokenReview instance) {
    this(instance,false);
  }
  public TokenReviewBuilder(TokenReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TokenReview());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TokenReviewFluent<?> fluent;
  Boolean validationEnabled;
  public TokenReview build() {
    TokenReview buildable = new TokenReview(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}