package io.fabric8.kubernetes.api.model.authentication;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Long;
import java.util.Collection;
import java.lang.Object;
import java.util.List;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class TokenRequestSpecFluent<A extends TokenRequestSpecFluent<A>> extends BaseFluent<A>{
  public TokenRequestSpecFluent() {
  }
  public TokenRequestSpecFluent(TokenRequestSpec instance) {
    instance = (instance != null ? instance : new TokenRequestSpec());

    if (instance != null) {
      this.withAudiences(instance.getAudiences());
      this.withBoundObjectRef(instance.getBoundObjectRef());
      this.withExpirationSeconds(instance.getExpirationSeconds());
      this.withAudiences(instance.getAudiences());
      this.withBoundObjectRef(instance.getBoundObjectRef());
      this.withExpirationSeconds(instance.getExpirationSeconds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private List<String> audiences = new ArrayList<String>();
  private BoundObjectReferenceBuilder boundObjectRef;
  private Long expirationSeconds;
  private Map<String,Object> additionalProperties;
  public A addToAudiences(int index,String item) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    this.audiences.add(index, item);
    return (A)this;
  }
  public A setToAudiences(int index,String item) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    this.audiences.set(index, item); return (A)this;
  }
  public A addToAudiences(java.lang.String... items) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    for (String item : items) {this.audiences.add(item);} return (A)this;
  }
  public A addAllToAudiences(Collection<String> items) {
    if (this.audiences == null) {this.audiences = new ArrayList<String>();}
    for (String item : items) {this.audiences.add(item);} return (A)this;
  }
  public A removeFromAudiences(java.lang.String... items) {
    if (this.audiences == null) return (A)this;
    for (String item : items) { this.audiences.remove(item);} return (A)this;
  }
  public A removeAllFromAudiences(Collection<String> items) {
    if (this.audiences == null) return (A)this;
    for (String item : items) { this.audiences.remove(item);} return (A)this;
  }
  public List<String> getAudiences() {
    return this.audiences;
  }
  public String getAudience(int index) {
    return this.audiences.get(index);
  }
  public String getFirstAudience() {
    return this.audiences.get(0);
  }
  public String getLastAudience() {
    return this.audiences.get(audiences.size() - 1);
  }
  public String getMatchingAudience(Predicate<String> predicate) {
    for (String item: audiences) { if(predicate.test(item)){ return item;} } return null;
  }
  public boolean hasMatchingAudience(Predicate<String> predicate) {
    for (String item: audiences) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withAudiences(List<String> audiences) {
    if (audiences != null) {this.audiences = new ArrayList(); for (String item : audiences){this.addToAudiences(item);}} else { this.audiences = null;} return (A) this;
  }
  public A withAudiences(java.lang.String... audiences) {
    if (this.audiences != null) {this.audiences.clear(); _visitables.remove("audiences"); }
    if (audiences != null) {for (String item :audiences){ this.addToAudiences(item);}} return (A) this;
  }
  public boolean hasAudiences() {
    return audiences != null && !audiences.isEmpty();
  }
  public BoundObjectReference buildBoundObjectRef() {
    return this.boundObjectRef!=null ?this.boundObjectRef.build():null;
  }
  public A withBoundObjectRef(BoundObjectReference boundObjectRef) {
    _visitables.get("boundObjectRef").remove(this.boundObjectRef);
    if (boundObjectRef!=null){ this.boundObjectRef= new BoundObjectReferenceBuilder(boundObjectRef); _visitables.get("boundObjectRef").add(this.boundObjectRef);} else { this.boundObjectRef = null; _visitables.get("boundObjectRef").remove(this.boundObjectRef); } return (A) this;
  }
  public boolean hasBoundObjectRef() {
    return this.boundObjectRef != null;
  }
  public A withNewBoundObjectRef(String apiVersion,String kind,String name,String uid) {
    return (A)withBoundObjectRef(new BoundObjectReference(apiVersion, kind, name, uid));
  }
  public BoundObjectRefNested<A> withNewBoundObjectRef() {
    return new BoundObjectRefNested(null);
  }
  public BoundObjectRefNested<A> withNewBoundObjectRefLike(BoundObjectReference item) {
    return new BoundObjectRefNested(item);
  }
  public BoundObjectRefNested<A> editBoundObjectRef() {
    return withNewBoundObjectRefLike(java.util.Optional.ofNullable(buildBoundObjectRef()).orElse(null));
  }
  public BoundObjectRefNested<A> editOrNewBoundObjectRef() {
    return withNewBoundObjectRefLike(java.util.Optional.ofNullable(buildBoundObjectRef()).orElse(new BoundObjectReferenceBuilder().build()));
  }
  public BoundObjectRefNested<A> editOrNewBoundObjectRefLike(BoundObjectReference item) {
    return withNewBoundObjectRefLike(java.util.Optional.ofNullable(buildBoundObjectRef()).orElse(item));
  }
  public Long getExpirationSeconds() {
    return this.expirationSeconds;
  }
  public A withExpirationSeconds(Long expirationSeconds) {
    this.expirationSeconds=expirationSeconds; return (A) this;
  }
  public boolean hasExpirationSeconds() {
    return this.expirationSeconds != null;
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    TokenRequestSpecFluent that = (TokenRequestSpecFluent) o;
    if (!java.util.Objects.equals(audiences, that.audiences)) return false;

    if (!java.util.Objects.equals(boundObjectRef, that.boundObjectRef)) return false;

    if (!java.util.Objects.equals(expirationSeconds, that.expirationSeconds)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(audiences,  boundObjectRef,  expirationSeconds,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (audiences != null && !audiences.isEmpty()) { sb.append("audiences:"); sb.append(audiences + ","); }
    if (boundObjectRef != null) { sb.append("boundObjectRef:"); sb.append(boundObjectRef + ","); }
    if (expirationSeconds != null) { sb.append("expirationSeconds:"); sb.append(expirationSeconds + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class BoundObjectRefNested<N> extends BoundObjectReferenceFluent<BoundObjectRefNested<N>> implements Nested<N>{
    BoundObjectRefNested(BoundObjectReference item) {
      this.builder = new BoundObjectReferenceBuilder(this, item);
    }
    BoundObjectReferenceBuilder builder;
    public N and() {
      return (N) TokenRequestSpecFluent.this.withBoundObjectRef(builder.build());
    }
    public N endBoundObjectRef() {
      return and();
    }
    
  }
  
}