package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValidatingAdmissionPolicyBuilder extends ValidatingAdmissionPolicyFluent<ValidatingAdmissionPolicyBuilder> implements VisitableBuilder<ValidatingAdmissionPolicy,ValidatingAdmissionPolicyBuilder>{
  public ValidatingAdmissionPolicyBuilder() {
    this(false);
  }
  public ValidatingAdmissionPolicyBuilder(Boolean validationEnabled) {
    this(new ValidatingAdmissionPolicy(), validationEnabled);
  }
  public ValidatingAdmissionPolicyBuilder(ValidatingAdmissionPolicyFluent<?> fluent) {
    this(fluent, false);
  }
  public ValidatingAdmissionPolicyBuilder(ValidatingAdmissionPolicyFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new ValidatingAdmissionPolicy(), validationEnabled);
  }
  public ValidatingAdmissionPolicyBuilder(ValidatingAdmissionPolicyFluent<?> fluent,ValidatingAdmissionPolicy instance) {
    this(fluent, instance, false);
  }
  public ValidatingAdmissionPolicyBuilder(ValidatingAdmissionPolicyFluent<?> fluent,ValidatingAdmissionPolicy instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new ValidatingAdmissionPolicy());

    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withSpec(instance.getSpec());
      fluent.withStatus(instance.getStatus());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public ValidatingAdmissionPolicyBuilder(ValidatingAdmissionPolicy instance) {
    this(instance,false);
  }
  public ValidatingAdmissionPolicyBuilder(ValidatingAdmissionPolicy instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new ValidatingAdmissionPolicy());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withSpec(instance.getSpec());
      this.withStatus(instance.getStatus());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  ValidatingAdmissionPolicyFluent<?> fluent;
  Boolean validationEnabled;
  public ValidatingAdmissionPolicy build() {
    ValidatingAdmissionPolicy buildable = new ValidatingAdmissionPolicy(fluent.getApiVersion(),fluent.getKind(),fluent.buildMetadata(),fluent.buildSpec(),fluent.buildStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}