package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TypeCheckingBuilder extends TypeCheckingFluent<TypeCheckingBuilder> implements VisitableBuilder<TypeChecking,TypeCheckingBuilder>{
  public TypeCheckingBuilder() {
    this(false);
  }
  public TypeCheckingBuilder(Boolean validationEnabled) {
    this(new TypeChecking(), validationEnabled);
  }
  public TypeCheckingBuilder(TypeCheckingFluent<?> fluent) {
    this(fluent, false);
  }
  public TypeCheckingBuilder(TypeCheckingFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TypeChecking(), validationEnabled);
  }
  public TypeCheckingBuilder(TypeCheckingFluent<?> fluent,TypeChecking instance) {
    this(fluent, instance, false);
  }
  public TypeCheckingBuilder(TypeCheckingFluent<?> fluent,TypeChecking instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    instance = (instance != null ? instance : new TypeChecking());

    if (instance != null) {
      fluent.withExpressionWarnings(instance.getExpressionWarnings());
      fluent.withExpressionWarnings(instance.getExpressionWarnings());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TypeCheckingBuilder(TypeChecking instance) {
    this(instance,false);
  }
  public TypeCheckingBuilder(TypeChecking instance,Boolean validationEnabled) {
    this.fluent = this; 
    instance = (instance != null ? instance : new TypeChecking());

    if (instance != null) {
      this.withExpressionWarnings(instance.getExpressionWarnings());
      this.withExpressionWarnings(instance.getExpressionWarnings());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TypeCheckingFluent<?> fluent;
  Boolean validationEnabled;
  public TypeChecking build() {
    TypeChecking buildable = new TypeChecking(fluent.buildExpressionWarnings());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}