package io.fabric8.kubernetes.api.model.admission.v1;

import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.util.LinkedHashMap;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class AdmissionReviewFluent<A extends AdmissionReviewFluent<A>> extends BaseFluent<A>{
  public AdmissionReviewFluent() {
  }
  public AdmissionReviewFluent(AdmissionReview instance) {
    instance = (instance != null ? instance : new AdmissionReview());

    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withRequest(instance.getRequest());
      this.withResponse(instance.getResponse());
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withRequest(instance.getRequest());
      this.withResponse(instance.getResponse());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String apiVersion;
  private String kind;
  private AdmissionRequest request;
  private AdmissionResponseBuilder response;
  private Map<String,Object> additionalProperties;
  public String getApiVersion() {
    return this.apiVersion;
  }
  public A withApiVersion(String apiVersion) {
    this.apiVersion=apiVersion; return (A) this;
  }
  public boolean hasApiVersion() {
    return this.apiVersion != null;
  }
  public String getKind() {
    return this.kind;
  }
  public A withKind(String kind) {
    this.kind=kind; return (A) this;
  }
  public boolean hasKind() {
    return this.kind != null;
  }
  public AdmissionRequest getRequest() {
    return this.request;
  }
  public A withRequest(AdmissionRequest request) {
    this.request=request; return (A) this;
  }
  public boolean hasRequest() {
    return this.request != null;
  }
  public AdmissionResponse buildResponse() {
    return this.response!=null ?this.response.build():null;
  }
  public A withResponse(AdmissionResponse response) {
    _visitables.get("response").remove(this.response);
    if (response!=null){ this.response= new AdmissionResponseBuilder(response); _visitables.get("response").add(this.response);} else { this.response = null; _visitables.get("response").remove(this.response); } return (A) this;
  }
  public boolean hasResponse() {
    return this.response != null;
  }
  public ResponseNested<A> withNewResponse() {
    return new ResponseNested(null);
  }
  public ResponseNested<A> withNewResponseLike(AdmissionResponse item) {
    return new ResponseNested(item);
  }
  public ResponseNested<A> editResponse() {
    return withNewResponseLike(java.util.Optional.ofNullable(buildResponse()).orElse(null));
  }
  public ResponseNested<A> editOrNewResponse() {
    return withNewResponseLike(java.util.Optional.ofNullable(buildResponse()).orElse(new AdmissionResponseBuilder().build()));
  }
  public ResponseNested<A> editOrNewResponseLike(AdmissionResponse item) {
    return withNewResponseLike(java.util.Optional.ofNullable(buildResponse()).orElse(item));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    AdmissionReviewFluent that = (AdmissionReviewFluent) o;
    if (!java.util.Objects.equals(apiVersion, that.apiVersion)) return false;

    if (!java.util.Objects.equals(kind, that.kind)) return false;

    if (!java.util.Objects.equals(request, that.request)) return false;

    if (!java.util.Objects.equals(response, that.response)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(apiVersion,  kind,  request,  response,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (apiVersion != null) { sb.append("apiVersion:"); sb.append(apiVersion + ","); }
    if (kind != null) { sb.append("kind:"); sb.append(kind + ","); }
    if (request != null) { sb.append("request:"); sb.append(request + ","); }
    if (response != null) { sb.append("response:"); sb.append(response + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  public class ResponseNested<N> extends AdmissionResponseFluent<ResponseNested<N>> implements Nested<N>{
    ResponseNested(AdmissionResponse item) {
      this.builder = new AdmissionResponseBuilder(this, item);
    }
    AdmissionResponseBuilder builder;
    public N and() {
      return (N) AdmissionReviewFluent.this.withResponse(builder.build());
    }
    public N endResponse() {
      return and();
    }
    
  }
  
}