package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class TokenRequestSpecBuilder extends TokenRequestSpecFluentImpl<TokenRequestSpecBuilder> implements VisitableBuilder<TokenRequestSpec,TokenRequestSpecBuilder>{
  public TokenRequestSpecBuilder() {
    this(false);
  }
  public TokenRequestSpecBuilder(Boolean validationEnabled) {
    this(new TokenRequestSpec(), validationEnabled);
  }
  public TokenRequestSpecBuilder(TokenRequestSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public TokenRequestSpecBuilder(TokenRequestSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new TokenRequestSpec(), validationEnabled);
  }
  public TokenRequestSpecBuilder(TokenRequestSpecFluent<?> fluent,TokenRequestSpec instance) {
    this(fluent, instance, false);
  }
  public TokenRequestSpecBuilder(TokenRequestSpecFluent<?> fluent,TokenRequestSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withAudiences(instance.getAudiences());
      fluent.withBoundObjectRef(instance.getBoundObjectRef());
      fluent.withExpirationSeconds(instance.getExpirationSeconds());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public TokenRequestSpecBuilder(TokenRequestSpec instance) {
    this(instance,false);
  }
  public TokenRequestSpecBuilder(TokenRequestSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withAudiences(instance.getAudiences());
      this.withBoundObjectRef(instance.getBoundObjectRef());
      this.withExpirationSeconds(instance.getExpirationSeconds());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  TokenRequestSpecFluent<?> fluent;
  Boolean validationEnabled;
  public TokenRequestSpec build() {
    TokenRequestSpec buildable = new TokenRequestSpec(fluent.getAudiences(),fluent.getBoundObjectRef(),fluent.getExpirationSeconds());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}