package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class ValidatingAdmissionPolicySpecFluentImpl<A extends ValidatingAdmissionPolicySpecFluent<A>> extends BaseFluent<A> implements ValidatingAdmissionPolicySpecFluent<A>{
  public ValidatingAdmissionPolicySpecFluentImpl() {
  }
  public ValidatingAdmissionPolicySpecFluentImpl(ValidatingAdmissionPolicySpec instance) {
    if (instance != null) {
      this.withFailurePolicy(instance.getFailurePolicy());
      this.withMatchConstraints(instance.getMatchConstraints());
      this.withParamKind(instance.getParamKind());
      this.withValidations(instance.getValidations());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
  }
  private String failurePolicy;
  private MatchResourcesBuilder matchConstraints;
  private ParamKindBuilder paramKind;
  private ArrayList<ValidationBuilder> validations = new ArrayList<ValidationBuilder>();
  private Map<String,Object> additionalProperties;
  public String getFailurePolicy() {
    return this.failurePolicy;
  }
  public A withFailurePolicy(String failurePolicy) {
    this.failurePolicy=failurePolicy; return (A) this;
  }
  public Boolean hasFailurePolicy() {
    return this.failurePolicy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildMatchConstraints instead.
   * @return The buildable object.
   */
  @Deprecated
  public MatchResources getMatchConstraints() {
    return this.matchConstraints!=null ?this.matchConstraints.build():null;
  }
  public MatchResources buildMatchConstraints() {
    return this.matchConstraints!=null ?this.matchConstraints.build():null;
  }
  public A withMatchConstraints(MatchResources matchConstraints) {
    _visitables.get("matchConstraints").remove(this.matchConstraints);
    if (matchConstraints!=null){ this.matchConstraints= new MatchResourcesBuilder(matchConstraints); _visitables.get("matchConstraints").add(this.matchConstraints);} else { this.matchConstraints = null; _visitables.get("matchConstraints").remove(this.matchConstraints); } return (A) this;
  }
  public Boolean hasMatchConstraints() {
    return this.matchConstraints != null;
  }
  public ValidatingAdmissionPolicySpecFluentImpl.MatchConstraintsNested<A> withNewMatchConstraints() {
    return new ValidatingAdmissionPolicySpecFluentImpl.MatchConstraintsNestedImpl();
  }
  public ValidatingAdmissionPolicySpecFluentImpl.MatchConstraintsNested<A> withNewMatchConstraintsLike(MatchResources item) {
    return new ValidatingAdmissionPolicySpecFluentImpl.MatchConstraintsNestedImpl(item);
  }
  public ValidatingAdmissionPolicySpecFluentImpl.MatchConstraintsNested<A> editMatchConstraints() {
    return withNewMatchConstraintsLike(getMatchConstraints());
  }
  public ValidatingAdmissionPolicySpecFluentImpl.MatchConstraintsNested<A> editOrNewMatchConstraints() {
    return withNewMatchConstraintsLike(getMatchConstraints() != null ? getMatchConstraints(): new MatchResourcesBuilder().build());
  }
  public ValidatingAdmissionPolicySpecFluentImpl.MatchConstraintsNested<A> editOrNewMatchConstraintsLike(MatchResources item) {
    return withNewMatchConstraintsLike(getMatchConstraints() != null ? getMatchConstraints(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildParamKind instead.
   * @return The buildable object.
   */
  @Deprecated
  public ParamKind getParamKind() {
    return this.paramKind!=null ?this.paramKind.build():null;
  }
  public ParamKind buildParamKind() {
    return this.paramKind!=null ?this.paramKind.build():null;
  }
  public A withParamKind(ParamKind paramKind) {
    _visitables.get("paramKind").remove(this.paramKind);
    if (paramKind!=null){ this.paramKind= new ParamKindBuilder(paramKind); _visitables.get("paramKind").add(this.paramKind);} else { this.paramKind = null; _visitables.get("paramKind").remove(this.paramKind); } return (A) this;
  }
  public Boolean hasParamKind() {
    return this.paramKind != null;
  }
  public A withNewParamKind(String apiVersion,String kind) {
    return (A)withParamKind(new ParamKind(apiVersion, kind));
  }
  public ValidatingAdmissionPolicySpecFluentImpl.ParamKindNested<A> withNewParamKind() {
    return new ValidatingAdmissionPolicySpecFluentImpl.ParamKindNestedImpl();
  }
  public ValidatingAdmissionPolicySpecFluentImpl.ParamKindNested<A> withNewParamKindLike(ParamKind item) {
    return new ValidatingAdmissionPolicySpecFluentImpl.ParamKindNestedImpl(item);
  }
  public ValidatingAdmissionPolicySpecFluentImpl.ParamKindNested<A> editParamKind() {
    return withNewParamKindLike(getParamKind());
  }
  public ValidatingAdmissionPolicySpecFluentImpl.ParamKindNested<A> editOrNewParamKind() {
    return withNewParamKindLike(getParamKind() != null ? getParamKind(): new ParamKindBuilder().build());
  }
  public ValidatingAdmissionPolicySpecFluentImpl.ParamKindNested<A> editOrNewParamKindLike(ParamKind item) {
    return withNewParamKindLike(getParamKind() != null ? getParamKind(): item);
  }
  public A addToValidations(int index,Validation item) {
    if (this.validations == null) {this.validations = new ArrayList<ValidationBuilder>();}
    ValidationBuilder builder = new ValidationBuilder(item);
    if (index < 0 || index >= validations.size()) { _visitables.get("validations").add(builder); validations.add(builder); } else { _visitables.get("validations").add(index, builder); validations.add(index, builder);}
    return (A)this;
  }
  public A setToValidations(int index,Validation item) {
    if (this.validations == null) {this.validations = new ArrayList<ValidationBuilder>();}
    ValidationBuilder builder = new ValidationBuilder(item);
    if (index < 0 || index >= validations.size()) { _visitables.get("validations").add(builder); validations.add(builder); } else { _visitables.get("validations").set(index, builder); validations.set(index, builder);}
    return (A)this;
  }
  public A addToValidations(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Validation... items) {
    if (this.validations == null) {this.validations = new ArrayList<ValidationBuilder>();}
    for (Validation item : items) {ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").add(builder);this.validations.add(builder);} return (A)this;
  }
  public A addAllToValidations(Collection<Validation> items) {
    if (this.validations == null) {this.validations = new ArrayList<ValidationBuilder>();}
    for (Validation item : items) {ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").add(builder);this.validations.add(builder);} return (A)this;
  }
  public A removeFromValidations(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Validation... items) {
    for (Validation item : items) {ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").remove(builder);if (this.validations != null) {this.validations.remove(builder);}} return (A)this;
  }
  public A removeAllFromValidations(Collection<Validation> items) {
    for (Validation item : items) {ValidationBuilder builder = new ValidationBuilder(item);_visitables.get("validations").remove(builder);if (this.validations != null) {this.validations.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromValidations(Predicate<ValidationBuilder> predicate) {
    if (validations == null) return (A) this;
    final Iterator<ValidationBuilder> each = validations.iterator();
    final List visitables = _visitables.get("validations");
    while (each.hasNext()) {
      ValidationBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildValidations instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<Validation> getValidations() {
    return validations != null ? build(validations) : null;
  }
  public List<Validation> buildValidations() {
    return validations != null ? build(validations) : null;
  }
  public Validation buildValidation(int index) {
    return this.validations.get(index).build();
  }
  public Validation buildFirstValidation() {
    return this.validations.get(0).build();
  }
  public Validation buildLastValidation() {
    return this.validations.get(validations.size() - 1).build();
  }
  public Validation buildMatchingValidation(Predicate<ValidationBuilder> predicate) {
    for (ValidationBuilder item: validations) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingValidation(Predicate<ValidationBuilder> predicate) {
    for (ValidationBuilder item: validations) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withValidations(List<Validation> validations) {
    if (this.validations != null) { _visitables.get("validations").clear();}
    if (validations != null) {this.validations = new ArrayList(); for (Validation item : validations){this.addToValidations(item);}} else { this.validations = null;} return (A) this;
  }
  public A withValidations(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.Validation... validations) {
    if (this.validations != null) {this.validations.clear(); _visitables.remove("validations"); }
    if (validations != null) {for (Validation item :validations){ this.addToValidations(item);}} return (A) this;
  }
  public Boolean hasValidations() {
    return validations != null && !validations.isEmpty();
  }
  public A addNewValidation(String expression,String message,String reason) {
    return (A)addToValidations(new Validation(expression, message, reason));
  }
  public ValidatingAdmissionPolicySpecFluentImpl.ValidationsNested<A> addNewValidation() {
    return new ValidatingAdmissionPolicySpecFluentImpl.ValidationsNestedImpl();
  }
  public ValidatingAdmissionPolicySpecFluentImpl.ValidationsNested<A> addNewValidationLike(Validation item) {
    return new ValidatingAdmissionPolicySpecFluentImpl.ValidationsNestedImpl(-1, item);
  }
  public ValidatingAdmissionPolicySpecFluentImpl.ValidationsNested<A> setNewValidationLike(int index,Validation item) {
    return new ValidatingAdmissionPolicySpecFluentImpl.ValidationsNestedImpl(index, item);
  }
  public ValidatingAdmissionPolicySpecFluentImpl.ValidationsNested<A> editValidation(int index) {
    if (validations.size() <= index) throw new RuntimeException("Can't edit validations. Index exceeds size.");
    return setNewValidationLike(index, buildValidation(index));
  }
  public ValidatingAdmissionPolicySpecFluentImpl.ValidationsNested<A> editFirstValidation() {
    if (validations.size() == 0) throw new RuntimeException("Can't edit first validations. The list is empty.");
    return setNewValidationLike(0, buildValidation(0));
  }
  public ValidatingAdmissionPolicySpecFluentImpl.ValidationsNested<A> editLastValidation() {
    int index = validations.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last validations. The list is empty.");
    return setNewValidationLike(index, buildValidation(index));
  }
  public ValidatingAdmissionPolicySpecFluentImpl.ValidationsNested<A> editMatchingValidation(Predicate<ValidationBuilder> predicate) {
    int index = -1;
    for (int i=0;i<validations.size();i++) { 
    if (predicate.test(validations.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching validations. No match found.");
    return setNewValidationLike(index, buildValidation(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    if (!super.equals(o)) return false;
    ValidatingAdmissionPolicySpecFluentImpl that = (ValidatingAdmissionPolicySpecFluentImpl) o;
    if (!java.util.Objects.equals(failurePolicy, that.failurePolicy)) return false;

    if (!java.util.Objects.equals(matchConstraints, that.matchConstraints)) return false;

    if (!java.util.Objects.equals(paramKind, that.paramKind)) return false;

    if (!java.util.Objects.equals(validations, that.validations)) return false;

    if (!java.util.Objects.equals(additionalProperties, that.additionalProperties)) return false;

    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(failurePolicy,  matchConstraints,  paramKind,  validations,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (failurePolicy != null) { sb.append("failurePolicy:"); sb.append(failurePolicy + ","); }
    if (matchConstraints != null) { sb.append("matchConstraints:"); sb.append(matchConstraints + ","); }
    if (paramKind != null) { sb.append("paramKind:"); sb.append(paramKind + ","); }
    if (validations != null && !validations.isEmpty()) { sb.append("validations:"); sb.append(validations + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class MatchConstraintsNestedImpl<N> extends MatchResourcesFluentImpl<ValidatingAdmissionPolicySpecFluentImpl.MatchConstraintsNested<N>> implements ValidatingAdmissionPolicySpecFluentImpl.MatchConstraintsNested<N>,Nested<N>{
    MatchConstraintsNestedImpl(MatchResources item) {
      this.builder = new MatchResourcesBuilder(this, item);
    }
    MatchConstraintsNestedImpl() {
      this.builder = new MatchResourcesBuilder(this);
    }
    MatchResourcesBuilder builder;
    public N and() {
      return (N) ValidatingAdmissionPolicySpecFluentImpl.this.withMatchConstraints(builder.build());
    }
    public N endMatchConstraints() {
      return and();
    }
    
  }
  class ParamKindNestedImpl<N> extends ParamKindFluentImpl<ValidatingAdmissionPolicySpecFluentImpl.ParamKindNested<N>> implements ValidatingAdmissionPolicySpecFluentImpl.ParamKindNested<N>,Nested<N>{
    ParamKindNestedImpl(ParamKind item) {
      this.builder = new ParamKindBuilder(this, item);
    }
    ParamKindNestedImpl() {
      this.builder = new ParamKindBuilder(this);
    }
    ParamKindBuilder builder;
    public N and() {
      return (N) ValidatingAdmissionPolicySpecFluentImpl.this.withParamKind(builder.build());
    }
    public N endParamKind() {
      return and();
    }
    
  }
  class ValidationsNestedImpl<N> extends ValidationFluentImpl<ValidatingAdmissionPolicySpecFluentImpl.ValidationsNested<N>> implements ValidatingAdmissionPolicySpecFluentImpl.ValidationsNested<N>,Nested<N>{
    ValidationsNestedImpl(int index,Validation item) {
      this.index = index;
      this.builder = new ValidationBuilder(this, item);
    }
    ValidationsNestedImpl() {
      this.index = -1;
      this.builder = new ValidationBuilder(this);
    }
    ValidationBuilder builder;
    int index;
    public N and() {
      return (N) ValidatingAdmissionPolicySpecFluentImpl.this.setToValidations(index,builder.build());
    }
    public N endValidation() {
      return and();
    }
    
  }
  
}