package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class MutatingWebhookConfigurationBuilder extends MutatingWebhookConfigurationFluentImpl<MutatingWebhookConfigurationBuilder> implements VisitableBuilder<MutatingWebhookConfiguration,MutatingWebhookConfigurationBuilder>{
  public MutatingWebhookConfigurationBuilder() {
    this(false);
  }
  public MutatingWebhookConfigurationBuilder(Boolean validationEnabled) {
    this(new MutatingWebhookConfiguration(), validationEnabled);
  }
  public MutatingWebhookConfigurationBuilder(MutatingWebhookConfigurationFluent<?> fluent) {
    this(fluent, false);
  }
  public MutatingWebhookConfigurationBuilder(MutatingWebhookConfigurationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new MutatingWebhookConfiguration(), validationEnabled);
  }
  public MutatingWebhookConfigurationBuilder(MutatingWebhookConfigurationFluent<?> fluent,MutatingWebhookConfiguration instance) {
    this(fluent, instance, false);
  }
  public MutatingWebhookConfigurationBuilder(MutatingWebhookConfigurationFluent<?> fluent,MutatingWebhookConfiguration instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withApiVersion(instance.getApiVersion());
      fluent.withKind(instance.getKind());
      fluent.withMetadata(instance.getMetadata());
      fluent.withWebhooks(instance.getWebhooks());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public MutatingWebhookConfigurationBuilder(MutatingWebhookConfiguration instance) {
    this(instance,false);
  }
  public MutatingWebhookConfigurationBuilder(MutatingWebhookConfiguration instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withApiVersion(instance.getApiVersion());
      this.withKind(instance.getKind());
      this.withMetadata(instance.getMetadata());
      this.withWebhooks(instance.getWebhooks());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  MutatingWebhookConfigurationFluent<?> fluent;
  Boolean validationEnabled;
  public MutatingWebhookConfiguration build() {
    MutatingWebhookConfiguration buildable = new MutatingWebhookConfiguration(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getWebhooks());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}