package io.fabric8.kubernetes.api.model.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectRulesReviewStatusBuilder extends SubjectRulesReviewStatusFluentImpl<SubjectRulesReviewStatusBuilder> implements VisitableBuilder<SubjectRulesReviewStatus,SubjectRulesReviewStatusBuilder>{
  public SubjectRulesReviewStatusBuilder() {
    this(false);
  }
  public SubjectRulesReviewStatusBuilder(Boolean validationEnabled) {
    this(new SubjectRulesReviewStatus(), validationEnabled);
  }
  public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubjectRulesReviewStatus(), validationEnabled);
  }
  public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent,SubjectRulesReviewStatus instance) {
    this(fluent, instance, false);
  }
  public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatusFluent<?> fluent,SubjectRulesReviewStatus instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withEvaluationError(instance.getEvaluationError());
      fluent.withIncomplete(instance.getIncomplete());
      fluent.withNonResourceRules(instance.getNonResourceRules());
      fluent.withResourceRules(instance.getResourceRules());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatus instance) {
    this(instance,false);
  }
  public SubjectRulesReviewStatusBuilder(SubjectRulesReviewStatus instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withEvaluationError(instance.getEvaluationError());
      this.withIncomplete(instance.getIncomplete());
      this.withNonResourceRules(instance.getNonResourceRules());
      this.withResourceRules(instance.getResourceRules());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubjectRulesReviewStatusFluent<?> fluent;
  Boolean validationEnabled;
  public SubjectRulesReviewStatus build() {
    SubjectRulesReviewStatus buildable = new SubjectRulesReviewStatus(fluent.getEvaluationError(),fluent.getIncomplete(),fluent.getNonResourceRules(),fluent.getResourceRules());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}