package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SubjectAccessReviewSpecBuilder extends SubjectAccessReviewSpecFluentImpl<SubjectAccessReviewSpecBuilder> implements VisitableBuilder<SubjectAccessReviewSpec,SubjectAccessReviewSpecBuilder>{
  public SubjectAccessReviewSpecBuilder() {
    this(false);
  }
  public SubjectAccessReviewSpecBuilder(Boolean validationEnabled) {
    this(new SubjectAccessReviewSpec(), validationEnabled);
  }
  public SubjectAccessReviewSpecBuilder(SubjectAccessReviewSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SubjectAccessReviewSpecBuilder(SubjectAccessReviewSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SubjectAccessReviewSpec(), validationEnabled);
  }
  public SubjectAccessReviewSpecBuilder(SubjectAccessReviewSpecFluent<?> fluent,SubjectAccessReviewSpec instance) {
    this(fluent, instance, false);
  }
  public SubjectAccessReviewSpecBuilder(SubjectAccessReviewSpecFluent<?> fluent,SubjectAccessReviewSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    if (instance != null) {
      fluent.withExtra(instance.getExtra());
      fluent.withGroups(instance.getGroups());
      fluent.withNonResourceAttributes(instance.getNonResourceAttributes());
      fluent.withResourceAttributes(instance.getResourceAttributes());
      fluent.withUid(instance.getUid());
      fluent.withUser(instance.getUser());
      fluent.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  public SubjectAccessReviewSpecBuilder(SubjectAccessReviewSpec instance) {
    this(instance,false);
  }
  public SubjectAccessReviewSpecBuilder(SubjectAccessReviewSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    if (instance != null) {
      this.withExtra(instance.getExtra());
      this.withGroups(instance.getGroups());
      this.withNonResourceAttributes(instance.getNonResourceAttributes());
      this.withResourceAttributes(instance.getResourceAttributes());
      this.withUid(instance.getUid());
      this.withUser(instance.getUser());
      this.withAdditionalProperties(instance.getAdditionalProperties());
    }
    this.validationEnabled = validationEnabled; 
  }
  SubjectAccessReviewSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SubjectAccessReviewSpec build() {
    SubjectAccessReviewSpec buildable = new SubjectAccessReviewSpec(fluent.getExtra(),fluent.getGroups(),fluent.getNonResourceAttributes(),fluent.getResourceAttributes(),fluent.getUid(),fluent.getUser());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}