package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelfSubjectRulesReviewSpecBuilder extends SelfSubjectRulesReviewSpecFluentImpl<SelfSubjectRulesReviewSpecBuilder> implements VisitableBuilder<SelfSubjectRulesReviewSpec,SelfSubjectRulesReviewSpecBuilder>{
  public SelfSubjectRulesReviewSpecBuilder() {
    this(false);
  }
  public SelfSubjectRulesReviewSpecBuilder(Boolean validationEnabled) {
    this(new SelfSubjectRulesReviewSpec(), validationEnabled);
  }
  public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent) {
    this(fluent, false);
  }
  public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelfSubjectRulesReviewSpec(), validationEnabled);
  }
  public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,SelfSubjectRulesReviewSpec instance) {
    this(fluent, instance, false);
  }
  public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpecFluent<?> fluent,SelfSubjectRulesReviewSpec instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withNamespace(instance.getNamespace()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpec instance) {
    this(instance,false);
  }
  public SelfSubjectRulesReviewSpecBuilder(SelfSubjectRulesReviewSpec instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withNamespace(instance.getNamespace()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SelfSubjectRulesReviewSpecFluent<?> fluent;
  Boolean validationEnabled;
  public SelfSubjectRulesReviewSpec build() {
    SelfSubjectRulesReviewSpec buildable = new SelfSubjectRulesReviewSpec(fluent.getNamespace());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}