package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class ValidationBuilder extends ValidationFluentImpl<ValidationBuilder> implements VisitableBuilder<Validation,ValidationBuilder>{
  public ValidationBuilder() {
    this(false);
  }
  public ValidationBuilder(Boolean validationEnabled) {
    this(new Validation(), validationEnabled);
  }
  public ValidationBuilder(ValidationFluent<?> fluent) {
    this(fluent, false);
  }
  public ValidationBuilder(ValidationFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Validation(), validationEnabled);
  }
  public ValidationBuilder(ValidationFluent<?> fluent,Validation instance) {
    this(fluent, instance, false);
  }
  public ValidationBuilder(ValidationFluent<?> fluent,Validation instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExpression(instance.getExpression()); 
    fluent.withMessage(instance.getMessage()); 
    fluent.withReason(instance.getReason()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public ValidationBuilder(Validation instance) {
    this(instance,false);
  }
  public ValidationBuilder(Validation instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExpression(instance.getExpression()); 
    this.withMessage(instance.getMessage()); 
    this.withReason(instance.getReason()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  ValidationFluent<?> fluent;
  Boolean validationEnabled;
  public Validation build() {
    Validation buildable = new Validation(fluent.getExpression(),fluent.getMessage(),fluent.getReason());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}