package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.SuppressWarnings;
import io.fabric8.kubernetes.api.model.LabelSelectorFluentImpl;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.LinkedHashMap;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.LabelSelectorBuilder;
import io.fabric8.kubernetes.api.model.LabelSelector;
import java.lang.Integer;
import java.util.Collection;
import java.lang.Object;
import java.util.Map;

 /**
  * Generated
  */
  @SuppressWarnings(value = "unchecked")
  public class MatchResourcesFluentImpl<A extends MatchResourcesFluent<A>> extends BaseFluent<A> implements MatchResourcesFluent<A>{
  public MatchResourcesFluentImpl() {
  }
  public MatchResourcesFluentImpl(MatchResources instance) {
    this.withExcludeResourceRules(instance.getExcludeResourceRules()); 
    this.withMatchPolicy(instance.getMatchPolicy()); 
    this.withNamespaceSelector(instance.getNamespaceSelector()); 
    this.withObjectSelector(instance.getObjectSelector()); 
    this.withResourceRules(instance.getResourceRules()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

  }
  private ArrayList<NamedRuleWithOperationsBuilder> excludeResourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();
  private String matchPolicy;
  private LabelSelectorBuilder namespaceSelector;
  private LabelSelectorBuilder objectSelector;
  private ArrayList<NamedRuleWithOperationsBuilder> resourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();
  private Map<String,Object> additionalProperties;
  public A addToExcludeResourceRules(Integer index,NamedRuleWithOperations item) {
    if (this.excludeResourceRules == null) {this.excludeResourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("excludeResourceRules").add(index >= 0 ? index : _visitables.get("excludeResourceRules").size(), builder);this.excludeResourceRules.add(index >= 0 ? index : excludeResourceRules.size(), builder); return (A)this;
  }
  public A setToExcludeResourceRules(Integer index,NamedRuleWithOperations item) {
    if (this.excludeResourceRules == null) {this.excludeResourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
    if (index < 0 || index >= _visitables.get("excludeResourceRules").size()) { _visitables.get("excludeResourceRules").add(builder); } else { _visitables.get("excludeResourceRules").set(index, builder);}
    if (index < 0 || index >= excludeResourceRules.size()) { excludeResourceRules.add(builder); } else { excludeResourceRules.set(index, builder);}
     return (A)this;
  }
  public A addToExcludeResourceRules(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.NamedRuleWithOperations... items) {
    if (this.excludeResourceRules == null) {this.excludeResourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("excludeResourceRules").add(builder);this.excludeResourceRules.add(builder);} return (A)this;
  }
  public A addAllToExcludeResourceRules(Collection<NamedRuleWithOperations> items) {
    if (this.excludeResourceRules == null) {this.excludeResourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("excludeResourceRules").add(builder);this.excludeResourceRules.add(builder);} return (A)this;
  }
  public A removeFromExcludeResourceRules(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.NamedRuleWithOperations... items) {
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("excludeResourceRules").remove(builder);if (this.excludeResourceRules != null) {this.excludeResourceRules.remove(builder);}} return (A)this;
  }
  public A removeAllFromExcludeResourceRules(Collection<NamedRuleWithOperations> items) {
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("excludeResourceRules").remove(builder);if (this.excludeResourceRules != null) {this.excludeResourceRules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromExcludeResourceRules(Predicate<NamedRuleWithOperationsBuilder> predicate) {
    if (excludeResourceRules == null) return (A) this;
    final Iterator<NamedRuleWithOperationsBuilder> each = excludeResourceRules.iterator();
    final List visitables = _visitables.get("excludeResourceRules");
    while (each.hasNext()) {
      NamedRuleWithOperationsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildExcludeResourceRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedRuleWithOperations> getExcludeResourceRules() {
    return excludeResourceRules != null ? build(excludeResourceRules) : null;
  }
  public List<NamedRuleWithOperations> buildExcludeResourceRules() {
    return excludeResourceRules != null ? build(excludeResourceRules) : null;
  }
  public NamedRuleWithOperations buildExcludeResourceRule(Integer index) {
    return this.excludeResourceRules.get(index).build();
  }
  public NamedRuleWithOperations buildFirstExcludeResourceRule() {
    return this.excludeResourceRules.get(0).build();
  }
  public NamedRuleWithOperations buildLastExcludeResourceRule() {
    return this.excludeResourceRules.get(excludeResourceRules.size() - 1).build();
  }
  public NamedRuleWithOperations buildMatchingExcludeResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
    for (NamedRuleWithOperationsBuilder item: excludeResourceRules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingExcludeResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
    for (NamedRuleWithOperationsBuilder item: excludeResourceRules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withExcludeResourceRules(List<NamedRuleWithOperations> excludeResourceRules) {
    if (this.excludeResourceRules != null) { _visitables.get("excludeResourceRules").removeAll(this.excludeResourceRules);}
    if (excludeResourceRules != null) {this.excludeResourceRules = new ArrayList(); for (NamedRuleWithOperations item : excludeResourceRules){this.addToExcludeResourceRules(item);}} else { this.excludeResourceRules = null;} return (A) this;
  }
  public A withExcludeResourceRules(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.NamedRuleWithOperations... excludeResourceRules) {
    if (this.excludeResourceRules != null) {this.excludeResourceRules.clear();}
    if (excludeResourceRules != null) {for (NamedRuleWithOperations item :excludeResourceRules){ this.addToExcludeResourceRules(item);}} return (A) this;
  }
  public Boolean hasExcludeResourceRules() {
    return excludeResourceRules != null && !excludeResourceRules.isEmpty();
  }
  public MatchResourcesFluent.ExcludeResourceRulesNested<A> addNewExcludeResourceRule() {
    return new MatchResourcesFluentImpl.ExcludeResourceRulesNestedImpl();
  }
  public MatchResourcesFluent.ExcludeResourceRulesNested<A> addNewExcludeResourceRuleLike(NamedRuleWithOperations item) {
    return new MatchResourcesFluentImpl.ExcludeResourceRulesNestedImpl(-1, item);
  }
  public MatchResourcesFluent.ExcludeResourceRulesNested<A> setNewExcludeResourceRuleLike(Integer index,NamedRuleWithOperations item) {
    return new MatchResourcesFluentImpl.ExcludeResourceRulesNestedImpl(index, item);
  }
  public MatchResourcesFluent.ExcludeResourceRulesNested<A> editExcludeResourceRule(Integer index) {
    if (excludeResourceRules.size() <= index) throw new RuntimeException("Can't edit excludeResourceRules. Index exceeds size.");
    return setNewExcludeResourceRuleLike(index, buildExcludeResourceRule(index));
  }
  public MatchResourcesFluent.ExcludeResourceRulesNested<A> editFirstExcludeResourceRule() {
    if (excludeResourceRules.size() == 0) throw new RuntimeException("Can't edit first excludeResourceRules. The list is empty.");
    return setNewExcludeResourceRuleLike(0, buildExcludeResourceRule(0));
  }
  public MatchResourcesFluent.ExcludeResourceRulesNested<A> editLastExcludeResourceRule() {
    int index = excludeResourceRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last excludeResourceRules. The list is empty.");
    return setNewExcludeResourceRuleLike(index, buildExcludeResourceRule(index));
  }
  public MatchResourcesFluent.ExcludeResourceRulesNested<A> editMatchingExcludeResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<excludeResourceRules.size();i++) { 
    if (predicate.test(excludeResourceRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching excludeResourceRules. No match found.");
    return setNewExcludeResourceRuleLike(index, buildExcludeResourceRule(index));
  }
  public String getMatchPolicy() {
    return this.matchPolicy;
  }
  public A withMatchPolicy(String matchPolicy) {
    this.matchPolicy=matchPolicy; return (A) this;
  }
  public Boolean hasMatchPolicy() {
    return this.matchPolicy != null;
  }
  
  /**
   * This method has been deprecated, please use method buildNamespaceSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public LabelSelector buildNamespaceSelector() {
    return this.namespaceSelector!=null ?this.namespaceSelector.build():null;
  }
  public A withNamespaceSelector(LabelSelector namespaceSelector) {
    _visitables.get("namespaceSelector").remove(this.namespaceSelector);
    if (namespaceSelector!=null){ this.namespaceSelector= new LabelSelectorBuilder(namespaceSelector); _visitables.get("namespaceSelector").add(this.namespaceSelector);} else { this.namespaceSelector = null; _visitables.get("namespaceSelector").remove(this.namespaceSelector); } return (A) this;
  }
  public Boolean hasNamespaceSelector() {
    return this.namespaceSelector != null;
  }
  public MatchResourcesFluent.NamespaceSelectorNested<A> withNewNamespaceSelector() {
    return new MatchResourcesFluentImpl.NamespaceSelectorNestedImpl();
  }
  public MatchResourcesFluent.NamespaceSelectorNested<A> withNewNamespaceSelectorLike(LabelSelector item) {
    return new MatchResourcesFluentImpl.NamespaceSelectorNestedImpl(item);
  }
  public MatchResourcesFluent.NamespaceSelectorNested<A> editNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector());
  }
  public MatchResourcesFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelector() {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): new LabelSelectorBuilder().build());
  }
  public MatchResourcesFluent.NamespaceSelectorNested<A> editOrNewNamespaceSelectorLike(LabelSelector item) {
    return withNewNamespaceSelectorLike(getNamespaceSelector() != null ? getNamespaceSelector(): item);
  }
  
  /**
   * This method has been deprecated, please use method buildObjectSelector instead.
   * @return The buildable object.
   */
  @Deprecated
  public LabelSelector getObjectSelector() {
    return this.objectSelector!=null ?this.objectSelector.build():null;
  }
  public LabelSelector buildObjectSelector() {
    return this.objectSelector!=null ?this.objectSelector.build():null;
  }
  public A withObjectSelector(LabelSelector objectSelector) {
    _visitables.get("objectSelector").remove(this.objectSelector);
    if (objectSelector!=null){ this.objectSelector= new LabelSelectorBuilder(objectSelector); _visitables.get("objectSelector").add(this.objectSelector);} else { this.objectSelector = null; _visitables.get("objectSelector").remove(this.objectSelector); } return (A) this;
  }
  public Boolean hasObjectSelector() {
    return this.objectSelector != null;
  }
  public MatchResourcesFluent.ObjectSelectorNested<A> withNewObjectSelector() {
    return new MatchResourcesFluentImpl.ObjectSelectorNestedImpl();
  }
  public MatchResourcesFluent.ObjectSelectorNested<A> withNewObjectSelectorLike(LabelSelector item) {
    return new MatchResourcesFluentImpl.ObjectSelectorNestedImpl(item);
  }
  public MatchResourcesFluent.ObjectSelectorNested<A> editObjectSelector() {
    return withNewObjectSelectorLike(getObjectSelector());
  }
  public MatchResourcesFluent.ObjectSelectorNested<A> editOrNewObjectSelector() {
    return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): new LabelSelectorBuilder().build());
  }
  public MatchResourcesFluent.ObjectSelectorNested<A> editOrNewObjectSelectorLike(LabelSelector item) {
    return withNewObjectSelectorLike(getObjectSelector() != null ? getObjectSelector(): item);
  }
  public A addToResourceRules(Integer index,NamedRuleWithOperations item) {
    if (this.resourceRules == null) {this.resourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("resourceRules").add(index >= 0 ? index : _visitables.get("resourceRules").size(), builder);this.resourceRules.add(index >= 0 ? index : resourceRules.size(), builder); return (A)this;
  }
  public A setToResourceRules(Integer index,NamedRuleWithOperations item) {
    if (this.resourceRules == null) {this.resourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);
    if (index < 0 || index >= _visitables.get("resourceRules").size()) { _visitables.get("resourceRules").add(builder); } else { _visitables.get("resourceRules").set(index, builder);}
    if (index < 0 || index >= resourceRules.size()) { resourceRules.add(builder); } else { resourceRules.set(index, builder);}
     return (A)this;
  }
  public A addToResourceRules(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.NamedRuleWithOperations... items) {
    if (this.resourceRules == null) {this.resourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("resourceRules").add(builder);this.resourceRules.add(builder);} return (A)this;
  }
  public A addAllToResourceRules(Collection<NamedRuleWithOperations> items) {
    if (this.resourceRules == null) {this.resourceRules = new ArrayList<NamedRuleWithOperationsBuilder>();}
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("resourceRules").add(builder);this.resourceRules.add(builder);} return (A)this;
  }
  public A removeFromResourceRules(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.NamedRuleWithOperations... items) {
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("resourceRules").remove(builder);if (this.resourceRules != null) {this.resourceRules.remove(builder);}} return (A)this;
  }
  public A removeAllFromResourceRules(Collection<NamedRuleWithOperations> items) {
    for (NamedRuleWithOperations item : items) {NamedRuleWithOperationsBuilder builder = new NamedRuleWithOperationsBuilder(item);_visitables.get("resourceRules").remove(builder);if (this.resourceRules != null) {this.resourceRules.remove(builder);}} return (A)this;
  }
  public A removeMatchingFromResourceRules(Predicate<NamedRuleWithOperationsBuilder> predicate) {
    if (resourceRules == null) return (A) this;
    final Iterator<NamedRuleWithOperationsBuilder> each = resourceRules.iterator();
    final List visitables = _visitables.get("resourceRules");
    while (each.hasNext()) {
      NamedRuleWithOperationsBuilder builder = each.next();
      if (predicate.test(builder)) {
        visitables.remove(builder);
        each.remove();
      }
    }
    return (A)this;
  }
  
  /**
   * This method has been deprecated, please use method buildResourceRules instead.
   * @return The buildable object.
   */
  @Deprecated
  public List<NamedRuleWithOperations> getResourceRules() {
    return resourceRules != null ? build(resourceRules) : null;
  }
  public List<NamedRuleWithOperations> buildResourceRules() {
    return resourceRules != null ? build(resourceRules) : null;
  }
  public NamedRuleWithOperations buildResourceRule(Integer index) {
    return this.resourceRules.get(index).build();
  }
  public NamedRuleWithOperations buildFirstResourceRule() {
    return this.resourceRules.get(0).build();
  }
  public NamedRuleWithOperations buildLastResourceRule() {
    return this.resourceRules.get(resourceRules.size() - 1).build();
  }
  public NamedRuleWithOperations buildMatchingResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
    for (NamedRuleWithOperationsBuilder item: resourceRules) { if(predicate.test(item)){ return item.build();} } return null;
  }
  public Boolean hasMatchingResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
    for (NamedRuleWithOperationsBuilder item: resourceRules) { if(predicate.test(item)){ return true;} } return false;
  }
  public A withResourceRules(List<NamedRuleWithOperations> resourceRules) {
    if (this.resourceRules != null) { _visitables.get("resourceRules").removeAll(this.resourceRules);}
    if (resourceRules != null) {this.resourceRules = new ArrayList(); for (NamedRuleWithOperations item : resourceRules){this.addToResourceRules(item);}} else { this.resourceRules = null;} return (A) this;
  }
  public A withResourceRules(io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1.NamedRuleWithOperations... resourceRules) {
    if (this.resourceRules != null) {this.resourceRules.clear();}
    if (resourceRules != null) {for (NamedRuleWithOperations item :resourceRules){ this.addToResourceRules(item);}} return (A) this;
  }
  public Boolean hasResourceRules() {
    return resourceRules != null && !resourceRules.isEmpty();
  }
  public MatchResourcesFluent.ResourceRulesNested<A> addNewResourceRule() {
    return new MatchResourcesFluentImpl.ResourceRulesNestedImpl();
  }
  public MatchResourcesFluent.ResourceRulesNested<A> addNewResourceRuleLike(NamedRuleWithOperations item) {
    return new MatchResourcesFluentImpl.ResourceRulesNestedImpl(-1, item);
  }
  public MatchResourcesFluent.ResourceRulesNested<A> setNewResourceRuleLike(Integer index,NamedRuleWithOperations item) {
    return new MatchResourcesFluentImpl.ResourceRulesNestedImpl(index, item);
  }
  public MatchResourcesFluent.ResourceRulesNested<A> editResourceRule(Integer index) {
    if (resourceRules.size() <= index) throw new RuntimeException("Can't edit resourceRules. Index exceeds size.");
    return setNewResourceRuleLike(index, buildResourceRule(index));
  }
  public MatchResourcesFluent.ResourceRulesNested<A> editFirstResourceRule() {
    if (resourceRules.size() == 0) throw new RuntimeException("Can't edit first resourceRules. The list is empty.");
    return setNewResourceRuleLike(0, buildResourceRule(0));
  }
  public MatchResourcesFluent.ResourceRulesNested<A> editLastResourceRule() {
    int index = resourceRules.size() - 1;
    if (index < 0) throw new RuntimeException("Can't edit last resourceRules. The list is empty.");
    return setNewResourceRuleLike(index, buildResourceRule(index));
  }
  public MatchResourcesFluent.ResourceRulesNested<A> editMatchingResourceRule(Predicate<NamedRuleWithOperationsBuilder> predicate) {
    int index = -1;
    for (int i=0;i<resourceRules.size();i++) { 
    if (predicate.test(resourceRules.get(i))) {index = i; break;}
    } 
    if (index < 0) throw new RuntimeException("Can't edit matching resourceRules. No match found.");
    return setNewResourceRuleLike(index, buildResourceRule(index));
  }
  public A addToAdditionalProperties(String key,Object value) {
    if(this.additionalProperties == null && key != null && value != null) { this.additionalProperties = new LinkedHashMap(); }
    if(key != null && value != null) {this.additionalProperties.put(key, value);} return (A)this;
  }
  public A addToAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null && map != null) { this.additionalProperties = new LinkedHashMap(); }
    if(map != null) { this.additionalProperties.putAll(map);} return (A)this;
  }
  public A removeFromAdditionalProperties(String key) {
    if(this.additionalProperties == null) { return (A) this; }
    if(key != null && this.additionalProperties != null) {this.additionalProperties.remove(key);} return (A)this;
  }
  public A removeFromAdditionalProperties(Map<String,Object> map) {
    if(this.additionalProperties == null) { return (A) this; }
    if(map != null) { for(Object key : map.keySet()) {if (this.additionalProperties != null){this.additionalProperties.remove(key);}}} return (A)this;
  }
  public Map<String,Object> getAdditionalProperties() {
    return this.additionalProperties;
  }
  public <K,V>A withAdditionalProperties(Map<String,Object> additionalProperties) {
    if (additionalProperties == null) { this.additionalProperties =  null;} else {this.additionalProperties = new LinkedHashMap(additionalProperties);} return (A) this;
  }
  public Boolean hasAdditionalProperties() {
    return this.additionalProperties != null;
  }
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;
    MatchResourcesFluentImpl that = (MatchResourcesFluentImpl) o;
    if (excludeResourceRules != null ? !excludeResourceRules.equals(that.excludeResourceRules) :that.excludeResourceRules != null) return false;
    if (matchPolicy != null ? !matchPolicy.equals(that.matchPolicy) :that.matchPolicy != null) return false;
    if (namespaceSelector != null ? !namespaceSelector.equals(that.namespaceSelector) :that.namespaceSelector != null) return false;
    if (objectSelector != null ? !objectSelector.equals(that.objectSelector) :that.objectSelector != null) return false;
    if (resourceRules != null ? !resourceRules.equals(that.resourceRules) :that.resourceRules != null) return false;
    if (additionalProperties != null ? !additionalProperties.equals(that.additionalProperties) :that.additionalProperties != null) return false;
    return true;
  }
  public int hashCode() {
    return java.util.Objects.hash(excludeResourceRules,  matchPolicy,  namespaceSelector,  objectSelector,  resourceRules,  additionalProperties,  super.hashCode());
  }
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("{");
    if (excludeResourceRules != null && !excludeResourceRules.isEmpty()) { sb.append("excludeResourceRules:"); sb.append(excludeResourceRules + ","); }
    if (matchPolicy != null) { sb.append("matchPolicy:"); sb.append(matchPolicy + ","); }
    if (namespaceSelector != null) { sb.append("namespaceSelector:"); sb.append(namespaceSelector + ","); }
    if (objectSelector != null) { sb.append("objectSelector:"); sb.append(objectSelector + ","); }
    if (resourceRules != null && !resourceRules.isEmpty()) { sb.append("resourceRules:"); sb.append(resourceRules + ","); }
    if (additionalProperties != null && !additionalProperties.isEmpty()) { sb.append("additionalProperties:"); sb.append(additionalProperties); }
    sb.append("}");
    return sb.toString();
  }
  class ExcludeResourceRulesNestedImpl<N> extends NamedRuleWithOperationsFluentImpl<MatchResourcesFluent.ExcludeResourceRulesNested<N>> implements MatchResourcesFluent.ExcludeResourceRulesNested<N>,Nested<N>{
    ExcludeResourceRulesNestedImpl(Integer index,NamedRuleWithOperations item) {
      this.index = index;
      this.builder = new NamedRuleWithOperationsBuilder(this, item);
    }
    ExcludeResourceRulesNestedImpl() {
      this.index = -1;
      this.builder = new NamedRuleWithOperationsBuilder(this);
    }
    NamedRuleWithOperationsBuilder builder;
    Integer index;
    public N and() {
      return (N) MatchResourcesFluentImpl.this.setToExcludeResourceRules(index,builder.build());
    }
    public N endExcludeResourceRule() {
      return and();
    }
    
  }
  class NamespaceSelectorNestedImpl<N> extends LabelSelectorFluentImpl<MatchResourcesFluent.NamespaceSelectorNested<N>> implements MatchResourcesFluent.NamespaceSelectorNested<N>,Nested<N>{
    NamespaceSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    NamespaceSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) MatchResourcesFluentImpl.this.withNamespaceSelector(builder.build());
    }
    public N endNamespaceSelector() {
      return and();
    }
    
  }
  class ObjectSelectorNestedImpl<N> extends LabelSelectorFluentImpl<MatchResourcesFluent.ObjectSelectorNested<N>> implements MatchResourcesFluent.ObjectSelectorNested<N>,Nested<N>{
    ObjectSelectorNestedImpl(LabelSelector item) {
      this.builder = new LabelSelectorBuilder(this, item);
    }
    ObjectSelectorNestedImpl() {
      this.builder = new LabelSelectorBuilder(this);
    }
    LabelSelectorBuilder builder;
    public N and() {
      return (N) MatchResourcesFluentImpl.this.withObjectSelector(builder.build());
    }
    public N endObjectSelector() {
      return and();
    }
    
  }
  class ResourceRulesNestedImpl<N> extends NamedRuleWithOperationsFluentImpl<MatchResourcesFluent.ResourceRulesNested<N>> implements MatchResourcesFluent.ResourceRulesNested<N>,Nested<N>{
    ResourceRulesNestedImpl(Integer index,NamedRuleWithOperations item) {
      this.index = index;
      this.builder = new NamedRuleWithOperationsBuilder(this, item);
    }
    ResourceRulesNestedImpl() {
      this.index = -1;
      this.builder = new NamedRuleWithOperationsBuilder(this);
    }
    NamedRuleWithOperationsBuilder builder;
    Integer index;
    public N and() {
      return (N) MatchResourcesFluentImpl.this.setToResourceRules(index,builder.build());
    }
    public N endResourceRule() {
      return and();
    }
    
  }
  
}