package io.fabric8.kubernetes.api.model.admissionregistration.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class RuleBuilder extends RuleFluentImpl<RuleBuilder> implements VisitableBuilder<Rule,RuleBuilder>{
  public RuleBuilder() {
    this(false);
  }
  public RuleBuilder(Boolean validationEnabled) {
    this(new Rule(), validationEnabled);
  }
  public RuleBuilder(RuleFluent<?> fluent) {
    this(fluent, false);
  }
  public RuleBuilder(RuleFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new Rule(), validationEnabled);
  }
  public RuleBuilder(RuleFluent<?> fluent,Rule instance) {
    this(fluent, instance, false);
  }
  public RuleBuilder(RuleFluent<?> fluent,Rule instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiGroups(instance.getApiGroups()); 
    fluent.withApiVersions(instance.getApiVersions()); 
    fluent.withResources(instance.getResources()); 
    fluent.withScope(instance.getScope()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public RuleBuilder(Rule instance) {
    this(instance,false);
  }
  public RuleBuilder(Rule instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiGroups(instance.getApiGroups()); 
    this.withApiVersions(instance.getApiVersions()); 
    this.withResources(instance.getResources()); 
    this.withScope(instance.getScope()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  RuleFluent<?> fluent;
  Boolean validationEnabled;
  public Rule build() {
    Rule buildable = new Rule(fluent.getApiGroups(),fluent.getApiVersions(),fluent.getResources(),fluent.getScope());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}