package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class UserInfoBuilder extends UserInfoFluentImpl<UserInfoBuilder> implements VisitableBuilder<UserInfo,UserInfoBuilder>{
  public UserInfoBuilder() {
    this(false);
  }
  public UserInfoBuilder(Boolean validationEnabled) {
    this(new UserInfo(), validationEnabled);
  }
  public UserInfoBuilder(UserInfoFluent<?> fluent) {
    this(fluent, false);
  }
  public UserInfoBuilder(UserInfoFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new UserInfo(), validationEnabled);
  }
  public UserInfoBuilder(UserInfoFluent<?> fluent,UserInfo instance) {
    this(fluent, instance, false);
  }
  public UserInfoBuilder(UserInfoFluent<?> fluent,UserInfo instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withExtra(instance.getExtra()); 
    fluent.withGroups(instance.getGroups()); 
    fluent.withUid(instance.getUid()); 
    fluent.withUsername(instance.getUsername()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public UserInfoBuilder(UserInfo instance) {
    this(instance,false);
  }
  public UserInfoBuilder(UserInfo instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withExtra(instance.getExtra()); 
    this.withGroups(instance.getGroups()); 
    this.withUid(instance.getUid()); 
    this.withUsername(instance.getUsername()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  UserInfoFluent<?> fluent;
  Boolean validationEnabled;
  public UserInfo build() {
    UserInfo buildable = new UserInfo(fluent.getExtra(),fluent.getGroups(),fluent.getUid(),fluent.getUsername());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}