package io.fabric8.kubernetes.api.model.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Boolean;
public class SelfSubjectAccessReviewBuilder extends SelfSubjectAccessReviewFluentImpl<SelfSubjectAccessReviewBuilder> implements VisitableBuilder<SelfSubjectAccessReview,SelfSubjectAccessReviewBuilder>{
  public SelfSubjectAccessReviewBuilder() {
    this(false);
  }
  public SelfSubjectAccessReviewBuilder(Boolean validationEnabled) {
    this(new SelfSubjectAccessReview(), validationEnabled);
  }
  public SelfSubjectAccessReviewBuilder(SelfSubjectAccessReviewFluent<?> fluent) {
    this(fluent, false);
  }
  public SelfSubjectAccessReviewBuilder(SelfSubjectAccessReviewFluent<?> fluent,Boolean validationEnabled) {
    this(fluent, new SelfSubjectAccessReview(), validationEnabled);
  }
  public SelfSubjectAccessReviewBuilder(SelfSubjectAccessReviewFluent<?> fluent,SelfSubjectAccessReview instance) {
    this(fluent, instance, false);
  }
  public SelfSubjectAccessReviewBuilder(SelfSubjectAccessReviewFluent<?> fluent,SelfSubjectAccessReview instance,Boolean validationEnabled) {
    this.fluent = fluent; 
    fluent.withApiVersion(instance.getApiVersion()); 
    fluent.withKind(instance.getKind()); 
    fluent.withMetadata(instance.getMetadata()); 
    fluent.withSpec(instance.getSpec()); 
    fluent.withStatus(instance.getStatus()); 
    fluent.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  public SelfSubjectAccessReviewBuilder(SelfSubjectAccessReview instance) {
    this(instance,false);
  }
  public SelfSubjectAccessReviewBuilder(SelfSubjectAccessReview instance,Boolean validationEnabled) {
    this.fluent = this; 
    this.withApiVersion(instance.getApiVersion()); 
    this.withKind(instance.getKind()); 
    this.withMetadata(instance.getMetadata()); 
    this.withSpec(instance.getSpec()); 
    this.withStatus(instance.getStatus()); 
    this.withAdditionalProperties(instance.getAdditionalProperties());

    this.validationEnabled = validationEnabled; 
  }
  SelfSubjectAccessReviewFluent<?> fluent;
  Boolean validationEnabled;
  public SelfSubjectAccessReview build() {
    SelfSubjectAccessReview buildable = new SelfSubjectAccessReview(fluent.getApiVersion(),fluent.getKind(),fluent.getMetadata(),fluent.getSpec(),fluent.getStatus());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  
}