package io.fabric8.kubernetes.api.model.admissionregistration.v1alpha1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
public class ValidationBuilder extends ValidationFluent<ValidationBuilder> implements VisitableBuilder<Validation,ValidationBuilder>{
  public ValidationBuilder() {
    this(new Validation());
  }
  
  public ValidationBuilder(ValidationFluent<?> fluent) {
    this(fluent, new Validation());
  }
  
  public ValidationBuilder(ValidationFluent<?> fluent,Validation instance) {
    this.fluent = fluent;
    fluent.copyInstance(instance);
  }
  
  public ValidationBuilder(Validation instance) {
    this.fluent = this;
    this.copyInstance(instance);
  }
  ValidationFluent<?> fluent;
  
  public Validation build() {
    Validation buildable = new Validation(fluent.getExpression(),fluent.getMessage(),fluent.getMessageExpression(),fluent.getReason());
    buildable.setAdditionalProperties(fluent.getAdditionalProperties());
    return buildable;
  }
  

}