package io.fabric8.kubernetes.api.model.authorization.v1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class ResourceRuleBuilder extends io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleFluentImpl<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule,io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleBuilder> {

    io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public ResourceRuleBuilder() {
        this(true);
    }

    public ResourceRuleBuilder(java.lang.Boolean validationEnabled) {
        this(new ResourceRule(), validationEnabled);
    }

    public ResourceRuleBuilder(io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleFluent<?> fluent) {
        this(fluent, true);
    }

    public ResourceRuleBuilder(io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new ResourceRule(), validationEnabled);
    }

    public ResourceRuleBuilder(io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule instance) {
        this(fluent, instance, true);
    }

    public ResourceRuleBuilder(io.fabric8.kubernetes.api.model.authorization.v1.ResourceRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withApiGroups(instance.getApiGroups()); 
        fluent.withResourceNames(instance.getResourceNames()); 
        fluent.withResources(instance.getResources()); 
        fluent.withVerbs(instance.getVerbs()); 
        this.validationEnabled = validationEnabled; 
    }

    public ResourceRuleBuilder(io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule instance) {
        this(instance,true);
    }

    public ResourceRuleBuilder(io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withApiGroups(instance.getApiGroups()); 
        this.withResourceNames(instance.getResourceNames()); 
        this.withResources(instance.getResources()); 
        this.withVerbs(instance.getVerbs()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.authorization.v1.ResourceRule build() {
        ResourceRule buildable = new ResourceRule(fluent.getApiGroups(),fluent.getResourceNames(),fluent.getResources(),fluent.getVerbs());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        ResourceRuleBuilder that = (ResourceRuleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
