package io.fabric8.kubernetes.api.model.authorization.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class NonResourceRuleBuilder extends io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleFluentImpl<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule,io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleBuilder> {

    io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public NonResourceRuleBuilder() {
        this(true);
    }

    public NonResourceRuleBuilder(java.lang.Boolean validationEnabled) {
        this(new NonResourceRule(), validationEnabled);
    }

    public NonResourceRuleBuilder(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleFluent<?> fluent) {
        this(fluent, true);
    }

    public NonResourceRuleBuilder(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new NonResourceRule(), validationEnabled);
    }

    public NonResourceRuleBuilder(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule instance) {
        this(fluent, instance, true);
    }

    public NonResourceRuleBuilder(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRuleFluent<?> fluent,io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withNonResourceURLs(instance.getNonResourceURLs()); 
        fluent.withVerbs(instance.getVerbs()); 
        this.validationEnabled = validationEnabled; 
    }

    public NonResourceRuleBuilder(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule instance) {
        this(instance,true);
    }

    public NonResourceRuleBuilder(io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withNonResourceURLs(instance.getNonResourceURLs()); 
        this.withVerbs(instance.getVerbs()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.authorization.v1beta1.NonResourceRule build() {
        NonResourceRule buildable = new NonResourceRule(fluent.getNonResourceURLs(),fluent.getVerbs());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        NonResourceRuleBuilder that = (NonResourceRuleBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
