package io.fabric8.kubernetes.api.model.authentication;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class TokenReviewSpecBuilder extends io.fabric8.kubernetes.api.model.authentication.TokenReviewSpecFluentImpl<io.fabric8.kubernetes.api.model.authentication.TokenReviewSpecBuilder> implements io.fabric8.kubernetes.api.builder.VisitableBuilder<io.fabric8.kubernetes.api.model.authentication.TokenReviewSpec,io.fabric8.kubernetes.api.model.authentication.TokenReviewSpecBuilder> {

    io.fabric8.kubernetes.api.model.authentication.TokenReviewSpecFluent<?> fluent;
    java.lang.Boolean validationEnabled;

    public TokenReviewSpecBuilder() {
        this(true);
    }

    public TokenReviewSpecBuilder(java.lang.Boolean validationEnabled) {
        this(new TokenReviewSpec(), validationEnabled);
    }

    public TokenReviewSpecBuilder(io.fabric8.kubernetes.api.model.authentication.TokenReviewSpecFluent<?> fluent) {
        this(fluent, true);
    }

    public TokenReviewSpecBuilder(io.fabric8.kubernetes.api.model.authentication.TokenReviewSpecFluent<?> fluent,java.lang.Boolean validationEnabled) {
        this(fluent, new TokenReviewSpec(), validationEnabled);
    }

    public TokenReviewSpecBuilder(io.fabric8.kubernetes.api.model.authentication.TokenReviewSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.authentication.TokenReviewSpec instance) {
        this(fluent, instance, true);
    }

    public TokenReviewSpecBuilder(io.fabric8.kubernetes.api.model.authentication.TokenReviewSpecFluent<?> fluent,io.fabric8.kubernetes.api.model.authentication.TokenReviewSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = fluent; 
        fluent.withAudiences(instance.getAudiences()); 
        fluent.withToken(instance.getToken()); 
        this.validationEnabled = validationEnabled; 
    }

    public TokenReviewSpecBuilder(io.fabric8.kubernetes.api.model.authentication.TokenReviewSpec instance) {
        this(instance,true);
    }

    public TokenReviewSpecBuilder(io.fabric8.kubernetes.api.model.authentication.TokenReviewSpec instance,java.lang.Boolean validationEnabled) {
        this.fluent = this; 
        this.withAudiences(instance.getAudiences()); 
        this.withToken(instance.getToken()); 
        this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.authentication.TokenReviewSpec build() {
        TokenReviewSpec buildable = new TokenReviewSpec(fluent.getAudiences(),fluent.getToken());
        return buildable;
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        if (!super.equals(o)) return false;
        TokenReviewSpecBuilder that = (TokenReviewSpecBuilder) o;
        if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;
        
        if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(fluent,  validationEnabled,  super.hashCode());
    }

}
