package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.builder.Nested;
import java.util.ArrayList;
import java.lang.String;
import java.util.function.Predicate;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.BaseFluent;
import java.util.Iterator;
import java.util.List;
import java.lang.Boolean;
import io.fabric8.kubernetes.api.model.ObjectMeta;
import io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl;
import io.fabric8.kubernetes.api.model.ObjectMetaBuilder;
import java.util.Collection;
import java.lang.Object;

public class ValidatingWebhookConfigurationFluentImpl<A extends io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent<A>> extends io.fabric8.kubernetes.api.builder.BaseFluent<A> implements io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent<A> {

    private java.lang.String apiVersion;
    private java.lang.String kind;
    private io.fabric8.kubernetes.api.model.ObjectMetaBuilder metadata;
    private java.util.List<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder> webhooks =  new java.util.ArrayList<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder>();

    public ValidatingWebhookConfigurationFluentImpl() {
    }

    public ValidatingWebhookConfigurationFluentImpl(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfiguration instance) {
        this.withApiVersion(instance.getApiVersion()); 
        this.withKind(instance.getKind()); 
        this.withMetadata(instance.getMetadata()); 
        this.withWebhooks(instance.getWebhooks()); 
    }

    public java.lang.String getApiVersion() {
        return this.apiVersion;
    }

    public A withApiVersion(java.lang.String apiVersion) {
        this.apiVersion=apiVersion; return (A) this;
    }

    public java.lang.Boolean hasApiVersion() {
        return this.apiVersion != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0) {
        return (A)withApiVersion(new String(arg0));
    }

    public java.lang.String getKind() {
        return this.kind;
    }

    public A withKind(java.lang.String kind) {
        this.kind=kind; return (A) this;
    }

    public java.lang.Boolean hasKind() {
        return this.kind != null;
    }

    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0) {
        return (A)withKind(new String(arg0));
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildMetadata instead.
     * @return The buildable object.
     */
        public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public io.fabric8.kubernetes.api.model.ObjectMeta buildMetadata() {
        return this.metadata!=null?this.metadata.build():null;
    }

    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata) {
        _visitables.get("metadata").remove(this.metadata);
        if (metadata!=null){ this.metadata= new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(metadata); _visitables.get("metadata").add(this.metadata);} return (A) this;
    }

    public java.lang.Boolean hasMetadata() {
        return this.metadata != null;
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadata() {
        return new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluentImpl.MetadataNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.MetadataNested<A> withNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluentImpl.MetadataNestedImpl(item);
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.MetadataNested<A> editMetadata() {
        return withNewMetadataLike(getMetadata());
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadata() {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): new io.fabric8.kubernetes.api.model.ObjectMetaBuilder().build());
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.MetadataNested<A> editOrNewMetadataLike(io.fabric8.kubernetes.api.model.ObjectMeta item) {
        return withNewMetadataLike(getMetadata() != null ? getMetadata(): item);
    }

    public A addToWebhooks(int index,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook item) {
        if (this.webhooks == null) {this.webhooks = new java.util.ArrayList<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder>();}
        io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder builder = new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder(item);_visitables.get("webhooks").add(index >= 0 ? index : _visitables.get("webhooks").size(), builder);this.webhooks.add(index >= 0 ? index : webhooks.size(), builder); return (A)this;
    }

    public A setToWebhooks(int index,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook item) {
        if (this.webhooks == null) {this.webhooks = new java.util.ArrayList<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder>();}
        io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder builder = new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder(item);
        if (index < 0 || index >= _visitables.get("webhooks").size()) { _visitables.get("webhooks").add(builder); } else { _visitables.get("webhooks").set(index, builder);}
        if (index < 0 || index >= webhooks.size()) { webhooks.add(builder); } else { webhooks.set(index, builder);}
         return (A)this;
    }

    public A addToWebhooks(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook... items) {
        if (this.webhooks == null) {this.webhooks = new java.util.ArrayList<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder>();}
        for (io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook item : items) {io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder builder = new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder(item);_visitables.get("webhooks").add(builder);this.webhooks.add(builder);} return (A)this;
    }

    public A addAllToWebhooks(java.util.Collection<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook> items) {
        if (this.webhooks == null) {this.webhooks = new java.util.ArrayList<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder>();}
        for (io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook item : items) {io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder builder = new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder(item);_visitables.get("webhooks").add(builder);this.webhooks.add(builder);} return (A)this;
    }

    public A removeFromWebhooks(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook... items) {
        for (io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook item : items) {io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder builder = new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder(item);_visitables.get("webhooks").remove(builder);if (this.webhooks != null) {this.webhooks.remove(builder);}} return (A)this;
    }

    public A removeAllFromWebhooks(java.util.Collection<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook> items) {
        for (io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook item : items) {io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder builder = new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder(item);_visitables.get("webhooks").remove(builder);if (this.webhooks != null) {this.webhooks.remove(builder);}} return (A)this;
    }

    public A removeMatchingFromWebhooks(java.util.function.Predicate<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder> predicate) {
        if (webhooks == null) return (A) this;
        final Iterator<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder> each = webhooks.iterator();
        final List visitables = _visitables.get("webhooks");
        while (each.hasNext()) {
          io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder builder = each.next();
          if (predicate.test(builder)) {
            visitables.remove(builder);
            each.remove();
          }
        }
        return (A)this;
    }

    
    @java.lang.Deprecated
        
    /**
     * This method has been deprecated, please use method buildWebhooks instead.
     * @return The buildable object.
     */
        public java.util.List<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook> getWebhooks() {
        return build(webhooks);
    }

    public java.util.List<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook> buildWebhooks() {
        return build(webhooks);
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook buildWebhook(int index) {
        return this.webhooks.get(index).build();
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook buildFirstWebhook() {
        return this.webhooks.get(0).build();
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook buildLastWebhook() {
        return this.webhooks.get(webhooks.size() - 1).build();
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook buildMatchingWebhook(java.util.function.Predicate<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder item: webhooks) { if(predicate.test(item)){ return item.build();} } return null;
    }

    public java.lang.Boolean hasMatchingWebhook(java.util.function.Predicate<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder> predicate) {
        for (io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder item: webhooks) { if(predicate.test(item)){ return true;} } return false;
    }

    public A withWebhooks(java.util.List<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook> webhooks) {
        if (this.webhooks != null) { _visitables.get("webhooks").removeAll(this.webhooks);}
        if (webhooks != null) {this.webhooks = new java.util.ArrayList<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder>(); for (io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook item : webhooks){this.addToWebhooks(item);}} else { this.webhooks = null;} return (A) this;
    }

    public A withWebhooks(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook... webhooks) {
        if (this.webhooks != null) {this.webhooks.clear();}
        if (webhooks != null) {for (io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook item :webhooks){ this.addToWebhooks(item);}} return (A) this;
    }

    public java.lang.Boolean hasWebhooks() {
        return webhooks != null && !webhooks.isEmpty();
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhook() {
        return new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluentImpl.WebhooksNestedImpl();
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.WebhooksNested<A> addNewWebhookLike(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook item) {
        return new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluentImpl.WebhooksNestedImpl(-1, item);
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.WebhooksNested<A> setNewWebhookLike(int index,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook item) {
        return new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluentImpl.WebhooksNestedImpl(index, item);
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.WebhooksNested<A> editWebhook(int index) {
        if (webhooks.size() <= index) throw new RuntimeException("Can't edit webhooks. Index exceeds size.");
        return setNewWebhookLike(index, buildWebhook(index));
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.WebhooksNested<A> editFirstWebhook() {
        if (webhooks.size() == 0) throw new RuntimeException("Can't edit first webhooks. The list is empty.");
        return setNewWebhookLike(0, buildWebhook(0));
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.WebhooksNested<A> editLastWebhook() {
        int index = webhooks.size() - 1;
        if (index < 0) throw new RuntimeException("Can't edit last webhooks. The list is empty.");
        return setNewWebhookLike(index, buildWebhook(index));
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.WebhooksNested<A> editMatchingWebhook(java.util.function.Predicate<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder> predicate) {
        int index = -1;
        for (int i=0;i<webhooks.size();i++) { 
        if (predicate.test(webhooks.get(i))) {index = i; break;}
        } 
        if (index < 0) throw new RuntimeException("Can't edit matching webhooks. No match found.");
        return setNewWebhookLike(index, buildWebhook(index));
    }

    public boolean equals(java.lang.Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ValidatingWebhookConfigurationFluentImpl that = (ValidatingWebhookConfigurationFluentImpl) o;
        if (apiVersion != null ? !apiVersion.equals(that.apiVersion) :that.apiVersion != null) return false;
        if (kind != null ? !kind.equals(that.kind) :that.kind != null) return false;
        if (metadata != null ? !metadata.equals(that.metadata) :that.metadata != null) return false;
        if (webhooks != null ? !webhooks.equals(that.webhooks) :that.webhooks != null) return false;
        return true;
    }

    public int hashCode() {
        return java.util.Objects.hash(apiVersion,  kind,  metadata,  webhooks,  super.hashCode());
    }

    public class MetadataNestedImpl<N> extends io.fabric8.kubernetes.api.model.ObjectMetaFluentImpl<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.MetadataNested<N>> implements io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.MetadataNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.ObjectMetaBuilder builder;

            MetadataNestedImpl(io.fabric8.kubernetes.api.model.ObjectMeta item) {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this, item);
                        
            }

            MetadataNestedImpl() {
                this.builder = new io.fabric8.kubernetes.api.model.ObjectMetaBuilder(this);
                        
            }

            public N and() {
                return (N) ValidatingWebhookConfigurationFluentImpl.this.withMetadata(builder.build());
            }

            public N endMetadata() {
                return and();
            }
    }


    public class WebhooksNestedImpl<N> extends io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookFluentImpl<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.WebhooksNested<N>> implements io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationFluent.WebhooksNested<N>,io.fabric8.kubernetes.api.builder.Nested<N> {
        private final io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder builder;
        private final int index;

            WebhooksNestedImpl(int index,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhook item) {
                this.index = index;
                this.builder = new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder(this, item);
                        
            }

            WebhooksNestedImpl() {
                this.index = -1;
                this.builder = new io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookBuilder(this);
                        
            }

            public N and() {
                return (N) ValidatingWebhookConfigurationFluentImpl.this.setToWebhooks(index,builder.build());
            }

            public N endWebhook() {
                return and();
            }
    }


}
