package io.fabric8.kubernetes.api.model.admission;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.StringBuilder;
import io.fabric8.kubernetes.api.builder.Fluent;
import io.fabric8.kubernetes.api.builder.Nested;
import java.lang.String;
import java.lang.StringBuffer;
import java.lang.Deprecated;
import java.lang.Object;
import java.lang.Boolean;
import java.util.Map;

public interface AdmissionReviewFluent<A extends AdmissionReviewFluent<A>> extends Fluent<A> {


    public String getApiVersion();
    public A withApiVersion(String apiVersion);
    public Boolean hasApiVersion();
    public A withNewApiVersion(String arg1);
    public A withNewApiVersion(StringBuilder arg1);
    public A withNewApiVersion(StringBuffer arg1);
    public String getKind();
    public A withKind(String kind);
    public Boolean hasKind();
    public A withNewKind(String arg1);
    public A withNewKind(StringBuilder arg1);
    public A withNewKind(StringBuffer arg1);
    public AdmissionRequest getRequest();
    public A withRequest(AdmissionRequest request);
    public Boolean hasRequest();
    
/**
 * This method has been deprecated, please use method buildResponse instead.
 * @return The buildable object.
 */
@Deprecated public AdmissionResponse getResponse();
    public AdmissionResponse buildResponse();
    public A withResponse(AdmissionResponse response);
    public Boolean hasResponse();
    public AdmissionReviewFluent.ResponseNested<A> withNewResponse();
    public AdmissionReviewFluent.ResponseNested<A> withNewResponseLike(AdmissionResponse item);
    public AdmissionReviewFluent.ResponseNested<A> editResponse();
    public AdmissionReviewFluent.ResponseNested<A> editOrNewResponse();
    public AdmissionReviewFluent.ResponseNested<A> editOrNewResponseLike(AdmissionResponse item);
    public interface ResponseNested<N> extends io.fabric8.kubernetes.api.builder.Nested<N>,AdmissionResponseFluent<AdmissionReviewFluent.ResponseNested<N>> {

        public N and();
        public N endResponse();    }


}
