package io.fabric8.kubernetes.api.model.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import java.lang.Object;
import java.lang.Boolean;

public class RuleBuilder extends io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleFluentImpl<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleBuilder> implements VisitableBuilder<io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.Rule,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleBuilder>{

    io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleFluent<?> fluent;
    Boolean validationEnabled;

    public RuleBuilder(){
            this(true);
    }
    public RuleBuilder(Boolean validationEnabled){
            this(new Rule(), validationEnabled);
    }
    public RuleBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleFluent<?> fluent){
            this(fluent, true);
    }
    public RuleBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleFluent<?> fluent,Boolean validationEnabled){
            this(fluent, new Rule(), validationEnabled);
    }
    public RuleBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.Rule instance){
            this(fluent, instance, true);
    }
    public RuleBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.RuleFluent<?> fluent,io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.Rule instance,Boolean validationEnabled){
            this.fluent = fluent; 
            fluent.withApiGroups(instance.getApiGroups()); 
            fluent.withApiVersions(instance.getApiVersions()); 
            fluent.withResources(instance.getResources()); 
            fluent.withScope(instance.getScope()); 
            this.validationEnabled = validationEnabled; 
    }
    public RuleBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.Rule instance){
            this(instance,true);
    }
    public RuleBuilder(io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.Rule instance,Boolean validationEnabled){
            this.fluent = this; 
            this.withApiGroups(instance.getApiGroups()); 
            this.withApiVersions(instance.getApiVersions()); 
            this.withResources(instance.getResources()); 
            this.withScope(instance.getScope()); 
            this.validationEnabled = validationEnabled; 
    }

    public io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.Rule build(){
            Rule buildable = new Rule(fluent.getApiGroups(),fluent.getApiVersions(),fluent.getResources(),fluent.getScope());
            return buildable;
    }

    public boolean equals(Object o){
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;
            if (!super.equals(o)) return false;
            RuleBuilder that = (RuleBuilder) o;
            if (fluent != null &&fluent != this ? !fluent.equals(that.fluent) :that.fluent != null &&fluent != this ) return false;

            if (validationEnabled != null ? !validationEnabled.equals(that.validationEnabled) :that.validationEnabled != null) return false;
            return true;
    }




}
