/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.KubernetesResource;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.Status;
import io.fabric8.kubernetes.api.model.WatchEvent;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.WatcherException;
import io.fabric8.kubernetes.client.dsl.internal.BaseOperation;
import io.fabric8.kubernetes.client.http.HttpClient;
import io.fabric8.kubernetes.client.utils.ExponentialBackoffIntervalCalculator;
import io.fabric8.kubernetes.client.utils.Serialization;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.client.utils.internal.SerialExecutor;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executor;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractWatchManager<T extends HasMetadata>
implements Watch {
    private static final Logger logger = LoggerFactory.getLogger(AbstractWatchManager.class);
    final Watcher<T> watcher;
    final AtomicReference<String> resourceVersion;
    final AtomicBoolean forceClosed;
    private final int reconnectLimit;
    private final ExponentialBackoffIntervalCalculator retryIntervalCalculator;
    private Future<?> reconnectAttempt;
    protected final HttpClient client;
    protected BaseOperation<T, ?, ?> baseOperation;
    private final ListOptions listOptions;
    private final URL requestUrl;
    private final boolean receiveBookmarks;
    private volatile WatchRequestState latestRequestState;

    AbstractWatchManager(Watcher<T> watcher, BaseOperation<T, ?, ?> baseOperation, ListOptions listOptions, int reconnectLimit, int reconnectInterval, Supplier<HttpClient> clientSupplier) throws MalformedURLException {
        this.watcher = new SerialWatcher(watcher, new SerialExecutor(baseOperation.getOperationContext().getExecutor()));
        this.reconnectLimit = reconnectLimit;
        this.retryIntervalCalculator = new ExponentialBackoffIntervalCalculator(reconnectInterval, reconnectLimit);
        this.resourceVersion = new AtomicReference<String>(listOptions.getResourceVersion());
        this.forceClosed = new AtomicBoolean();
        this.receiveBookmarks = Boolean.TRUE.equals(listOptions.getAllowWatchBookmarks());
        if (listOptions.getAllowWatchBookmarks() == null) {
            listOptions.setAllowWatchBookmarks(Boolean.valueOf(true));
        }
        this.baseOperation = baseOperation;
        this.requestUrl = baseOperation.getNamespacedUrl();
        this.listOptions = listOptions;
        this.client = clientSupplier.get();
        this.startWatch();
    }

    protected abstract void start(URL var1, Map<String, String> var2, WatchRequestState var3);

    public void closeRequest() {
        Optional.ofNullable(this.latestRequestState).ifPresent(state -> ((WatchRequestState)state).closed.set(true));
        this.closeCurrentRequest();
    }

    protected abstract void closeCurrentRequest();

    final void close(WatcherException cause) {
        if (!this.forceClosed.compareAndSet(false, true)) {
            logger.debug("Ignoring duplicate firing of onClose event");
        } else {
            this.closeRequest();
            try {
                this.watcher.onClose(cause);
            }
            finally {
                this.close();
            }
        }
    }

    final void closeEvent() {
        if (this.forceClosed.getAndSet(true)) {
            logger.debug("Ignoring duplicate firing of onClose event");
            return;
        }
        this.watcher.onClose();
    }

    final synchronized void cancelReconnect() {
        if (this.reconnectAttempt != null) {
            this.reconnectAttempt.cancel(true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void scheduleReconnect(WatchRequestState state) {
        if (!state.reconnected.compareAndSet(false, true)) {
            return;
        }
        if (this.isForceClosed()) {
            logger.debug("Ignoring already closed/closing connection");
            return;
        }
        if (this.cannotReconnect()) {
            this.close(new WatcherException("Exhausted reconnects"));
            return;
        }
        logger.debug("Scheduling reconnect task");
        long delay = this.nextReconnectInterval();
        AbstractWatchManager abstractWatchManager = this;
        synchronized (abstractWatchManager) {
            this.reconnectAttempt = Utils.schedule((Executor)this.baseOperation.context.getExecutor(), this::reconnect, (long)delay, (TimeUnit)TimeUnit.MILLISECONDS);
            if (this.isForceClosed()) {
                this.cancelReconnect();
            }
        }
    }

    synchronized void reconnect() {
        try {
            this.startWatch();
            if (this.isForceClosed()) {
                this.closeRequest();
            }
        }
        catch (Exception e) {
            logger.error("Exception in reconnect", (Throwable)e);
            this.close(new WatcherException("Unhandled exception in reconnect attempt", (Throwable)e));
        }
    }

    final boolean cannotReconnect() {
        return !this.watcher.reconnecting() && this.retryIntervalCalculator.getCurrentReconnectAttempt() >= this.reconnectLimit && this.reconnectLimit >= 0;
    }

    final long nextReconnectInterval() {
        return this.retryIntervalCalculator.nextReconnectInterval();
    }

    void resetReconnectAttempts(WatchRequestState state) {
        if (state.closed.get()) {
            return;
        }
        this.retryIntervalCalculator.resetReconnectAttempts();
    }

    boolean isForceClosed() {
        return this.forceClosed.get();
    }

    void eventReceived(Watcher.Action action, HasMetadata resource) {
        if (!this.receiveBookmarks && action == Watcher.Action.BOOKMARK) {
            return;
        }
        if (resource != null && !this.baseOperation.getType().isAssignableFrom(resource.getClass())) {
            resource = (HasMetadata)Serialization.jsonMapper().convertValue((Object)resource, this.baseOperation.getType());
        }
        HasMetadata t = resource;
        try {
            this.watcher.eventReceived(action, (Object)t);
        }
        catch (Exception e) {
            logger.error("Unhandled exception encountered in watcher event handler", (Throwable)e);
        }
    }

    void updateResourceVersion(String newResourceVersion) {
        this.resourceVersion.set(newResourceVersion);
    }

    protected void startWatch() {
        this.listOptions.setResourceVersion(this.resourceVersion.get());
        URL url = BaseOperation.appendListOptionParams(this.requestUrl, this.listOptions);
        String origin = this.requestUrl.getProtocol() + "://" + this.requestUrl.getHost();
        if (this.requestUrl.getPort() != -1) {
            origin = origin + ":" + this.requestUrl.getPort();
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Origin", origin);
        logger.debug("Watching {}...", (Object)url);
        this.closeRequest();
        this.latestRequestState = new WatchRequestState();
        this.start(url, headers, this.latestRequestState);
    }

    public void close() {
        logger.debug("Force closing the watch {}", (Object)this);
        this.closeEvent();
        this.closeRequest();
        this.cancelReconnect();
    }

    private WatchEvent contextAwareWatchEventDeserializer(String messageSource) throws JsonProcessingException {
        try {
            return (WatchEvent)Serialization.unmarshal((String)messageSource, WatchEvent.class);
        }
        catch (Exception ex1) {
            JsonNode json = Serialization.jsonMapper().readTree(messageSource);
            JsonNode objectJson = null;
            if (json instanceof ObjectNode && json.has("object")) {
                objectJson = ((ObjectNode)json).remove("object");
            }
            WatchEvent watchEvent = (WatchEvent)Serialization.jsonMapper().treeToValue((TreeNode)json, WatchEvent.class);
            KubernetesResource object = (KubernetesResource)Serialization.jsonMapper().treeToValue((TreeNode)objectJson, this.baseOperation.getType());
            watchEvent.setObject(object);
            return watchEvent;
        }
    }

    protected void onMessage(String message, WatchRequestState state) {
        if (state.closed.get() || this.forceClosed.get()) {
            return;
        }
        try {
            WatchEvent event = this.contextAwareWatchEventDeserializer(message);
            KubernetesResource object = event.getObject();
            Watcher.Action action = Watcher.Action.valueOf((String)event.getType());
            if (action == Watcher.Action.ERROR) {
                if (object instanceof Status) {
                    Status status = (Status)object;
                    this.onStatus(status, state);
                } else {
                    logger.error("Error received, but object is not a status - will retry");
                    this.closeRequest();
                }
            } else if (object instanceof HasMetadata) {
                HasMetadata hasMetadata = (HasMetadata)object;
                this.updateResourceVersion(hasMetadata.getMetadata().getResourceVersion());
                this.eventReceived(action, hasMetadata);
            } else {
                String msg = String.format("Invalid object received: %s", message);
                this.close(new WatcherException(msg, null, message));
            }
        }
        catch (ClassCastException e) {
            String msg = "Received wrong type of object for watch";
            this.close(new WatcherException("Received wrong type of object for watch", (Throwable)e, message));
        }
        catch (JsonProcessingException e) {
            String msg = "Couldn't deserialize watch event: " + message;
            this.close(new WatcherException(msg, (Throwable)e, message));
        }
        catch (Exception e) {
            String msg = "Unexpected exception processing watch event";
            this.close(new WatcherException("Unexpected exception processing watch event", (Throwable)e, message));
        }
    }

    protected boolean onStatus(Status status, WatchRequestState state) {
        if (state.closed.get()) {
            return true;
        }
        if (status.getCode() == 410) {
            this.close(new WatcherException(status.getMessage(), (Throwable)new KubernetesClientException(status)));
            return true;
        }
        logger.error("Error received: {}, will retry", (Object)status);
        this.closeRequest();
        return false;
    }

    public static class WatchRequestState {
        private final AtomicBoolean reconnected = new AtomicBoolean();
        private final AtomicBoolean closed = new AtomicBoolean();
    }

    private static final class SerialWatcher<T>
    implements Watcher<T> {
        private final Watcher<T> watcher;
        SerialExecutor serialExecutor;

        private SerialWatcher(Watcher<T> watcher, SerialExecutor serialExecutor) {
            this.watcher = watcher;
            this.serialExecutor = serialExecutor;
        }

        public void eventReceived(Watcher.Action action, T resource) {
            this.serialExecutor.execute(() -> this.watcher.eventReceived(action, resource));
        }

        public void onClose(WatcherException cause) {
            this.serialExecutor.execute(() -> {
                this.watcher.onClose(cause);
                this.serialExecutor.shutdownNow();
            });
        }

        public void onClose() {
            this.serialExecutor.execute(() -> {
                this.watcher.onClose();
                this.serialExecutor.shutdownNow();
            });
        }

        public boolean reconnecting() {
            return this.watcher.reconnecting();
        }
    }
}

