/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.dsl.internal.core.v1;

import io.fabric8.kubernetes.api.model.Container;
import io.fabric8.kubernetes.api.model.DeleteOptions;
import io.fabric8.kubernetes.api.model.EphemeralContainer;
import io.fabric8.kubernetes.api.model.HasMetadata;
import io.fabric8.kubernetes.api.model.Pod;
import io.fabric8.kubernetes.api.model.PodCondition;
import io.fabric8.kubernetes.api.model.PodConditionBuilder;
import io.fabric8.kubernetes.api.model.PodList;
import io.fabric8.kubernetes.api.model.PodSpec;
import io.fabric8.kubernetes.api.model.PodStatus;
import io.fabric8.kubernetes.api.model.policy.v1beta1.Eviction;
import io.fabric8.kubernetes.api.model.policy.v1beta1.EvictionBuilder;
import io.fabric8.kubernetes.api.model.policy.v1beta1.EvictionFluent;
import io.fabric8.kubernetes.client.Client;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.kubernetes.client.LocalPortForward;
import io.fabric8.kubernetes.client.PortForward;
import io.fabric8.kubernetes.client.dsl.BytesLimitTerminateTimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.CopyOrReadable;
import io.fabric8.kubernetes.client.dsl.EphemeralContainersResource;
import io.fabric8.kubernetes.client.dsl.ExecListenable;
import io.fabric8.kubernetes.client.dsl.ExecListener;
import io.fabric8.kubernetes.client.dsl.ExecWatch;
import io.fabric8.kubernetes.client.dsl.Execable;
import io.fabric8.kubernetes.client.dsl.LogWatch;
import io.fabric8.kubernetes.client.dsl.Loggable;
import io.fabric8.kubernetes.client.dsl.PodResource;
import io.fabric8.kubernetes.client.dsl.PrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TimeTailPrettyLoggable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorChannelable;
import io.fabric8.kubernetes.client.dsl.TtyExecErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecOutputErrorable;
import io.fabric8.kubernetes.client.dsl.TtyExecable;
import io.fabric8.kubernetes.client.dsl.internal.ExecWebSocketListener;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.internal.HasMetadataOperationsImpl;
import io.fabric8.kubernetes.client.dsl.internal.LogWatchCallback;
import io.fabric8.kubernetes.client.dsl.internal.OperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PodOperationContext;
import io.fabric8.kubernetes.client.dsl.internal.PortForwarderWebsocket;
import io.fabric8.kubernetes.client.dsl.internal.uploadable.PodUpload;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.WebSocket;
import io.fabric8.kubernetes.client.lib.FilenameUtils;
import io.fabric8.kubernetes.client.utils.URLUtils;
import io.fabric8.kubernetes.client.utils.Utils;
import io.fabric8.kubernetes.client.utils.internal.OptionalDependencyWrapper;
import io.fabric8.kubernetes.client.utils.internal.PodOperationUtil;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PodOperationsImpl
extends HasMetadataOperation<Pod, PodList, PodResource>
implements PodResource,
EphemeralContainersResource,
CopyOrReadable {
    public static final int HTTP_TOO_MANY_REQUESTS = 429;
    public static final int DEFAULT_POD_READY_WAIT_TIMEOUT_MS = 5000;
    private static final String[] EMPTY_COMMAND = new String[]{"/bin/sh", "-i"};
    public static final String DEFAULT_CONTAINER_ANNOTATION_NAME = "kubectl.kubernetes.io/default-container";
    static final Logger LOG = LoggerFactory.getLogger(PodOperationsImpl.class);
    private final PodOperationContext podOperationContext;

    public PodOperationsImpl(Client client) {
        this(new PodOperationContext(), HasMetadataOperationsImpl.defaultContext(client));
    }

    public PodOperationsImpl(PodOperationContext context, OperationContext superContext) {
        super(superContext.withPlural("pods"), Pod.class, PodList.class);
        this.podOperationContext = context;
    }

    @Override
    public PodOperationsImpl newInstance(OperationContext context) {
        return new PodOperationsImpl(this.podOperationContext, context);
    }

    public PodOperationContext getContext() {
        return this.podOperationContext;
    }

    protected <T> T doGetLog(Class<T> type) {
        try {
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), this.podOperationContext.getLogParameters()));
            PodOperationUtil.waitUntilReadyOrTerminal(this, this.getContext().getReadyWaitTimeout() != null ? this.getContext().getReadyWaitTimeout() : 5000);
            return this.handleRawGet(url, type);
        }
        catch (IOException ioException) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("doGetLog"), (Throwable)ioException);
        }
    }

    @Override
    public String getLog() {
        return this.doGetLog(String.class);
    }

    @Override
    public Reader getLogReader() {
        return this.doGetLog(Reader.class);
    }

    @Override
    public InputStream getLogInputStream() {
        return this.doGetLog(InputStream.class);
    }

    @Override
    public String getLog(boolean isPretty) {
        return new PodOperationsImpl(this.getContext().withPrettyOutput(isPretty), this.context).getLog();
    }

    @Override
    public LogWatch watchLog() {
        return this.watchLog(null);
    }

    private void checkForPiped(Object object) {
        if (object instanceof PipedOutputStream || object instanceof PipedInputStream) {
            throw new KubernetesClientException("Piped streams should not be used");
        }
    }

    @Override
    public LogWatch watchLog(OutputStream out) {
        this.checkForPiped(out);
        try {
            PodOperationUtil.waitUntilReadyOrTerminal(this, this.getContext().getReadyWaitTimeout() != null ? this.getContext().getReadyWaitTimeout() : 5000);
            URL url = new URL(URLUtils.join(this.getResourceUrl().toString(), this.getContext().getLogParameters() + "&follow=true"));
            LogWatchCallback callback = new LogWatchCallback(out, this.context);
            return callback.callAndWait(this.httpClient, url);
        }
        catch (IOException ioException) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("watchLog"), (Throwable)ioException);
        }
    }

    @Override
    public PodOperationsImpl withReadyWaitTimeout(Integer logWaitTimeout) {
        return new PodOperationsImpl(this.getContext().withReadyWaitTimeout(logWaitTimeout), this.context);
    }

    @Override
    public Loggable withLogWaitTimeout(Integer logWaitTimeout) {
        return this.withReadyWaitTimeout(logWaitTimeout);
    }

    @Override
    public PortForward portForward(int port, ReadableByteChannel in, WritableByteChannel out) {
        try {
            return new PortForwarderWebsocket(this.httpClient, this.context.getExecutor(), this.getRequestConfig().getRequestTimeout().intValue()).forward(this.getResourceUrl(), port, in, out);
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public LocalPortForward portForward(int port) {
        return this.portForward(port, 0);
    }

    @Override
    public LocalPortForward portForward(int port, int localPort) {
        return this.portForward(port, null, localPort);
    }

    @Override
    public LocalPortForward portForward(int port, InetAddress localInetAddress, int localPort) {
        try {
            return new PortForwarderWebsocket(this.httpClient, this.context.getExecutor(), this.getRequestConfig().getRequestTimeout().intValue()).forward(this.getResourceUrl(), port, localInetAddress, localPort);
        }
        catch (MalformedURLException ex) {
            throw KubernetesClientException.launderThrowable(ex);
        }
    }

    @Override
    public boolean evict() {
        Eviction eviction = ((EvictionBuilder)((EvictionBuilder)((EvictionFluent.MetadataNested)((EvictionFluent.MetadataNested)new EvictionBuilder().withNewMetadata().withName(this.getName())).withNamespace(this.getNamespace())).endMetadata()).withDeleteOptions(new DeleteOptions())).build();
        return this.handleEvict((HasMetadata)eviction);
    }

    @Override
    public boolean evict(io.fabric8.kubernetes.api.model.policy.v1.Eviction eviction) {
        return this.handleEvict((HasMetadata)eviction);
    }

    private boolean handleEvict(HasMetadata eviction) {
        try {
            if (Utils.isNullOrEmpty(eviction.getMetadata().getNamespace())) {
                throw new KubernetesClientException("Namespace not specified, but operation requires it.");
            }
            if (Utils.isNullOrEmpty(eviction.getMetadata().getName())) {
                throw new KubernetesClientException("Name not specified, but operation requires it.");
            }
            URL requestUrl = new URL(URLUtils.join(this.getResourceUrl().toString(), "eviction"));
            HttpRequest.Builder requestBuilder = this.httpClient.newHttpRequestBuilder().post("application/json", this.getKubernetesSerialization().asJson(eviction)).url(requestUrl);
            this.handleResponse(requestBuilder, null);
            return true;
        }
        catch (KubernetesClientException e) {
            if (e.getCode() != 429) {
                throw e;
            }
            return false;
        }
        catch (IOException exception) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("evict"), (Throwable)exception);
        }
    }

    @Override
    public EphemeralContainersResource ephemeralContainers() {
        return new PodOperationsImpl(this.getContext(), this.context.withSubresource("ephemeralcontainers"));
    }

    @Override
    public PodOperationsImpl inContainer(String containerId) {
        return new PodOperationsImpl(this.getContext().withContainerId(containerId), this.context);
    }

    @Override
    public ExecWatch exec(String ... command) {
        String[] actualCommands = command.length >= 1 ? command : EMPTY_COMMAND;
        try {
            URL url = this.getURL("exec", actualCommands);
            return this.setupConnectionToPod(url.toURI());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("exec"), (Throwable)e);
        }
    }

    @Override
    public ExecWatch attach() {
        try {
            URL url = this.getURL("attach", null);
            return this.setupConnectionToPod(url.toURI());
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(this.forOperationType("attach"), (Throwable)e);
        }
    }

    private URL getURL(String operation, String[] commands) throws MalformedURLException {
        Pod fromServer = PodOperationUtil.waitUntilReadyOrTerminal(this, this.getContext().getReadyWaitTimeout() != null ? this.getContext().getReadyWaitTimeout() : 5000);
        String url = URLUtils.join(this.getResourceUrl().toString(), operation);
        URLUtils.URLBuilder httpUrlBuilder = new URLUtils.URLBuilder(url);
        if (commands != null) {
            for (String cmd : commands) {
                httpUrlBuilder.addQueryParameter("command", cmd);
            }
        }
        PodOperationContext contextToUse = this.getContext();
        contextToUse = contextToUse.withContainerId(this.validateOrDefaultContainerId(contextToUse.getContainerId(), fromServer));
        contextToUse.addQueryParameters(httpUrlBuilder);
        return httpUrlBuilder.build();
    }

    String validateOrDefaultContainerId(String name, Pod pod) {
        PodSpec spec;
        if (pod == null) {
            pod = (Pod)this.getItemOrRequireFromServer();
        }
        if ((spec = pod.getSpec()) == null) {
            spec = new PodSpec();
        }
        if (name == null) {
            List containers = spec.getContainers();
            if (containers == null || containers.isEmpty()) {
                throw new KubernetesClientException("Pod has no containers!");
            }
            name = (String)pod.getMetadata().getAnnotations().get(DEFAULT_CONTAINER_ANNOTATION_NAME);
            if (name != null && !this.hasContainer(containers, name)) {
                LOG.warn("Default container {} from annotation not found in pod {}", (Object)name, (Object)pod.getMetadata().getName());
                name = null;
            }
            if (name == null) {
                name = ((Container)containers.get(0)).getName();
                LOG.debug("using first container {} in pod {}", (Object)name, (Object)pod.getMetadata().getName());
            }
        } else if (!(this.hasContainer(spec.getContainers(), name) || this.hasContainer(spec.getInitContainers(), name) || this.hasEphemeralContainer(spec.getEphemeralContainers(), name))) {
            throw new KubernetesClientException(String.format("container %s not found in pod %s", name, pod.getMetadata().getName()));
        }
        return name;
    }

    private boolean hasContainer(List<Container> containers, String toFind) {
        return containers != null && containers.stream().map(Container::getName).anyMatch(s -> s.equals(toFind));
    }

    private boolean hasEphemeralContainer(List<EphemeralContainer> containers, String toFind) {
        return containers != null && containers.stream().map(EphemeralContainer::getName).anyMatch(s -> s.equals(toFind));
    }

    private ExecWebSocketListener setupConnectionToPod(URI uri) {
        ExecWebSocketListener execWebSocketListener = new ExecWebSocketListener(this.getContext(), this.context.getExecutor(), this.getKubernetesSerialization());
        CompletableFuture<WebSocket> startedFuture = this.httpClient.newWebSocketBuilder().subprotocol("v4.channel.k8s.io").uri(uri).connectTimeout(this.getRequestConfig().getRequestTimeout().intValue(), TimeUnit.MILLISECONDS).buildAsync(execWebSocketListener);
        startedFuture.whenComplete((w, t) -> {
            if (t != null) {
                execWebSocketListener.onError((WebSocket)w, (Throwable)t);
            }
        });
        Utils.waitUntilReadyOrFail(startedFuture, this.getRequestConfig().getRequestTimeout().intValue(), TimeUnit.MILLISECONDS);
        return execWebSocketListener;
    }

    @Override
    public PodOperationsImpl file(String file) {
        return new PodOperationsImpl(this.getContext().withFile(file), this.context);
    }

    @Override
    public PodOperationsImpl dir(String dir) {
        return new PodOperationsImpl(this.getContext().withDir(dir), this.context);
    }

    @Override
    public boolean copy(Path destination) {
        try {
            if (Utils.isNotNullOrEmpty(this.getContext().getFile())) {
                this.copyFile(this.getContext().getFile(), destination.toFile());
                return true;
            }
            if (Utils.isNotNullOrEmpty(this.getContext().getDir())) {
                this.copyDir(this.getContext().getDir(), destination.toFile());
                return true;
            }
            throw new IllegalStateException("No file or dir has been specified");
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    @Override
    public boolean upload(InputStream inputStream) {
        return OptionalDependencyWrapper.wrapRunWithOptionalDependency(() -> {
            try {
                return PodUpload.uploadFileData(this, inputStream);
            }
            catch (Exception ex) {
                throw KubernetesClientException.launderThrowable(ex);
            }
        }, "TarArchiveOutputStream is provided by commons-compress, an optional dependency. To use the read/copy functionality you must explicitly add commons-compress and commons-io dependency to the classpath.");
    }

    @Override
    public boolean upload(Path path) {
        return OptionalDependencyWrapper.wrapRunWithOptionalDependency(() -> {
            try {
                return PodUpload.upload(this, path);
            }
            catch (Exception ex) {
                throw KubernetesClientException.launderThrowable(ex);
            }
        }, "TarArchiveOutputStream is provided by commons-compress, an optional dependency. To use the read/copy functionality you must explicitly add commons-compress and commons-io dependency to the classpath.");
    }

    @Override
    public InputStream read() {
        try {
            if (Utils.isNotNullOrEmpty(this.getContext().getFile())) {
                return this.readFile(this.getContext().getFile());
            }
            if (Utils.isNotNullOrEmpty(this.getContext().getDir())) {
                return this.readTar(this.getContext().getDir());
            }
            throw new IllegalStateException("No file or dir has been specified");
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    private String[] readFileCommand(String source) {
        return new String[]{"sh", "-c", String.format("cat %s", PodOperationsImpl.shellQuote(source))};
    }

    private InputStream readFile(String source) {
        return this.read(this.readFileCommand(source));
    }

    private void copyFile(String source, File target) {
        File destination = target;
        if (!(destination.exists() || destination.getParentFile().exists() || destination.getParentFile().mkdirs())) {
            throw KubernetesClientException.launderThrowable(new IOException("Failed to create directory: " + destination.getParentFile()));
        }
        if (destination.isDirectory()) {
            String[] parts = source.split("\\/|\\\\");
            String filename = parts[parts.length - 1];
            destination = destination.toPath().resolve(filename).toFile();
        }
        try (BufferedOutputStream out = new BufferedOutputStream(Files.newOutputStream(destination.toPath(), new OpenOption[0]));){
            ExecWatch w = this.writingOutput(out).exec(this.readFileCommand(source));
            w.exitCode().get();
        }
        catch (Exception e) {
            throw KubernetesClientException.launderThrowable(e);
        }
    }

    public InputStream readTar(String source) {
        return this.read("sh", "-c", "tar -cf - " + PodOperationsImpl.shellQuote(source));
    }

    private InputStream read(String ... command) {
        ExecWatch watch = this.redirectingOutput().exec(command);
        return watch.getOutput();
    }

    private void copyDir(final String source, final File target) throws Exception {
        try {
            new Runnable(){

                @Override
                public void run() {
                    File destination = target;
                    if (!destination.isDirectory() && !destination.mkdirs()) {
                        throw KubernetesClientException.launderThrowable(new IOException("Failed to create directory: " + destination));
                    }
                    try (InputStream is = PodOperationsImpl.this.readTar(source);
                         TarArchiveInputStream tis = new TarArchiveInputStream(is);){
                        TarArchiveEntry entry = tis.getNextTarEntry();
                        while (entry != null) {
                            if (tis.canReadEntryData((ArchiveEntry)entry)) {
                                String normalizedEntryName = FilenameUtils.normalize(entry.getName());
                                if (normalizedEntryName == null) {
                                    throw new IOException("Tar entry '" + entry.getName() + "' has an invalid name");
                                }
                                File f = new File(destination, normalizedEntryName);
                                if (entry.isDirectory()) {
                                    if (!f.isDirectory() && !f.mkdirs()) {
                                        throw new IOException("Failed to create directory: " + f);
                                    }
                                } else {
                                    File parent = f.getParentFile();
                                    if (!parent.isDirectory() && !parent.mkdirs()) {
                                        throw new IOException("Failed to create directory: " + f);
                                    }
                                    Files.copy((InputStream)tis, f.toPath(), StandardCopyOption.REPLACE_EXISTING);
                                }
                            }
                            entry = tis.getNextEntry();
                        }
                    }
                    catch (Exception e) {
                        throw KubernetesClientException.launderThrowable(e);
                    }
                }
            }.run();
        }
        catch (NoClassDefFoundError e) {
            throw new KubernetesClientException("TarArchiveInputStream class is provided by commons-compress, an optional dependency. To use the read/copy functionality you must explicitly add commons-compress and commons-io dependency to the classpath.");
        }
    }

    @Override
    public TtyExecOutputErrorable readingInput(InputStream in) {
        this.checkForPiped(in);
        return new PodOperationsImpl(this.getContext().withIn(in), this.context);
    }

    @Override
    public PodOperationsImpl redirectingInput() {
        return this.redirectingInput(null);
    }

    @Override
    public PodOperationsImpl redirectingInput(Integer bufferSize) {
        return new PodOperationsImpl(this.getContext().toBuilder().redirectingIn(true).bufferSize(bufferSize).build(), this.context);
    }

    @Override
    public TtyExecErrorable writingOutput(OutputStream out) {
        this.checkForPiped(out);
        return new PodOperationsImpl(this.getContext().toBuilder().output(new PodOperationContext.StreamContext(out)).build(), this.context);
    }

    @Override
    public TtyExecErrorable redirectingOutput() {
        return new PodOperationsImpl(this.getContext().toBuilder().output(new PodOperationContext.StreamContext()).build(), this.context);
    }

    @Override
    public TtyExecErrorChannelable writingError(OutputStream err) {
        this.checkForPiped(err);
        return new PodOperationsImpl(this.getContext().toBuilder().error(new PodOperationContext.StreamContext(err)).build(), this.context);
    }

    @Override
    public TtyExecErrorChannelable redirectingError() {
        return new PodOperationsImpl(this.getContext().toBuilder().error(new PodOperationContext.StreamContext()).build(), this.context);
    }

    @Override
    public TtyExecable writingErrorChannel(OutputStream errChannel) {
        this.checkForPiped(errChannel);
        return new PodOperationsImpl(this.getContext().toBuilder().errorChannel(new PodOperationContext.StreamContext(errChannel)).build(), this.context);
    }

    @Override
    public TtyExecable redirectingErrorChannel() {
        return new PodOperationsImpl(this.getContext().toBuilder().errorChannel(new PodOperationContext.StreamContext()).build(), this.context);
    }

    @Override
    public ExecListenable withTTY() {
        return new PodOperationsImpl(this.getContext().withTty(true), this.context);
    }

    @Override
    public Loggable withPrettyOutput() {
        return new PodOperationsImpl(this.getContext().withPrettyOutput(true), this.context);
    }

    @Override
    public PrettyLoggable tailingLines(int withTailingLines) {
        return new PodOperationsImpl(this.getContext().withTailingLines(withTailingLines), this.context);
    }

    @Override
    public TailPrettyLoggable sinceTime(String sinceTimestamp) {
        return new PodOperationsImpl(this.getContext().withSinceTimestamp(sinceTimestamp), this.context);
    }

    @Override
    public TailPrettyLoggable sinceSeconds(int sinceSeconds) {
        return new PodOperationsImpl(this.getContext().withSinceSeconds(sinceSeconds), this.context);
    }

    @Override
    public TimeTailPrettyLoggable terminated() {
        return new PodOperationsImpl(this.getContext().withTerminatedStatus(true), this.context);
    }

    @Override
    public Execable usingListener(ExecListener execListener) {
        return new PodOperationsImpl(this.getContext().withExecListener(execListener), this.context);
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable limitBytes(int limitBytes) {
        return new PodOperationsImpl(this.getContext().withLimitBytes(limitBytes), this.context);
    }

    @Override
    public BytesLimitTerminateTimeTailPrettyLoggable usingTimestamps() {
        return new PodOperationsImpl(this.getContext().withTimestamps(true), this.context);
    }

    public static String shellQuote(String value) {
        return "'" + value.replace("'", "'\\''") + "'";
    }

    @Override
    public PodOperationsImpl terminateOnError() {
        return new PodOperationsImpl(this.getContext().toBuilder().terminateOnError(true).build(), this.context);
    }

    @Override
    public Pod patchReadinessGateStatus(Map<String, Boolean> readiness) {
        LinkedHashMap<String, PodCondition> conditions = new LinkedHashMap<String, PodCondition>();
        Pod pod = (Pod)this.getItemOrRequireFromServer();
        if (pod.getStatus() == null) {
            pod.setStatus(new PodStatus());
        }
        pod.getStatus().getConditions().forEach(pc -> conditions.put(pc.getType(), (PodCondition)pc));
        for (Map.Entry<String, Boolean> entry : readiness.entrySet()) {
            String valueString;
            if (entry.getValue() == null) {
                conditions.remove(entry.getKey());
                continue;
            }
            PodCondition condition = (PodCondition)conditions.get(entry.getKey());
            String string = valueString = entry.getValue() != false ? "True" : "False";
            if (condition == null) {
                conditions.put(entry.getKey(), ((PodConditionBuilder)((PodConditionBuilder)new PodConditionBuilder().withStatus(valueString)).withType(entry.getKey())).build());
                continue;
            }
            condition.setStatus(valueString);
        }
        pod.getStatus().setConditions(new ArrayList(conditions.values()));
        return (Pod)((PodResource)this.resource(pod)).subresource("status").patch();
    }
}

