/**
 * Copyright (C) 2015 Red Hat, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *         http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package io.fabric8.kubernetes.client;

import okhttp3.OkHttpClient;

public class V2beta2AutoscalingAPIGroupExtensionAdapter extends APIGroupExtensionAdapter<V2beta2AutoscalingAPIGroupClient> {

  @Override
  protected String getAPIGroupName() {
    return "autoscaling/v2beta2";
  }

  @Override
  public Class<V2beta2AutoscalingAPIGroupClient> getExtensionType() {
    return V2beta2AutoscalingAPIGroupClient.class;
  }

  @Override
  protected V2beta2AutoscalingAPIGroupClient newInstance(Client client) {
    return new V2beta2AutoscalingAPIGroupClient(client.adapt(OkHttpClient.class), client.getConfiguration());
  }

}
