
                                          

package io.fabric8.kubernetes.client.handlers.batch.v1beta1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.batch.v1beta1.CronJobOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJob;
import io.fabric8.kubernetes.api.model.batch.v1beta1.CronJobBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class CronJobHandler implements ResourceHandler<CronJob, CronJobBuilder> {

  @Override
  public String getKind() {
    return CronJob.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "batch/v1beta1";
      }

  @Override
  public CronJob create(OkHttpClient client, Config config, String namespace, CronJob item, boolean dryRun) {
    return new CronJobOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public CronJob replace(OkHttpClient client, Config config, String namespace, CronJob item, boolean dryRun) {
    return new CronJobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public CronJob reload(OkHttpClient client, Config config, String namespace, CronJob item) {
    return new CronJobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public CronJobBuilder edit(CronJob item) {
    return new CronJobBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, CronJob item, boolean dryRun) {
    return new CronJobOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CronJob item, Watcher<CronJob> watcher) {
    return new CronJobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CronJob item, String resourceVersion, Watcher<CronJob> watcher) {
    return new CronJobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, CronJob item, ListOptions options, Watcher<CronJob> watcher) {
    return new CronJobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public CronJob waitUntilReady(OkHttpClient client, Config config, String namespace, CronJob item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CronJobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public CronJob waitUntilCondition(OkHttpClient client, Config config, String namespace, CronJob item, Predicate<CronJob> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new CronJobOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
