
                                          
  

package io.fabric8.kubernetes.client.dsl.internal.admissionregistration.v1beta1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationBuilder;
import io.fabric8.kubernetes.api.model.admissionregistration.v1beta1.ValidatingWebhookConfigurationList;

import java.util.Map;
import java.util.TreeMap;


public class ValidatingWebhookConfigurationOperationsImpl extends HasMetadataOperation<ValidatingWebhookConfiguration, ValidatingWebhookConfigurationList, Resource<ValidatingWebhookConfiguration>> {

  public ValidatingWebhookConfigurationOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public ValidatingWebhookConfigurationOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public ValidatingWebhookConfigurationOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("admissionregistration.k8s.io")
    .withApiGroupVersion("v1beta1")
    .withPlural("validatingwebhookconfigurations"));
    this.type = ValidatingWebhookConfiguration.class;
    this.listType = ValidatingWebhookConfigurationList.class;
  }

  public ValidatingWebhookConfigurationOperationsImpl newInstance(OperationContext context) {
    return new ValidatingWebhookConfigurationOperationsImpl(context);
  }

  @Override
  public ValidatingWebhookConfiguration edit(Visitor... visitors) {
    return patch(new ValidatingWebhookConfigurationBuilder(getMandatory()).accept(visitors).build());
  }

  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
