
                                          

package io.fabric8.kubernetes.client.handlers.scheduling.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.scheduling.v1.PriorityClassOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClass;
import io.fabric8.kubernetes.api.model.scheduling.v1.PriorityClassBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class PriorityClassHandler implements ResourceHandler<PriorityClass, PriorityClassBuilder> {

  @Override
  public String getKind() {
    return PriorityClass.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "scheduling.k8s.io/v1";
      }

  @Override
  public PriorityClass create(OkHttpClient client, Config config, String namespace, PriorityClass item, boolean dryRun) {
    return new PriorityClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).dryRun(dryRun).create();
  }

  @Override
  public PriorityClass replace(OkHttpClient client, Config config, String namespace, PriorityClass item, boolean dryRun) {
    return new PriorityClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).dryRun(dryRun).replace(item);
  }

  @Override
  public PriorityClass reload(OkHttpClient client, Config config, String namespace, PriorityClass item) {
    return new PriorityClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public PriorityClassBuilder edit(PriorityClass item) {
    return new PriorityClassBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, long gracePeriodSeconds, PriorityClass item, boolean dryRun) {
    return new PriorityClassOperationsImpl(client, config, namespace).withItem(item).dryRun(dryRun).withPropagationPolicy(propagationPolicy).withGracePeriod(gracePeriodSeconds).delete();
  }

@Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PriorityClass item, Watcher<PriorityClass> watcher) {
    return new PriorityClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PriorityClass item, String resourceVersion, Watcher<PriorityClass> watcher) {
    return new PriorityClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, PriorityClass item, ListOptions options, Watcher<PriorityClass> watcher) {
    return new PriorityClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public PriorityClass waitUntilReady(OkHttpClient client, Config config, String namespace, PriorityClass item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PriorityClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public PriorityClass waitUntilCondition(OkHttpClient client, Config config, String namespace, PriorityClass item, Predicate<PriorityClass> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new PriorityClassOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
