
                                          
  

package io.fabric8.kubernetes.client.dsl.internal.storage.v1;

import io.fabric8.kubernetes.api.builder.Visitor;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.base.HasMetadataOperation;
import io.fabric8.kubernetes.client.dsl.NonNamespaceOperation;
import io.fabric8.kubernetes.client.utils.ApiVersionUtil;
import io.fabric8.kubernetes.client.dsl.base.OperationContext;

import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.storage.CSIDriver;
import io.fabric8.kubernetes.api.model.storage.CSIDriverBuilder;
import io.fabric8.kubernetes.api.model.storage.CSIDriverList;

import java.util.Map;
import java.util.TreeMap;


public class CSIDriverOperationsImpl extends HasMetadataOperation<CSIDriver, CSIDriverList, Resource<CSIDriver>> {

  public CSIDriverOperationsImpl(OkHttpClient client, Config config) {
    this(client, config, null);
  }

  public CSIDriverOperationsImpl(OkHttpClient client, Config config, String namespace) {
    this(new OperationContext().withOkhttpClient(client).withConfig(config).withNamespace(namespace).withPropagationPolicy(DEFAULT_PROPAGATION_POLICY));
  }

  public CSIDriverOperationsImpl(OperationContext context) {
    super(context.withApiGroupName("storage.k8s.io")
    .withApiGroupVersion("v1")
    .withPlural("csidrivers"));
    this.type = CSIDriver.class;
    this.listType = CSIDriverList.class;
  }

  public CSIDriverOperationsImpl newInstance(OperationContext context) {
    return new CSIDriverOperationsImpl(context);
  }

  @Override
  public CSIDriver edit(Visitor... visitors) {
    return patch(new CSIDriverBuilder(getMandatory()).accept(visitors).build());
  }

  @Override
  public boolean isResourceNamespaced() {
    return false;
  }
}
