package io.fabric8.kubernetes.client;

import io.fabric8.kubernetes.api.model.ObjectMeta;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.lang.Deprecated;
import io.fabric8.kubernetes.api.builder.Fluent;
import java.lang.String;
import java.lang.Boolean;
import org.slf4j.Logger;

  
  /**
   * A base class for implementing a custom resource kind. Implementations must be annotated with
   * {@link io.fabric8.kubernetes.model.annotation.Group} and {@link io.fabric8.kubernetes.model.annotation.Version}.
   * Properties are set up automatically as follows:
   * <ul>
   * <li>group is set using {@link io.fabric8.kubernetes.api.model.HasMetadata#getGroup(Class)}</li>
   * <li>version is set using {@link io.fabric8.kubernetes.api.model.HasMetadata#getVersion(Class)}</li>
   * <li>singular is set using {@link io.fabric8.kubernetes.api.model.HasMetadata#getSingular(Class)}</li>
   * <li>plural is set using {@link io.fabric8.kubernetes.api.model.HasMetadata#getPlural(Class)}</li>
   * <li>computed CRD name using {@link CustomResource#getCRDName(Class)}</li>
   * </ul>
   * In addition, {@link CustomResource#setApiVersion(String)} and {@link CustomResource#setKind(String)} are overridden to not do anything since these values
   * are set.
   * @param <S> the class providing the {@code Spec} part of this CustomResource
   * @param <T> the class providing the {@code Status} part of this CustomResource
   */
  public interface CustomResourceFluent<S,T,A extends io.fabric8.kubernetes.client.CustomResourceFluent<S,T,A>> extends io.fabric8.kubernetes.api.builder.Fluent<A> {


    public io.fabric8.kubernetes.api.model.ObjectMeta getMetadata();
    public A withMetadata(io.fabric8.kubernetes.api.model.ObjectMeta metadata);
    public java.lang.Boolean hasMetadata();
    public S getSpec();
    public A withSpec(S spec);
    public java.lang.Boolean hasSpec();
    public T getStatus();
    public A withStatus(T status);
    public java.lang.Boolean hasStatus();
    public java.lang.String getKind();
    public A withKind(java.lang.String kind);
    public java.lang.Boolean hasKind();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withKind instead.
     */
        public A withNewKind(java.lang.String arg0);
    public java.lang.String getApiVersion();
    public A withApiVersion(java.lang.String apiVersion);
    public java.lang.Boolean hasApiVersion();
    
    @java.lang.Deprecated
        
    /**
     * Method is deprecated. use withApiVersion instead.
     */
        public A withNewApiVersion(java.lang.String arg0);
}
