/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.http;

import io.fabric8.kubernetes.client.http.HttpHeaders;
import io.fabric8.kubernetes.client.http.HttpRequest;
import io.fabric8.kubernetes.client.http.HttpStatusMessage;
import io.fabric8.kubernetes.client.utils.IOHelpers;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Optional;

public interface HttpResponse<T>
extends HttpHeaders {
    default public boolean isSuccessful() {
        return HttpResponse.isSuccessful(this.code());
    }

    public static boolean isSuccessful(int code) {
        return code >= 200 && code < 300;
    }

    public int code();

    default public String message() {
        return HttpStatusMessage.getMessageForStatus(this.code());
    }

    public T body();

    default public String bodyString() throws IOException {
        T body = this.body();
        if (body == null) {
            return "";
        }
        if (body instanceof String) {
            return (String)body;
        }
        if (body instanceof Reader) {
            return IOHelpers.readFully((Reader)body);
        }
        return IOHelpers.readFully((InputStream)body, StandardCharsets.UTF_8);
    }

    public HttpRequest request();

    public Optional<HttpResponse<T>> previousResponse();
}

