/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.client.handlers.rbac.v1;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.rbac.Role;
import io.fabric8.kubernetes.api.model.rbac.RoleBuilder;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.Gettable;
import io.fabric8.kubernetes.client.dsl.Resource;
import io.fabric8.kubernetes.client.dsl.internal.rbac.v1.RoleOperationsImpl;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import okhttp3.OkHttpClient;

public class RoleHandler
implements ResourceHandler<Role, RoleBuilder> {
    @Override
    public String getKind() {
        return Role.class.getSimpleName();
    }

    @Override
    public String getApiVersion() {
        return "rbac.authorization.k8s.io/v1";
    }

    @Override
    public Role create(OkHttpClient client, Config config, String namespace, Role item) {
        return (Role)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).create(new Role[0]);
    }

    @Override
    public Role replace(OkHttpClient client, Config config, String namespace, Role item) {
        return (Role)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).replace(item);
    }

    @Override
    public Role reload(OkHttpClient client, Config config, String namespace, Role item) {
        return (Role)((Gettable)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).fromServer()).get();
    }

    @Override
    public RoleBuilder edit(Role item) {
        return new RoleBuilder(item);
    }

    @Override
    public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, Role item) {
        return (Boolean)new RoleOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Role item, Watcher<Role> watcher) {
        return (Watch)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Role item, String resourceVersion, Watcher<Role> watcher) {
        return (Watch)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(resourceVersion, watcher);
    }

    @Override
    public Watch watch(OkHttpClient client, Config config, String namespace, Role item, ListOptions options, Watcher<Role> watcher) {
        return (Watch)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).watch(options, watcher);
    }

    @Override
    public Role waitUntilReady(OkHttpClient client, Config config, String namespace, Role item, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Role)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilReady(amount, timeUnit);
    }

    @Override
    public Role waitUntilCondition(OkHttpClient client, Config config, String namespace, Role item, Predicate<Role> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
        return (Role)((Resource)new RoleOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName())).waitUntilCondition(condition, amount, timeUnit);
    }
}

