
                                          

package io.fabric8.kubernetes.client.handlers.admissionregistration.v1;

import java.util.function.Predicate;

import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ResourceHandler;
import io.fabric8.kubernetes.client.Watch;
import io.fabric8.kubernetes.client.Watcher;
import io.fabric8.kubernetes.client.dsl.internal.admissionregistration.v1.ValidatingWebhookConfigurationOperationsImpl;

import io.fabric8.kubernetes.client.dsl.base.OperationContext;
import okhttp3.OkHttpClient;

import io.fabric8.kubernetes.api.model.DeletionPropagation;
import io.fabric8.kubernetes.api.model.ListOptions;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingWebhookConfiguration;
import io.fabric8.kubernetes.api.model.admissionregistration.v1.ValidatingWebhookConfigurationBuilder;

import java.util.TreeMap;
import java.util.concurrent.TimeUnit;

public class ValidatingWebhookConfigurationHandler implements ResourceHandler<ValidatingWebhookConfiguration, ValidatingWebhookConfigurationBuilder> {

  @Override
  public String getKind() {
    return ValidatingWebhookConfiguration.class.getSimpleName();
  }

  @Override
  public String getApiVersion() {
        return "admissionregistration.k8s.io/v1";
      }

  @Override
  public ValidatingWebhookConfiguration create(OkHttpClient client, Config config, String namespace, ValidatingWebhookConfiguration item) {
    return new ValidatingWebhookConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).create();
  }

  @Override
  public ValidatingWebhookConfiguration replace(OkHttpClient client, Config config, String namespace, ValidatingWebhookConfiguration item) {
    return new ValidatingWebhookConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).replace(item);
  }

  @Override
  public ValidatingWebhookConfiguration reload(OkHttpClient client, Config config, String namespace, ValidatingWebhookConfiguration item) {
    return new ValidatingWebhookConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).fromServer().get();
  }

  @Override
  public ValidatingWebhookConfigurationBuilder edit(ValidatingWebhookConfiguration item) {
    return new ValidatingWebhookConfigurationBuilder(item);
  }

  @Override
  public Boolean delete(OkHttpClient client, Config config, String namespace, DeletionPropagation propagationPolicy, ValidatingWebhookConfiguration item) {
    return new ValidatingWebhookConfigurationOperationsImpl(client, config, namespace).withItem(item).withPropagationPolicy(propagationPolicy).delete();
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ValidatingWebhookConfiguration item, Watcher<ValidatingWebhookConfiguration> watcher) {
    return new ValidatingWebhookConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ValidatingWebhookConfiguration item, String resourceVersion, Watcher<ValidatingWebhookConfiguration> watcher) {
    return new ValidatingWebhookConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(resourceVersion, watcher);
  }

  @Override
  public Watch watch(OkHttpClient client, Config config, String namespace, ValidatingWebhookConfiguration item, ListOptions options, Watcher<ValidatingWebhookConfiguration> watcher) {
    return new ValidatingWebhookConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).watch(options, watcher);
  }

  @Override
  public ValidatingWebhookConfiguration waitUntilReady(OkHttpClient client, Config config, String namespace, ValidatingWebhookConfiguration item, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ValidatingWebhookConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilReady(amount, timeUnit);
  }

  @Override
  public ValidatingWebhookConfiguration waitUntilCondition(OkHttpClient client, Config config, String namespace, ValidatingWebhookConfiguration item, Predicate<ValidatingWebhookConfiguration> condition, long amount, TimeUnit timeUnit) throws InterruptedException {
    return new ValidatingWebhookConfigurationOperationsImpl(client, config).withItem(item).inNamespace(namespace).withName(item.getMetadata().getName()).waitUntilCondition(condition, amount, timeUnit);
  }
}
